/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.ajax;

import java.util.UUID;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxCallListener;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnLoadHeaderItem;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;
import org.danekja.java.util.function.serializable.SerializableConsumer;

public class AjaxNewWindowNotifyingBehavior
extends AbstractDefaultAjaxBehavior {
    private static final long serialVersionUID = 1L;
    private static final String PARAM_WINDOW_NAME = "windowName";
    private String boundName;

    public String getWindowName() {
        return this.boundName;
    }

    @Override
    protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
        super.updateAjaxAttributes(attributes);
        String parameter = "return {'windowName': window.name}";
        attributes.getDynamicExtraParameters().add(parameter);
        if (this.boundName != null) {
            attributes.getAjaxCallListeners().add(new AjaxCallListener(){

                @Override
                public CharSequence getPrecondition(Component component) {
                    return String.format("return (window.name !== '%s');", AjaxNewWindowNotifyingBehavior.this.boundName);
                }
            });
        }
    }

    @Override
    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        response.render(OnLoadHeaderItem.forScript("setTimeout(function() {" + this.getCallbackScript().toString() + "}, 30);"));
    }

    @Override
    protected void respond(AjaxRequestTarget target) {
        String windowName = this.getComponent().getRequest().getRequestParameters().getParameterValue(PARAM_WINDOW_NAME).toString();
        if (this.boundName == null) {
            if (Strings.isEmpty(windowName)) {
                windowName = this.newWindowName();
                target.appendJavaScript(String.format("window.name = '%s';", windowName));
            }
            this.boundName = windowName;
        } else if (!this.boundName.equals(windowName)) {
            this.onNewWindow(target);
        }
    }

    protected String newWindowName() {
        return UUID.randomUUID().toString();
    }

    protected void onNewWindow(AjaxRequestTarget target) {
        Page page = this.getComponent().getPage();
        this.getComponent().setResponsePage(page.getClass(), page.getPageParameters());
    }

    public static AjaxNewWindowNotifyingBehavior onNewWindow(final SerializableConsumer<AjaxRequestTarget> onNewWindow) {
        Args.notNull(onNewWindow, "onNewWindow");
        return new AjaxNewWindowNotifyingBehavior(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onNewWindow(AjaxRequestTarget target) {
                onNewWindow.accept(target);
            }
        };
    }
}

