/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.JavaTokenNode;
import com.strobel.decompiler.languages.java.ast.NodeType;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.languages.java.ast.TokenRole;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;
import com.strobel.decompiler.patterns.Role;

public class CaseLabel
extends AstNode {
    public static final TokenRole CASE_KEYWORD_ROLE = new TokenRole("case", 1);
    public static final TokenRole DEFAULT_KEYWORD_ROLE = new TokenRole("default", 1);

    public CaseLabel() {
    }

    public CaseLabel(Expression value) {
        this.setExpression(value);
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.UNKNOWN;
    }

    public Role<? extends CaseLabel> getRole() {
        return super.getRole();
    }

    public final JavaTokenNode getColonToken() {
        return this.getChildByRole(Roles.COLON);
    }

    public final Expression getExpression() {
        return this.getChildByRole(Roles.EXPRESSION);
    }

    public final void setExpression(Expression value) {
        this.setChildByRole(Roles.EXPRESSION, value);
    }

    @Override
    public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
        return visitor.visitCaseLabel(this, data);
    }

    @Override
    public boolean matches(INode other, Match match) {
        return other instanceof CaseLabel && !other.isNull() && this.getExpression().matches(((CaseLabel)other).getExpression(), match);
    }
}

