/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.apache.streampipes.test.executors;

import java.util.List;
import java.util.Map;

public class TestConfiguration {

  private final Map<String, Object> fieldConfiguration;

  private final List<String> prefixes;

  // This variables is used to configure the custom output strategy for a test
  private List<String> customOutputProperties;

  public TestConfiguration(
      Map<String, Object> fieldConfiguration,
      List<String> eventPrefixes
  ) {
    this.fieldConfiguration = fieldConfiguration;
    this.prefixes = eventPrefixes;
    this.customOutputProperties = List.of();
  }

  public Map<String, Object> getFieldConfiguration() {
    return fieldConfiguration;
  }

  public List<String> getPrefixes() {
    return prefixes;
  }

  public static TestConfigurationBuilder builder() {
    return new TestConfigurationBuilder();
  }

  public List<String> getCustomOutputProperties() {
    return customOutputProperties;
  }

  public void setCustomOutputProperties(List<String> customOutputProperties) {
    this.customOutputProperties = customOutputProperties;
  }
}
