/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.permission;

import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.tree.TreeProvider;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionUtil;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionValidator;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionValidatorProvider;
import org.apache.jackrabbit.oak.spi.commit.EditorDiff;
import org.apache.jackrabbit.oak.spi.commit.MoveTracker;
import org.apache.jackrabbit.oak.spi.commit.Validator;
import org.apache.jackrabbit.oak.spi.commit.VisibleValidator;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.TreePermission;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveAwarePermissionValidator
extends PermissionValidator {
    private final MoveContext moveCtx;

    MoveAwarePermissionValidator(@NotNull NodeState rootBefore, @NotNull NodeState rootAfter, @NotNull PermissionProvider permissionProvider, @NotNull PermissionValidatorProvider provider, @NotNull MoveTracker moveTracker) {
        super(rootBefore, rootAfter, permissionProvider, provider);
        this.moveCtx = new MoveContext(moveTracker, provider.createReadOnlyRoot(rootBefore), provider.createReadOnlyRoot(rootAfter));
    }

    private MoveAwarePermissionValidator(@Nullable Tree parentBefore, @Nullable Tree parentAfter, @NotNull TreePermission parentPermission, @NotNull PermissionValidator parentValidator) {
        super(parentBefore, parentAfter, parentPermission, parentValidator);
        MoveAwarePermissionValidator pv = (MoveAwarePermissionValidator)parentValidator;
        this.moveCtx = pv.moveCtx;
    }

    @Override
    @NotNull
    PermissionValidator createValidator(@Nullable Tree parentBefore, @Nullable Tree parentAfter, @NotNull TreePermission parentPermission, @NotNull PermissionValidator parentValidator) {
        if (this.moveCtx.containsMove(parentBefore, parentAfter)) {
            return new MoveAwarePermissionValidator(parentBefore, parentAfter, parentPermission, parentValidator);
        }
        return super.createValidator(parentBefore, parentAfter, parentPermission, parentValidator);
    }

    private Validator visibleValidator(@NotNull Tree source, @NotNull Tree dest) {
        Tree immutableTree = this.moveCtx.rootBefore.getTree("/");
        TreePermission tp = this.getPermissionProvider().getTreePermission(immutableTree, TreePermission.EMPTY);
        for (String n : PathUtils.elements(source.getPath())) {
            immutableTree = immutableTree.getChild(n);
            tp = tp.getChildPermission(n, this.getTreeProvider().asNodeState(immutableTree));
        }
        PermissionValidator validator = this.createValidator(source, dest, tp, this);
        return new VisibleValidator(validator, true, false);
    }

    @Override
    public Validator childNodeAdded(String name, NodeState after) throws CommitFailedException {
        if (this.moveCtx.processAdd(this.getParentAfter(), name, this)) {
            return null;
        }
        return super.childNodeAdded(name, after);
    }

    @Override
    public Validator childNodeDeleted(String name, NodeState before) throws CommitFailedException {
        if (this.moveCtx.processDelete(this.getParentBefore(), name, this)) {
            return null;
        }
        return super.childNodeDeleted(name, before);
    }

    private final class MoveContext {
        private final MoveTracker moveTracker;
        private final Root rootBefore;
        private final Root rootAfter;

        private MoveContext(@NotNull MoveTracker moveTracker, @NotNull Root before, Root after) {
            this.moveTracker = moveTracker;
            this.rootBefore = before;
            this.rootAfter = after;
        }

        private boolean containsMove(@Nullable Tree parentBefore, @Nullable Tree parentAfter) {
            return this.moveTracker.containsMove(PermissionUtil.getPath(parentBefore, parentAfter));
        }

        private boolean processAdd(@Nullable Tree parent, @NotNull String name, @NotNull MoveAwarePermissionValidator validator) throws CommitFailedException {
            Tree source;
            if (parent == null) {
                return false;
            }
            Tree child = parent.getChild(name);
            String sourcePath = this.moveTracker.getSourcePath(child.getPath());
            if (sourcePath != null && (source = this.rootBefore.getTree(sourcePath)).exists()) {
                validator.checkPermissions(child, false, 544L);
                this.checkPermissions(source, 64L);
                return this.diff(source, child, validator);
            }
            return false;
        }

        private boolean processDelete(@Nullable Tree parent, @NotNull String name, @NotNull MoveAwarePermissionValidator validator) throws CommitFailedException {
            Tree dest;
            if (parent == null) {
                return false;
            }
            Tree child = parent.getChild(name);
            String destPath = this.moveTracker.getDestPath(child.getPath());
            if (destPath != null && (dest = this.rootAfter.getTree(destPath)).exists()) {
                validator.checkPermissions(child, true, 64L);
                this.checkPermissions(dest, 544L);
                return this.diff(child, dest, validator);
            }
            return false;
        }

        private boolean diff(@NotNull Tree source, @NotNull Tree dest, @NotNull MoveAwarePermissionValidator validator) throws CommitFailedException {
            TreeProvider tp;
            Validator nextValidator = validator.visibleValidator(source, dest);
            CommitFailedException e = EditorDiff.process(nextValidator, (tp = validator.getTreeProvider()).asNodeState(source), tp.asNodeState(dest));
            if (e != null) {
                throw e;
            }
            return true;
        }

        private void checkPermissions(@NotNull Tree tree, long permissions) throws CommitFailedException {
            MoveAwarePermissionValidator.this.checkIsGranted(MoveAwarePermissionValidator.this.getPermissionProvider().isGranted(tree, null, permissions));
        }
    }
}

