/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.support;

import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

public class BatchResourceRemover {
    private final int max;
    private int count;

    public BatchResourceRemover() {
        this(50);
    }

    public BatchResourceRemover(int batchSize) {
        this.max = batchSize;
    }

    public void delete(Resource rsrc) throws PersistenceException {
        ResourceResolver resolver = rsrc.getResourceResolver();
        for (Resource child : rsrc.getChildren()) {
            this.delete(child);
        }
        resolver.delete(rsrc);
        ++this.count;
        if (this.count >= this.max) {
            resolver.commit();
            this.count = 0;
        }
    }
}

