/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cta.impl;

import java.lang.instrument.ClassFileTransformer;
import java.util.ArrayList;
import java.util.List;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.sling.cta.impl.AgentInfoMBean;

public class AgentInfo
implements AgentInfoMBean {
    static final ObjectName NAME;
    private final long connectTimeoutMillis;
    private final long readTimeoutMillis;
    private List<String> transformers = new ArrayList<String>();
    private List<String> transformedClasses = new ArrayList<String>();

    public AgentInfo(long connectTimeoutMillis, long readTimeoutMillis) {
        this.connectTimeoutMillis = connectTimeoutMillis;
        this.readTimeoutMillis = readTimeoutMillis;
    }

    @Override
    public long getConnectTimeoutMillis() {
        return this.connectTimeoutMillis;
    }

    @Override
    public long getReadTimeoutMillis() {
        return this.readTimeoutMillis;
    }

    @Override
    public String[] getTransformers() {
        return this.transformers.toArray(new String[0]);
    }

    @Override
    public String[] getTransformedClasses() {
        return this.transformedClasses.toArray(new String[0]);
    }

    public void registerTransformedClass(String transformedClassName) {
        this.transformedClasses.add(transformedClassName);
    }

    public void registerTransformer(Class<? extends ClassFileTransformer> transformerClass) {
        this.transformers.add(transformerClass.getName());
    }

    static {
        try {
            NAME = new ObjectName(AgentInfo.class.getPackage().getName().replace(".impl", "") + ":type=Agent");
        }
        catch (MalformedObjectNameException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

