// Licensed to the Apache Software Foundation (ASF) under one or more
// contributor license agreements.  See the NOTICE file distributed with
// this work for additional information regarding copyright ownership.
// The ASF licenses this file to You under the Apache License, Version 2.0
// (the "License"); you may not use this file except in compliance with
// the License.  You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.6
// 	protoc        v5.29.3
// source: apache/rocketmq/v2/service.proto

package v2

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Topics are destination of messages to publish to or subscribe from. Similar
// to domain names, they will be addressable after resolution through the
// provided access point.
//
// Access points are usually the addresses of name servers, which fulfill
// service discovery, load-balancing and other auxiliary services. Name servers
// receive periodic heartbeats from affiliate brokers and erase those which
// failed to maintain alive status.
//
// Name servers answer queries of QueryRouteRequest, responding clients with
// addressable message-queues, which they may directly publish messages to or
// subscribe messages from.
//
// QueryRouteRequest shall include source endpoints, aka, configured
// access-point, which annotates tenant-id, instance-id or other
// vendor-specific settings. Purpose-built name servers may respond customized
// results based on these particular requirements.
type QueryRouteRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Topic         *Resource              `protobuf:"bytes,1,opt,name=topic,proto3" json:"topic,omitempty"`
	Endpoints     *Endpoints             `protobuf:"bytes,2,opt,name=endpoints,proto3" json:"endpoints,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *QueryRouteRequest) Reset() {
	*x = QueryRouteRequest{}
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *QueryRouteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryRouteRequest) ProtoMessage() {}

func (x *QueryRouteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryRouteRequest.ProtoReflect.Descriptor instead.
func (*QueryRouteRequest) Descriptor() ([]byte, []int) {
	return file_apache_rocketmq_v2_service_proto_rawDescGZIP(), []int{0}
}

func (x *QueryRouteRequest) GetTopic() *Resource {
	if x != nil {
		return x.Topic
	}
	return nil
}

func (x *QueryRouteRequest) GetEndpoints() *Endpoints {
	if x != nil {
		return x.Endpoints
	}
	return nil
}

type QueryRouteResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Status        *Status                `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
	MessageQueues []*MessageQueue        `protobuf:"bytes,2,rep,name=message_queues,json=messageQueues,proto3" json:"message_queues,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *QueryRouteResponse) Reset() {
	*x = QueryRouteResponse{}
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *QueryRouteResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryRouteResponse) ProtoMessage() {}

func (x *QueryRouteResponse) ProtoReflect() protoreflect.Message {
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryRouteResponse.ProtoReflect.Descriptor instead.
func (*QueryRouteResponse) Descriptor() ([]byte, []int) {
	return file_apache_rocketmq_v2_service_proto_rawDescGZIP(), []int{1}
}

func (x *QueryRouteResponse) GetStatus() *Status {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *QueryRouteResponse) GetMessageQueues() []*MessageQueue {
	if x != nil {
		return x.MessageQueues
	}
	return nil
}

type SendMessageRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Messages      []*Message             `protobuf:"bytes,1,rep,name=messages,proto3" json:"messages,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SendMessageRequest) Reset() {
	*x = SendMessageRequest{}
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SendMessageRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SendMessageRequest) ProtoMessage() {}

func (x *SendMessageRequest) ProtoReflect() protoreflect.Message {
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SendMessageRequest.ProtoReflect.Descriptor instead.
func (*SendMessageRequest) Descriptor() ([]byte, []int) {
	return file_apache_rocketmq_v2_service_proto_rawDescGZIP(), []int{2}
}

func (x *SendMessageRequest) GetMessages() []*Message {
	if x != nil {
		return x.Messages
	}
	return nil
}

type SendResultEntry struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Status        *Status                `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
	MessageId     string                 `protobuf:"bytes,2,opt,name=message_id,json=messageId,proto3" json:"message_id,omitempty"`
	TransactionId string                 `protobuf:"bytes,3,opt,name=transaction_id,json=transactionId,proto3" json:"transaction_id,omitempty"`
	Offset        int64                  `protobuf:"varint,4,opt,name=offset,proto3" json:"offset,omitempty"`
	// Unique handle to identify message to recall, support delay message for now.
	RecallHandle  string `protobuf:"bytes,5,opt,name=recall_handle,json=recallHandle,proto3" json:"recall_handle,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SendResultEntry) Reset() {
	*x = SendResultEntry{}
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SendResultEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SendResultEntry) ProtoMessage() {}

func (x *SendResultEntry) ProtoReflect() protoreflect.Message {
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SendResultEntry.ProtoReflect.Descriptor instead.
func (*SendResultEntry) Descriptor() ([]byte, []int) {
	return file_apache_rocketmq_v2_service_proto_rawDescGZIP(), []int{3}
}

func (x *SendResultEntry) GetStatus() *Status {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *SendResultEntry) GetMessageId() string {
	if x != nil {
		return x.MessageId
	}
	return ""
}

func (x *SendResultEntry) GetTransactionId() string {
	if x != nil {
		return x.TransactionId
	}
	return ""
}

func (x *SendResultEntry) GetOffset() int64 {
	if x != nil {
		return x.Offset
	}
	return 0
}

func (x *SendResultEntry) GetRecallHandle() string {
	if x != nil {
		return x.RecallHandle
	}
	return ""
}

type SendMessageResponse struct {
	state  protoimpl.MessageState `protogen:"open.v1"`
	Status *Status                `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
	// Some implementation may have partial failure issues. Client SDK developers are expected to inspect
	// each entry for best certainty.
	Entries       []*SendResultEntry `protobuf:"bytes,2,rep,name=entries,proto3" json:"entries,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SendMessageResponse) Reset() {
	*x = SendMessageResponse{}
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SendMessageResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SendMessageResponse) ProtoMessage() {}

func (x *SendMessageResponse) ProtoReflect() protoreflect.Message {
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SendMessageResponse.ProtoReflect.Descriptor instead.
func (*SendMessageResponse) Descriptor() ([]byte, []int) {
	return file_apache_rocketmq_v2_service_proto_rawDescGZIP(), []int{4}
}

func (x *SendMessageResponse) GetStatus() *Status {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *SendMessageResponse) GetEntries() []*SendResultEntry {
	if x != nil {
		return x.Entries
	}
	return nil
}

type QueryAssignmentRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Topic         *Resource              `protobuf:"bytes,1,opt,name=topic,proto3" json:"topic,omitempty"`
	Group         *Resource              `protobuf:"bytes,2,opt,name=group,proto3" json:"group,omitempty"`
	Endpoints     *Endpoints             `protobuf:"bytes,3,opt,name=endpoints,proto3" json:"endpoints,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *QueryAssignmentRequest) Reset() {
	*x = QueryAssignmentRequest{}
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *QueryAssignmentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryAssignmentRequest) ProtoMessage() {}

func (x *QueryAssignmentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryAssignmentRequest.ProtoReflect.Descriptor instead.
func (*QueryAssignmentRequest) Descriptor() ([]byte, []int) {
	return file_apache_rocketmq_v2_service_proto_rawDescGZIP(), []int{5}
}

func (x *QueryAssignmentRequest) GetTopic() *Resource {
	if x != nil {
		return x.Topic
	}
	return nil
}

func (x *QueryAssignmentRequest) GetGroup() *Resource {
	if x != nil {
		return x.Group
	}
	return nil
}

func (x *QueryAssignmentRequest) GetEndpoints() *Endpoints {
	if x != nil {
		return x.Endpoints
	}
	return nil
}

type QueryAssignmentResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Status        *Status                `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
	Assignments   []*Assignment          `protobuf:"bytes,2,rep,name=assignments,proto3" json:"assignments,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *QueryAssignmentResponse) Reset() {
	*x = QueryAssignmentResponse{}
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *QueryAssignmentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryAssignmentResponse) ProtoMessage() {}

func (x *QueryAssignmentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryAssignmentResponse.ProtoReflect.Descriptor instead.
func (*QueryAssignmentResponse) Descriptor() ([]byte, []int) {
	return file_apache_rocketmq_v2_service_proto_rawDescGZIP(), []int{6}
}

func (x *QueryAssignmentResponse) GetStatus() *Status {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *QueryAssignmentResponse) GetAssignments() []*Assignment {
	if x != nil {
		return x.Assignments
	}
	return nil
}

type ReceiveMessageRequest struct {
	state            protoimpl.MessageState `protogen:"open.v1"`
	Group            *Resource              `protobuf:"bytes,1,opt,name=group,proto3" json:"group,omitempty"`
	MessageQueue     *MessageQueue          `protobuf:"bytes,2,opt,name=message_queue,json=messageQueue,proto3" json:"message_queue,omitempty"`
	FilterExpression *FilterExpression      `protobuf:"bytes,3,opt,name=filter_expression,json=filterExpression,proto3" json:"filter_expression,omitempty"`
	BatchSize        int32                  `protobuf:"varint,4,opt,name=batch_size,json=batchSize,proto3" json:"batch_size,omitempty"`
	// Required if client type is simple consumer.
	InvisibleDuration *durationpb.Duration `protobuf:"bytes,5,opt,name=invisible_duration,json=invisibleDuration,proto3,oneof" json:"invisible_duration,omitempty"`
	// For message auto renew and clean
	AutoRenew          bool                 `protobuf:"varint,6,opt,name=auto_renew,json=autoRenew,proto3" json:"auto_renew,omitempty"`
	LongPollingTimeout *durationpb.Duration `protobuf:"bytes,7,opt,name=long_polling_timeout,json=longPollingTimeout,proto3,oneof" json:"long_polling_timeout,omitempty"`
	AttemptId          *string              `protobuf:"bytes,8,opt,name=attempt_id,json=attemptId,proto3,oneof" json:"attempt_id,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *ReceiveMessageRequest) Reset() {
	*x = ReceiveMessageRequest{}
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReceiveMessageRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReceiveMessageRequest) ProtoMessage() {}

func (x *ReceiveMessageRequest) ProtoReflect() protoreflect.Message {
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReceiveMessageRequest.ProtoReflect.Descriptor instead.
func (*ReceiveMessageRequest) Descriptor() ([]byte, []int) {
	return file_apache_rocketmq_v2_service_proto_rawDescGZIP(), []int{7}
}

func (x *ReceiveMessageRequest) GetGroup() *Resource {
	if x != nil {
		return x.Group
	}
	return nil
}

func (x *ReceiveMessageRequest) GetMessageQueue() *MessageQueue {
	if x != nil {
		return x.MessageQueue
	}
	return nil
}

func (x *ReceiveMessageRequest) GetFilterExpression() *FilterExpression {
	if x != nil {
		return x.FilterExpression
	}
	return nil
}

func (x *ReceiveMessageRequest) GetBatchSize() int32 {
	if x != nil {
		return x.BatchSize
	}
	return 0
}

func (x *ReceiveMessageRequest) GetInvisibleDuration() *durationpb.Duration {
	if x != nil {
		return x.InvisibleDuration
	}
	return nil
}

func (x *ReceiveMessageRequest) GetAutoRenew() bool {
	if x != nil {
		return x.AutoRenew
	}
	return false
}

func (x *ReceiveMessageRequest) GetLongPollingTimeout() *durationpb.Duration {
	if x != nil {
		return x.LongPollingTimeout
	}
	return nil
}

func (x *ReceiveMessageRequest) GetAttemptId() string {
	if x != nil && x.AttemptId != nil {
		return *x.AttemptId
	}
	return ""
}

type ReceiveMessageResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to Content:
	//
	//	*ReceiveMessageResponse_Status
	//	*ReceiveMessageResponse_Message
	//	*ReceiveMessageResponse_DeliveryTimestamp
	Content       isReceiveMessageResponse_Content `protobuf_oneof:"content"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ReceiveMessageResponse) Reset() {
	*x = ReceiveMessageResponse{}
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReceiveMessageResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReceiveMessageResponse) ProtoMessage() {}

func (x *ReceiveMessageResponse) ProtoReflect() protoreflect.Message {
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReceiveMessageResponse.ProtoReflect.Descriptor instead.
func (*ReceiveMessageResponse) Descriptor() ([]byte, []int) {
	return file_apache_rocketmq_v2_service_proto_rawDescGZIP(), []int{8}
}

func (x *ReceiveMessageResponse) GetContent() isReceiveMessageResponse_Content {
	if x != nil {
		return x.Content
	}
	return nil
}

func (x *ReceiveMessageResponse) GetStatus() *Status {
	if x != nil {
		if x, ok := x.Content.(*ReceiveMessageResponse_Status); ok {
			return x.Status
		}
	}
	return nil
}

func (x *ReceiveMessageResponse) GetMessage() *Message {
	if x != nil {
		if x, ok := x.Content.(*ReceiveMessageResponse_Message); ok {
			return x.Message
		}
	}
	return nil
}

func (x *ReceiveMessageResponse) GetDeliveryTimestamp() *timestamppb.Timestamp {
	if x != nil {
		if x, ok := x.Content.(*ReceiveMessageResponse_DeliveryTimestamp); ok {
			return x.DeliveryTimestamp
		}
	}
	return nil
}

type isReceiveMessageResponse_Content interface {
	isReceiveMessageResponse_Content()
}

type ReceiveMessageResponse_Status struct {
	Status *Status `protobuf:"bytes,1,opt,name=status,proto3,oneof"`
}

type ReceiveMessageResponse_Message struct {
	Message *Message `protobuf:"bytes,2,opt,name=message,proto3,oneof"`
}

type ReceiveMessageResponse_DeliveryTimestamp struct {
	// The timestamp that brokers start to deliver status line or message.
	DeliveryTimestamp *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=delivery_timestamp,json=deliveryTimestamp,proto3,oneof"`
}

func (*ReceiveMessageResponse_Status) isReceiveMessageResponse_Content() {}

func (*ReceiveMessageResponse_Message) isReceiveMessageResponse_Content() {}

func (*ReceiveMessageResponse_DeliveryTimestamp) isReceiveMessageResponse_Content() {}

type AckMessageEntry struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	MessageId     string                 `protobuf:"bytes,1,opt,name=message_id,json=messageId,proto3" json:"message_id,omitempty"`
	ReceiptHandle string                 `protobuf:"bytes,2,opt,name=receipt_handle,json=receiptHandle,proto3" json:"receipt_handle,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AckMessageEntry) Reset() {
	*x = AckMessageEntry{}
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AckMessageEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AckMessageEntry) ProtoMessage() {}

func (x *AckMessageEntry) ProtoReflect() protoreflect.Message {
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AckMessageEntry.ProtoReflect.Descriptor instead.
func (*AckMessageEntry) Descriptor() ([]byte, []int) {
	return file_apache_rocketmq_v2_service_proto_rawDescGZIP(), []int{9}
}

func (x *AckMessageEntry) GetMessageId() string {
	if x != nil {
		return x.MessageId
	}
	return ""
}

func (x *AckMessageEntry) GetReceiptHandle() string {
	if x != nil {
		return x.ReceiptHandle
	}
	return ""
}

type AckMessageRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Group         *Resource              `protobuf:"bytes,1,opt,name=group,proto3" json:"group,omitempty"`
	Topic         *Resource              `protobuf:"bytes,2,opt,name=topic,proto3" json:"topic,omitempty"`
	Entries       []*AckMessageEntry     `protobuf:"bytes,3,rep,name=entries,proto3" json:"entries,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AckMessageRequest) Reset() {
	*x = AckMessageRequest{}
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AckMessageRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AckMessageRequest) ProtoMessage() {}

func (x *AckMessageRequest) ProtoReflect() protoreflect.Message {
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AckMessageRequest.ProtoReflect.Descriptor instead.
func (*AckMessageRequest) Descriptor() ([]byte, []int) {
	return file_apache_rocketmq_v2_service_proto_rawDescGZIP(), []int{10}
}

func (x *AckMessageRequest) GetGroup() *Resource {
	if x != nil {
		return x.Group
	}
	return nil
}

func (x *AckMessageRequest) GetTopic() *Resource {
	if x != nil {
		return x.Topic
	}
	return nil
}

func (x *AckMessageRequest) GetEntries() []*AckMessageEntry {
	if x != nil {
		return x.Entries
	}
	return nil
}

type AckMessageResultEntry struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	MessageId     string                 `protobuf:"bytes,1,opt,name=message_id,json=messageId,proto3" json:"message_id,omitempty"`
	ReceiptHandle string                 `protobuf:"bytes,2,opt,name=receipt_handle,json=receiptHandle,proto3" json:"receipt_handle,omitempty"`
	// Acknowledge result may be acquired through inspecting
	// `status.code`; In case acknowledgement failed, `status.message`
	// is the explanation of the failure.
	Status        *Status `protobuf:"bytes,3,opt,name=status,proto3" json:"status,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AckMessageResultEntry) Reset() {
	*x = AckMessageResultEntry{}
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AckMessageResultEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AckMessageResultEntry) ProtoMessage() {}

func (x *AckMessageResultEntry) ProtoReflect() protoreflect.Message {
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AckMessageResultEntry.ProtoReflect.Descriptor instead.
func (*AckMessageResultEntry) Descriptor() ([]byte, []int) {
	return file_apache_rocketmq_v2_service_proto_rawDescGZIP(), []int{11}
}

func (x *AckMessageResultEntry) GetMessageId() string {
	if x != nil {
		return x.MessageId
	}
	return ""
}

func (x *AckMessageResultEntry) GetReceiptHandle() string {
	if x != nil {
		return x.ReceiptHandle
	}
	return ""
}

func (x *AckMessageResultEntry) GetStatus() *Status {
	if x != nil {
		return x.Status
	}
	return nil
}

type AckMessageResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// RPC tier status, which is used to represent RPC-level errors including
	// authentication, authorization, throttling and other general failures.
	Status        *Status                  `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
	Entries       []*AckMessageResultEntry `protobuf:"bytes,2,rep,name=entries,proto3" json:"entries,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AckMessageResponse) Reset() {
	*x = AckMessageResponse{}
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AckMessageResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AckMessageResponse) ProtoMessage() {}

func (x *AckMessageResponse) ProtoReflect() protoreflect.Message {
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AckMessageResponse.ProtoReflect.Descriptor instead.
func (*AckMessageResponse) Descriptor() ([]byte, []int) {
	return file_apache_rocketmq_v2_service_proto_rawDescGZIP(), []int{12}
}

func (x *AckMessageResponse) GetStatus() *Status {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *AckMessageResponse) GetEntries() []*AckMessageResultEntry {
	if x != nil {
		return x.Entries
	}
	return nil
}

type ForwardMessageToDeadLetterQueueRequest struct {
	state               protoimpl.MessageState `protogen:"open.v1"`
	Group               *Resource              `protobuf:"bytes,1,opt,name=group,proto3" json:"group,omitempty"`
	Topic               *Resource              `protobuf:"bytes,2,opt,name=topic,proto3" json:"topic,omitempty"`
	ReceiptHandle       string                 `protobuf:"bytes,3,opt,name=receipt_handle,json=receiptHandle,proto3" json:"receipt_handle,omitempty"`
	MessageId           string                 `protobuf:"bytes,4,opt,name=message_id,json=messageId,proto3" json:"message_id,omitempty"`
	DeliveryAttempt     int32                  `protobuf:"varint,5,opt,name=delivery_attempt,json=deliveryAttempt,proto3" json:"delivery_attempt,omitempty"`
	MaxDeliveryAttempts int32                  `protobuf:"varint,6,opt,name=max_delivery_attempts,json=maxDeliveryAttempts,proto3" json:"max_delivery_attempts,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *ForwardMessageToDeadLetterQueueRequest) Reset() {
	*x = ForwardMessageToDeadLetterQueueRequest{}
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ForwardMessageToDeadLetterQueueRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ForwardMessageToDeadLetterQueueRequest) ProtoMessage() {}

func (x *ForwardMessageToDeadLetterQueueRequest) ProtoReflect() protoreflect.Message {
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ForwardMessageToDeadLetterQueueRequest.ProtoReflect.Descriptor instead.
func (*ForwardMessageToDeadLetterQueueRequest) Descriptor() ([]byte, []int) {
	return file_apache_rocketmq_v2_service_proto_rawDescGZIP(), []int{13}
}

func (x *ForwardMessageToDeadLetterQueueRequest) GetGroup() *Resource {
	if x != nil {
		return x.Group
	}
	return nil
}

func (x *ForwardMessageToDeadLetterQueueRequest) GetTopic() *Resource {
	if x != nil {
		return x.Topic
	}
	return nil
}

func (x *ForwardMessageToDeadLetterQueueRequest) GetReceiptHandle() string {
	if x != nil {
		return x.ReceiptHandle
	}
	return ""
}

func (x *ForwardMessageToDeadLetterQueueRequest) GetMessageId() string {
	if x != nil {
		return x.MessageId
	}
	return ""
}

func (x *ForwardMessageToDeadLetterQueueRequest) GetDeliveryAttempt() int32 {
	if x != nil {
		return x.DeliveryAttempt
	}
	return 0
}

func (x *ForwardMessageToDeadLetterQueueRequest) GetMaxDeliveryAttempts() int32 {
	if x != nil {
		return x.MaxDeliveryAttempts
	}
	return 0
}

type ForwardMessageToDeadLetterQueueResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Status        *Status                `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ForwardMessageToDeadLetterQueueResponse) Reset() {
	*x = ForwardMessageToDeadLetterQueueResponse{}
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ForwardMessageToDeadLetterQueueResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ForwardMessageToDeadLetterQueueResponse) ProtoMessage() {}

func (x *ForwardMessageToDeadLetterQueueResponse) ProtoReflect() protoreflect.Message {
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ForwardMessageToDeadLetterQueueResponse.ProtoReflect.Descriptor instead.
func (*ForwardMessageToDeadLetterQueueResponse) Descriptor() ([]byte, []int) {
	return file_apache_rocketmq_v2_service_proto_rawDescGZIP(), []int{14}
}

func (x *ForwardMessageToDeadLetterQueueResponse) GetStatus() *Status {
	if x != nil {
		return x.Status
	}
	return nil
}

type HeartbeatRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Group         *Resource              `protobuf:"bytes,1,opt,name=group,proto3,oneof" json:"group,omitempty"`
	ClientType    ClientType             `protobuf:"varint,2,opt,name=client_type,json=clientType,proto3,enum=apache.rocketmq.v2.ClientType" json:"client_type,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *HeartbeatRequest) Reset() {
	*x = HeartbeatRequest{}
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HeartbeatRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HeartbeatRequest) ProtoMessage() {}

func (x *HeartbeatRequest) ProtoReflect() protoreflect.Message {
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HeartbeatRequest.ProtoReflect.Descriptor instead.
func (*HeartbeatRequest) Descriptor() ([]byte, []int) {
	return file_apache_rocketmq_v2_service_proto_rawDescGZIP(), []int{15}
}

func (x *HeartbeatRequest) GetGroup() *Resource {
	if x != nil {
		return x.Group
	}
	return nil
}

func (x *HeartbeatRequest) GetClientType() ClientType {
	if x != nil {
		return x.ClientType
	}
	return ClientType_CLIENT_TYPE_UNSPECIFIED
}

type HeartbeatResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Status        *Status                `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *HeartbeatResponse) Reset() {
	*x = HeartbeatResponse{}
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HeartbeatResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HeartbeatResponse) ProtoMessage() {}

func (x *HeartbeatResponse) ProtoReflect() protoreflect.Message {
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HeartbeatResponse.ProtoReflect.Descriptor instead.
func (*HeartbeatResponse) Descriptor() ([]byte, []int) {
	return file_apache_rocketmq_v2_service_proto_rawDescGZIP(), []int{16}
}

func (x *HeartbeatResponse) GetStatus() *Status {
	if x != nil {
		return x.Status
	}
	return nil
}

type EndTransactionRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Topic         *Resource              `protobuf:"bytes,1,opt,name=topic,proto3" json:"topic,omitempty"`
	MessageId     string                 `protobuf:"bytes,2,opt,name=message_id,json=messageId,proto3" json:"message_id,omitempty"`
	TransactionId string                 `protobuf:"bytes,3,opt,name=transaction_id,json=transactionId,proto3" json:"transaction_id,omitempty"`
	Resolution    TransactionResolution  `protobuf:"varint,4,opt,name=resolution,proto3,enum=apache.rocketmq.v2.TransactionResolution" json:"resolution,omitempty"`
	Source        TransactionSource      `protobuf:"varint,5,opt,name=source,proto3,enum=apache.rocketmq.v2.TransactionSource" json:"source,omitempty"`
	TraceContext  string                 `protobuf:"bytes,6,opt,name=trace_context,json=traceContext,proto3" json:"trace_context,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *EndTransactionRequest) Reset() {
	*x = EndTransactionRequest{}
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EndTransactionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EndTransactionRequest) ProtoMessage() {}

func (x *EndTransactionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EndTransactionRequest.ProtoReflect.Descriptor instead.
func (*EndTransactionRequest) Descriptor() ([]byte, []int) {
	return file_apache_rocketmq_v2_service_proto_rawDescGZIP(), []int{17}
}

func (x *EndTransactionRequest) GetTopic() *Resource {
	if x != nil {
		return x.Topic
	}
	return nil
}

func (x *EndTransactionRequest) GetMessageId() string {
	if x != nil {
		return x.MessageId
	}
	return ""
}

func (x *EndTransactionRequest) GetTransactionId() string {
	if x != nil {
		return x.TransactionId
	}
	return ""
}

func (x *EndTransactionRequest) GetResolution() TransactionResolution {
	if x != nil {
		return x.Resolution
	}
	return TransactionResolution_TRANSACTION_RESOLUTION_UNSPECIFIED
}

func (x *EndTransactionRequest) GetSource() TransactionSource {
	if x != nil {
		return x.Source
	}
	return TransactionSource_SOURCE_UNSPECIFIED
}

func (x *EndTransactionRequest) GetTraceContext() string {
	if x != nil {
		return x.TraceContext
	}
	return ""
}

type EndTransactionResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Status        *Status                `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *EndTransactionResponse) Reset() {
	*x = EndTransactionResponse{}
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EndTransactionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EndTransactionResponse) ProtoMessage() {}

func (x *EndTransactionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EndTransactionResponse.ProtoReflect.Descriptor instead.
func (*EndTransactionResponse) Descriptor() ([]byte, []int) {
	return file_apache_rocketmq_v2_service_proto_rawDescGZIP(), []int{18}
}

func (x *EndTransactionResponse) GetStatus() *Status {
	if x != nil {
		return x.Status
	}
	return nil
}

type PrintThreadStackTraceCommand struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Nonce         string                 `protobuf:"bytes,1,opt,name=nonce,proto3" json:"nonce,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PrintThreadStackTraceCommand) Reset() {
	*x = PrintThreadStackTraceCommand{}
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PrintThreadStackTraceCommand) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrintThreadStackTraceCommand) ProtoMessage() {}

func (x *PrintThreadStackTraceCommand) ProtoReflect() protoreflect.Message {
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrintThreadStackTraceCommand.ProtoReflect.Descriptor instead.
func (*PrintThreadStackTraceCommand) Descriptor() ([]byte, []int) {
	return file_apache_rocketmq_v2_service_proto_rawDescGZIP(), []int{19}
}

func (x *PrintThreadStackTraceCommand) GetNonce() string {
	if x != nil {
		return x.Nonce
	}
	return ""
}

type ReconnectEndpointsCommand struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Nonce         string                 `protobuf:"bytes,1,opt,name=nonce,proto3" json:"nonce,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ReconnectEndpointsCommand) Reset() {
	*x = ReconnectEndpointsCommand{}
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReconnectEndpointsCommand) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReconnectEndpointsCommand) ProtoMessage() {}

func (x *ReconnectEndpointsCommand) ProtoReflect() protoreflect.Message {
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReconnectEndpointsCommand.ProtoReflect.Descriptor instead.
func (*ReconnectEndpointsCommand) Descriptor() ([]byte, []int) {
	return file_apache_rocketmq_v2_service_proto_rawDescGZIP(), []int{20}
}

func (x *ReconnectEndpointsCommand) GetNonce() string {
	if x != nil {
		return x.Nonce
	}
	return ""
}

type ThreadStackTrace struct {
	state            protoimpl.MessageState `protogen:"open.v1"`
	Nonce            string                 `protobuf:"bytes,1,opt,name=nonce,proto3" json:"nonce,omitempty"`
	ThreadStackTrace *string                `protobuf:"bytes,2,opt,name=thread_stack_trace,json=threadStackTrace,proto3,oneof" json:"thread_stack_trace,omitempty"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *ThreadStackTrace) Reset() {
	*x = ThreadStackTrace{}
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ThreadStackTrace) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ThreadStackTrace) ProtoMessage() {}

func (x *ThreadStackTrace) ProtoReflect() protoreflect.Message {
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ThreadStackTrace.ProtoReflect.Descriptor instead.
func (*ThreadStackTrace) Descriptor() ([]byte, []int) {
	return file_apache_rocketmq_v2_service_proto_rawDescGZIP(), []int{21}
}

func (x *ThreadStackTrace) GetNonce() string {
	if x != nil {
		return x.Nonce
	}
	return ""
}

func (x *ThreadStackTrace) GetThreadStackTrace() string {
	if x != nil && x.ThreadStackTrace != nil {
		return *x.ThreadStackTrace
	}
	return ""
}

type VerifyMessageCommand struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Nonce         string                 `protobuf:"bytes,1,opt,name=nonce,proto3" json:"nonce,omitempty"`
	Message       *Message               `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *VerifyMessageCommand) Reset() {
	*x = VerifyMessageCommand{}
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VerifyMessageCommand) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VerifyMessageCommand) ProtoMessage() {}

func (x *VerifyMessageCommand) ProtoReflect() protoreflect.Message {
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VerifyMessageCommand.ProtoReflect.Descriptor instead.
func (*VerifyMessageCommand) Descriptor() ([]byte, []int) {
	return file_apache_rocketmq_v2_service_proto_rawDescGZIP(), []int{22}
}

func (x *VerifyMessageCommand) GetNonce() string {
	if x != nil {
		return x.Nonce
	}
	return ""
}

func (x *VerifyMessageCommand) GetMessage() *Message {
	if x != nil {
		return x.Message
	}
	return nil
}

type VerifyMessageResult struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Nonce         string                 `protobuf:"bytes,1,opt,name=nonce,proto3" json:"nonce,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *VerifyMessageResult) Reset() {
	*x = VerifyMessageResult{}
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VerifyMessageResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VerifyMessageResult) ProtoMessage() {}

func (x *VerifyMessageResult) ProtoReflect() protoreflect.Message {
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VerifyMessageResult.ProtoReflect.Descriptor instead.
func (*VerifyMessageResult) Descriptor() ([]byte, []int) {
	return file_apache_rocketmq_v2_service_proto_rawDescGZIP(), []int{23}
}

func (x *VerifyMessageResult) GetNonce() string {
	if x != nil {
		return x.Nonce
	}
	return ""
}

type RecoverOrphanedTransactionCommand struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Message       *Message               `protobuf:"bytes,1,opt,name=message,proto3" json:"message,omitempty"`
	TransactionId string                 `protobuf:"bytes,2,opt,name=transaction_id,json=transactionId,proto3" json:"transaction_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RecoverOrphanedTransactionCommand) Reset() {
	*x = RecoverOrphanedTransactionCommand{}
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RecoverOrphanedTransactionCommand) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RecoverOrphanedTransactionCommand) ProtoMessage() {}

func (x *RecoverOrphanedTransactionCommand) ProtoReflect() protoreflect.Message {
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RecoverOrphanedTransactionCommand.ProtoReflect.Descriptor instead.
func (*RecoverOrphanedTransactionCommand) Descriptor() ([]byte, []int) {
	return file_apache_rocketmq_v2_service_proto_rawDescGZIP(), []int{24}
}

func (x *RecoverOrphanedTransactionCommand) GetMessage() *Message {
	if x != nil {
		return x.Message
	}
	return nil
}

func (x *RecoverOrphanedTransactionCommand) GetTransactionId() string {
	if x != nil {
		return x.TransactionId
	}
	return ""
}

type TelemetryCommand struct {
	state  protoimpl.MessageState `protogen:"open.v1"`
	Status *Status                `protobuf:"bytes,1,opt,name=status,proto3,oneof" json:"status,omitempty"`
	// Types that are valid to be assigned to Command:
	//
	//	*TelemetryCommand_Settings
	//	*TelemetryCommand_ThreadStackTrace
	//	*TelemetryCommand_VerifyMessageResult
	//	*TelemetryCommand_RecoverOrphanedTransactionCommand
	//	*TelemetryCommand_PrintThreadStackTraceCommand
	//	*TelemetryCommand_VerifyMessageCommand
	//	*TelemetryCommand_ReconnectEndpointsCommand
	Command       isTelemetryCommand_Command `protobuf_oneof:"command"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TelemetryCommand) Reset() {
	*x = TelemetryCommand{}
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TelemetryCommand) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TelemetryCommand) ProtoMessage() {}

func (x *TelemetryCommand) ProtoReflect() protoreflect.Message {
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TelemetryCommand.ProtoReflect.Descriptor instead.
func (*TelemetryCommand) Descriptor() ([]byte, []int) {
	return file_apache_rocketmq_v2_service_proto_rawDescGZIP(), []int{25}
}

func (x *TelemetryCommand) GetStatus() *Status {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *TelemetryCommand) GetCommand() isTelemetryCommand_Command {
	if x != nil {
		return x.Command
	}
	return nil
}

func (x *TelemetryCommand) GetSettings() *Settings {
	if x != nil {
		if x, ok := x.Command.(*TelemetryCommand_Settings); ok {
			return x.Settings
		}
	}
	return nil
}

func (x *TelemetryCommand) GetThreadStackTrace() *ThreadStackTrace {
	if x != nil {
		if x, ok := x.Command.(*TelemetryCommand_ThreadStackTrace); ok {
			return x.ThreadStackTrace
		}
	}
	return nil
}

func (x *TelemetryCommand) GetVerifyMessageResult() *VerifyMessageResult {
	if x != nil {
		if x, ok := x.Command.(*TelemetryCommand_VerifyMessageResult); ok {
			return x.VerifyMessageResult
		}
	}
	return nil
}

func (x *TelemetryCommand) GetRecoverOrphanedTransactionCommand() *RecoverOrphanedTransactionCommand {
	if x != nil {
		if x, ok := x.Command.(*TelemetryCommand_RecoverOrphanedTransactionCommand); ok {
			return x.RecoverOrphanedTransactionCommand
		}
	}
	return nil
}

func (x *TelemetryCommand) GetPrintThreadStackTraceCommand() *PrintThreadStackTraceCommand {
	if x != nil {
		if x, ok := x.Command.(*TelemetryCommand_PrintThreadStackTraceCommand); ok {
			return x.PrintThreadStackTraceCommand
		}
	}
	return nil
}

func (x *TelemetryCommand) GetVerifyMessageCommand() *VerifyMessageCommand {
	if x != nil {
		if x, ok := x.Command.(*TelemetryCommand_VerifyMessageCommand); ok {
			return x.VerifyMessageCommand
		}
	}
	return nil
}

func (x *TelemetryCommand) GetReconnectEndpointsCommand() *ReconnectEndpointsCommand {
	if x != nil {
		if x, ok := x.Command.(*TelemetryCommand_ReconnectEndpointsCommand); ok {
			return x.ReconnectEndpointsCommand
		}
	}
	return nil
}

type isTelemetryCommand_Command interface {
	isTelemetryCommand_Command()
}

type TelemetryCommand_Settings struct {
	// Client settings
	Settings *Settings `protobuf:"bytes,2,opt,name=settings,proto3,oneof"`
}

type TelemetryCommand_ThreadStackTrace struct {
	// These messages are from client.
	//
	// Report thread stack trace to server.
	ThreadStackTrace *ThreadStackTrace `protobuf:"bytes,3,opt,name=thread_stack_trace,json=threadStackTrace,proto3,oneof"`
}

type TelemetryCommand_VerifyMessageResult struct {
	// Report message verify result to server.
	VerifyMessageResult *VerifyMessageResult `protobuf:"bytes,4,opt,name=verify_message_result,json=verifyMessageResult,proto3,oneof"`
}

type TelemetryCommand_RecoverOrphanedTransactionCommand struct {
	// There messages are from server.
	//
	// Request client to recover the orphaned transaction message.
	RecoverOrphanedTransactionCommand *RecoverOrphanedTransactionCommand `protobuf:"bytes,5,opt,name=recover_orphaned_transaction_command,json=recoverOrphanedTransactionCommand,proto3,oneof"`
}

type TelemetryCommand_PrintThreadStackTraceCommand struct {
	// Request client to print thread stack trace.
	PrintThreadStackTraceCommand *PrintThreadStackTraceCommand `protobuf:"bytes,6,opt,name=print_thread_stack_trace_command,json=printThreadStackTraceCommand,proto3,oneof"`
}

type TelemetryCommand_VerifyMessageCommand struct {
	// Request client to verify the consumption of the appointed message.
	VerifyMessageCommand *VerifyMessageCommand `protobuf:"bytes,7,opt,name=verify_message_command,json=verifyMessageCommand,proto3,oneof"`
}

type TelemetryCommand_ReconnectEndpointsCommand struct {
	// Request client to reconnect server use the latest endpoints.
	ReconnectEndpointsCommand *ReconnectEndpointsCommand `protobuf:"bytes,8,opt,name=reconnect_endpoints_command,json=reconnectEndpointsCommand,proto3,oneof"`
}

func (*TelemetryCommand_Settings) isTelemetryCommand_Command() {}

func (*TelemetryCommand_ThreadStackTrace) isTelemetryCommand_Command() {}

func (*TelemetryCommand_VerifyMessageResult) isTelemetryCommand_Command() {}

func (*TelemetryCommand_RecoverOrphanedTransactionCommand) isTelemetryCommand_Command() {}

func (*TelemetryCommand_PrintThreadStackTraceCommand) isTelemetryCommand_Command() {}

func (*TelemetryCommand_VerifyMessageCommand) isTelemetryCommand_Command() {}

func (*TelemetryCommand_ReconnectEndpointsCommand) isTelemetryCommand_Command() {}

type NotifyClientTerminationRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Consumer group, which is absent for producer.
	Group         *Resource `protobuf:"bytes,1,opt,name=group,proto3,oneof" json:"group,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *NotifyClientTerminationRequest) Reset() {
	*x = NotifyClientTerminationRequest{}
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NotifyClientTerminationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NotifyClientTerminationRequest) ProtoMessage() {}

func (x *NotifyClientTerminationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NotifyClientTerminationRequest.ProtoReflect.Descriptor instead.
func (*NotifyClientTerminationRequest) Descriptor() ([]byte, []int) {
	return file_apache_rocketmq_v2_service_proto_rawDescGZIP(), []int{26}
}

func (x *NotifyClientTerminationRequest) GetGroup() *Resource {
	if x != nil {
		return x.Group
	}
	return nil
}

type NotifyClientTerminationResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Status        *Status                `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *NotifyClientTerminationResponse) Reset() {
	*x = NotifyClientTerminationResponse{}
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NotifyClientTerminationResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NotifyClientTerminationResponse) ProtoMessage() {}

func (x *NotifyClientTerminationResponse) ProtoReflect() protoreflect.Message {
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NotifyClientTerminationResponse.ProtoReflect.Descriptor instead.
func (*NotifyClientTerminationResponse) Descriptor() ([]byte, []int) {
	return file_apache_rocketmq_v2_service_proto_rawDescGZIP(), []int{27}
}

func (x *NotifyClientTerminationResponse) GetStatus() *Status {
	if x != nil {
		return x.Status
	}
	return nil
}

type ChangeInvisibleDurationRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	Group *Resource              `protobuf:"bytes,1,opt,name=group,proto3" json:"group,omitempty"`
	Topic *Resource              `protobuf:"bytes,2,opt,name=topic,proto3" json:"topic,omitempty"`
	// Unique receipt handle to identify message to change
	ReceiptHandle string `protobuf:"bytes,3,opt,name=receipt_handle,json=receiptHandle,proto3" json:"receipt_handle,omitempty"`
	// New invisible duration
	InvisibleDuration *durationpb.Duration `protobuf:"bytes,4,opt,name=invisible_duration,json=invisibleDuration,proto3" json:"invisible_duration,omitempty"`
	// For message tracing
	MessageId     string `protobuf:"bytes,5,opt,name=message_id,json=messageId,proto3" json:"message_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ChangeInvisibleDurationRequest) Reset() {
	*x = ChangeInvisibleDurationRequest{}
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ChangeInvisibleDurationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChangeInvisibleDurationRequest) ProtoMessage() {}

func (x *ChangeInvisibleDurationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChangeInvisibleDurationRequest.ProtoReflect.Descriptor instead.
func (*ChangeInvisibleDurationRequest) Descriptor() ([]byte, []int) {
	return file_apache_rocketmq_v2_service_proto_rawDescGZIP(), []int{28}
}

func (x *ChangeInvisibleDurationRequest) GetGroup() *Resource {
	if x != nil {
		return x.Group
	}
	return nil
}

func (x *ChangeInvisibleDurationRequest) GetTopic() *Resource {
	if x != nil {
		return x.Topic
	}
	return nil
}

func (x *ChangeInvisibleDurationRequest) GetReceiptHandle() string {
	if x != nil {
		return x.ReceiptHandle
	}
	return ""
}

func (x *ChangeInvisibleDurationRequest) GetInvisibleDuration() *durationpb.Duration {
	if x != nil {
		return x.InvisibleDuration
	}
	return nil
}

func (x *ChangeInvisibleDurationRequest) GetMessageId() string {
	if x != nil {
		return x.MessageId
	}
	return ""
}

type ChangeInvisibleDurationResponse struct {
	state  protoimpl.MessageState `protogen:"open.v1"`
	Status *Status                `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
	// Server may generate a new receipt handle for the message.
	ReceiptHandle string `protobuf:"bytes,2,opt,name=receipt_handle,json=receiptHandle,proto3" json:"receipt_handle,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ChangeInvisibleDurationResponse) Reset() {
	*x = ChangeInvisibleDurationResponse{}
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ChangeInvisibleDurationResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChangeInvisibleDurationResponse) ProtoMessage() {}

func (x *ChangeInvisibleDurationResponse) ProtoReflect() protoreflect.Message {
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChangeInvisibleDurationResponse.ProtoReflect.Descriptor instead.
func (*ChangeInvisibleDurationResponse) Descriptor() ([]byte, []int) {
	return file_apache_rocketmq_v2_service_proto_rawDescGZIP(), []int{29}
}

func (x *ChangeInvisibleDurationResponse) GetStatus() *Status {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *ChangeInvisibleDurationResponse) GetReceiptHandle() string {
	if x != nil {
		return x.ReceiptHandle
	}
	return ""
}

type PullMessageRequest struct {
	state              protoimpl.MessageState `protogen:"open.v1"`
	Group              *Resource              `protobuf:"bytes,1,opt,name=group,proto3" json:"group,omitempty"`
	MessageQueue       *MessageQueue          `protobuf:"bytes,2,opt,name=message_queue,json=messageQueue,proto3" json:"message_queue,omitempty"`
	Offset             int64                  `protobuf:"varint,3,opt,name=offset,proto3" json:"offset,omitempty"`
	BatchSize          int32                  `protobuf:"varint,4,opt,name=batch_size,json=batchSize,proto3" json:"batch_size,omitempty"`
	FilterExpression   *FilterExpression      `protobuf:"bytes,5,opt,name=filter_expression,json=filterExpression,proto3" json:"filter_expression,omitempty"`
	LongPollingTimeout *durationpb.Duration   `protobuf:"bytes,6,opt,name=long_polling_timeout,json=longPollingTimeout,proto3" json:"long_polling_timeout,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *PullMessageRequest) Reset() {
	*x = PullMessageRequest{}
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PullMessageRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PullMessageRequest) ProtoMessage() {}

func (x *PullMessageRequest) ProtoReflect() protoreflect.Message {
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PullMessageRequest.ProtoReflect.Descriptor instead.
func (*PullMessageRequest) Descriptor() ([]byte, []int) {
	return file_apache_rocketmq_v2_service_proto_rawDescGZIP(), []int{30}
}

func (x *PullMessageRequest) GetGroup() *Resource {
	if x != nil {
		return x.Group
	}
	return nil
}

func (x *PullMessageRequest) GetMessageQueue() *MessageQueue {
	if x != nil {
		return x.MessageQueue
	}
	return nil
}

func (x *PullMessageRequest) GetOffset() int64 {
	if x != nil {
		return x.Offset
	}
	return 0
}

func (x *PullMessageRequest) GetBatchSize() int32 {
	if x != nil {
		return x.BatchSize
	}
	return 0
}

func (x *PullMessageRequest) GetFilterExpression() *FilterExpression {
	if x != nil {
		return x.FilterExpression
	}
	return nil
}

func (x *PullMessageRequest) GetLongPollingTimeout() *durationpb.Duration {
	if x != nil {
		return x.LongPollingTimeout
	}
	return nil
}

type PullMessageResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to Content:
	//
	//	*PullMessageResponse_Status
	//	*PullMessageResponse_Message
	//	*PullMessageResponse_NextOffset
	Content       isPullMessageResponse_Content `protobuf_oneof:"content"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PullMessageResponse) Reset() {
	*x = PullMessageResponse{}
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PullMessageResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PullMessageResponse) ProtoMessage() {}

func (x *PullMessageResponse) ProtoReflect() protoreflect.Message {
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PullMessageResponse.ProtoReflect.Descriptor instead.
func (*PullMessageResponse) Descriptor() ([]byte, []int) {
	return file_apache_rocketmq_v2_service_proto_rawDescGZIP(), []int{31}
}

func (x *PullMessageResponse) GetContent() isPullMessageResponse_Content {
	if x != nil {
		return x.Content
	}
	return nil
}

func (x *PullMessageResponse) GetStatus() *Status {
	if x != nil {
		if x, ok := x.Content.(*PullMessageResponse_Status); ok {
			return x.Status
		}
	}
	return nil
}

func (x *PullMessageResponse) GetMessage() *Message {
	if x != nil {
		if x, ok := x.Content.(*PullMessageResponse_Message); ok {
			return x.Message
		}
	}
	return nil
}

func (x *PullMessageResponse) GetNextOffset() int64 {
	if x != nil {
		if x, ok := x.Content.(*PullMessageResponse_NextOffset); ok {
			return x.NextOffset
		}
	}
	return 0
}

type isPullMessageResponse_Content interface {
	isPullMessageResponse_Content()
}

type PullMessageResponse_Status struct {
	Status *Status `protobuf:"bytes,1,opt,name=status,proto3,oneof"`
}

type PullMessageResponse_Message struct {
	Message *Message `protobuf:"bytes,2,opt,name=message,proto3,oneof"`
}

type PullMessageResponse_NextOffset struct {
	NextOffset int64 `protobuf:"varint,3,opt,name=next_offset,json=nextOffset,proto3,oneof"`
}

func (*PullMessageResponse_Status) isPullMessageResponse_Content() {}

func (*PullMessageResponse_Message) isPullMessageResponse_Content() {}

func (*PullMessageResponse_NextOffset) isPullMessageResponse_Content() {}

type UpdateOffsetRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Group         *Resource              `protobuf:"bytes,1,opt,name=group,proto3" json:"group,omitempty"`
	MessageQueue  *MessageQueue          `protobuf:"bytes,2,opt,name=message_queue,json=messageQueue,proto3" json:"message_queue,omitempty"`
	Offset        int64                  `protobuf:"varint,3,opt,name=offset,proto3" json:"offset,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpdateOffsetRequest) Reset() {
	*x = UpdateOffsetRequest{}
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateOffsetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateOffsetRequest) ProtoMessage() {}

func (x *UpdateOffsetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateOffsetRequest.ProtoReflect.Descriptor instead.
func (*UpdateOffsetRequest) Descriptor() ([]byte, []int) {
	return file_apache_rocketmq_v2_service_proto_rawDescGZIP(), []int{32}
}

func (x *UpdateOffsetRequest) GetGroup() *Resource {
	if x != nil {
		return x.Group
	}
	return nil
}

func (x *UpdateOffsetRequest) GetMessageQueue() *MessageQueue {
	if x != nil {
		return x.MessageQueue
	}
	return nil
}

func (x *UpdateOffsetRequest) GetOffset() int64 {
	if x != nil {
		return x.Offset
	}
	return 0
}

type UpdateOffsetResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Status        *Status                `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpdateOffsetResponse) Reset() {
	*x = UpdateOffsetResponse{}
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[33]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateOffsetResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateOffsetResponse) ProtoMessage() {}

func (x *UpdateOffsetResponse) ProtoReflect() protoreflect.Message {
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[33]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateOffsetResponse.ProtoReflect.Descriptor instead.
func (*UpdateOffsetResponse) Descriptor() ([]byte, []int) {
	return file_apache_rocketmq_v2_service_proto_rawDescGZIP(), []int{33}
}

func (x *UpdateOffsetResponse) GetStatus() *Status {
	if x != nil {
		return x.Status
	}
	return nil
}

type GetOffsetRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Group         *Resource              `protobuf:"bytes,1,opt,name=group,proto3" json:"group,omitempty"`
	MessageQueue  *MessageQueue          `protobuf:"bytes,2,opt,name=message_queue,json=messageQueue,proto3" json:"message_queue,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetOffsetRequest) Reset() {
	*x = GetOffsetRequest{}
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[34]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetOffsetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetOffsetRequest) ProtoMessage() {}

func (x *GetOffsetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[34]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetOffsetRequest.ProtoReflect.Descriptor instead.
func (*GetOffsetRequest) Descriptor() ([]byte, []int) {
	return file_apache_rocketmq_v2_service_proto_rawDescGZIP(), []int{34}
}

func (x *GetOffsetRequest) GetGroup() *Resource {
	if x != nil {
		return x.Group
	}
	return nil
}

func (x *GetOffsetRequest) GetMessageQueue() *MessageQueue {
	if x != nil {
		return x.MessageQueue
	}
	return nil
}

type GetOffsetResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Status        *Status                `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
	Offset        int64                  `protobuf:"varint,2,opt,name=offset,proto3" json:"offset,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetOffsetResponse) Reset() {
	*x = GetOffsetResponse{}
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[35]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetOffsetResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetOffsetResponse) ProtoMessage() {}

func (x *GetOffsetResponse) ProtoReflect() protoreflect.Message {
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[35]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetOffsetResponse.ProtoReflect.Descriptor instead.
func (*GetOffsetResponse) Descriptor() ([]byte, []int) {
	return file_apache_rocketmq_v2_service_proto_rawDescGZIP(), []int{35}
}

func (x *GetOffsetResponse) GetStatus() *Status {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *GetOffsetResponse) GetOffset() int64 {
	if x != nil {
		return x.Offset
	}
	return 0
}

type QueryOffsetRequest struct {
	state             protoimpl.MessageState `protogen:"open.v1"`
	MessageQueue      *MessageQueue          `protobuf:"bytes,1,opt,name=message_queue,json=messageQueue,proto3" json:"message_queue,omitempty"`
	QueryOffsetPolicy QueryOffsetPolicy      `protobuf:"varint,2,opt,name=query_offset_policy,json=queryOffsetPolicy,proto3,enum=apache.rocketmq.v2.QueryOffsetPolicy" json:"query_offset_policy,omitempty"`
	Timestamp         *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=timestamp,proto3,oneof" json:"timestamp,omitempty"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *QueryOffsetRequest) Reset() {
	*x = QueryOffsetRequest{}
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[36]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *QueryOffsetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryOffsetRequest) ProtoMessage() {}

func (x *QueryOffsetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[36]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryOffsetRequest.ProtoReflect.Descriptor instead.
func (*QueryOffsetRequest) Descriptor() ([]byte, []int) {
	return file_apache_rocketmq_v2_service_proto_rawDescGZIP(), []int{36}
}

func (x *QueryOffsetRequest) GetMessageQueue() *MessageQueue {
	if x != nil {
		return x.MessageQueue
	}
	return nil
}

func (x *QueryOffsetRequest) GetQueryOffsetPolicy() QueryOffsetPolicy {
	if x != nil {
		return x.QueryOffsetPolicy
	}
	return QueryOffsetPolicy_BEGINNING
}

func (x *QueryOffsetRequest) GetTimestamp() *timestamppb.Timestamp {
	if x != nil {
		return x.Timestamp
	}
	return nil
}

type QueryOffsetResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Status        *Status                `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
	Offset        int64                  `protobuf:"varint,2,opt,name=offset,proto3" json:"offset,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *QueryOffsetResponse) Reset() {
	*x = QueryOffsetResponse{}
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[37]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *QueryOffsetResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryOffsetResponse) ProtoMessage() {}

func (x *QueryOffsetResponse) ProtoReflect() protoreflect.Message {
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[37]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryOffsetResponse.ProtoReflect.Descriptor instead.
func (*QueryOffsetResponse) Descriptor() ([]byte, []int) {
	return file_apache_rocketmq_v2_service_proto_rawDescGZIP(), []int{37}
}

func (x *QueryOffsetResponse) GetStatus() *Status {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *QueryOffsetResponse) GetOffset() int64 {
	if x != nil {
		return x.Offset
	}
	return 0
}

type RecallMessageRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	Topic *Resource              `protobuf:"bytes,1,opt,name=topic,proto3" json:"topic,omitempty"`
	// Refer to SendResultEntry.
	RecallHandle  string `protobuf:"bytes,2,opt,name=recall_handle,json=recallHandle,proto3" json:"recall_handle,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RecallMessageRequest) Reset() {
	*x = RecallMessageRequest{}
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[38]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RecallMessageRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RecallMessageRequest) ProtoMessage() {}

func (x *RecallMessageRequest) ProtoReflect() protoreflect.Message {
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[38]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RecallMessageRequest.ProtoReflect.Descriptor instead.
func (*RecallMessageRequest) Descriptor() ([]byte, []int) {
	return file_apache_rocketmq_v2_service_proto_rawDescGZIP(), []int{38}
}

func (x *RecallMessageRequest) GetTopic() *Resource {
	if x != nil {
		return x.Topic
	}
	return nil
}

func (x *RecallMessageRequest) GetRecallHandle() string {
	if x != nil {
		return x.RecallHandle
	}
	return ""
}

type RecallMessageResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Status        *Status                `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
	MessageId     string                 `protobuf:"bytes,2,opt,name=message_id,json=messageId,proto3" json:"message_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RecallMessageResponse) Reset() {
	*x = RecallMessageResponse{}
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[39]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RecallMessageResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RecallMessageResponse) ProtoMessage() {}

func (x *RecallMessageResponse) ProtoReflect() protoreflect.Message {
	mi := &file_apache_rocketmq_v2_service_proto_msgTypes[39]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RecallMessageResponse.ProtoReflect.Descriptor instead.
func (*RecallMessageResponse) Descriptor() ([]byte, []int) {
	return file_apache_rocketmq_v2_service_proto_rawDescGZIP(), []int{39}
}

func (x *RecallMessageResponse) GetStatus() *Status {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *RecallMessageResponse) GetMessageId() string {
	if x != nil {
		return x.MessageId
	}
	return ""
}

var File_apache_rocketmq_v2_service_proto protoreflect.FileDescriptor

const file_apache_rocketmq_v2_service_proto_rawDesc = "" +
	"\n" +
	" apache/rocketmq/v2/service.proto\x12\x12apache.rocketmq.v2\x1a\x1egoogle/protobuf/duration.proto\x1a\x1fgoogle/protobuf/timestamp.proto\x1a#apache/rocketmq/v2/definition.proto\"\x84\x01\n" +
	"\x11QueryRouteRequest\x122\n" +
	"\x05topic\x18\x01 \x01(\v2\x1c.apache.rocketmq.v2.ResourceR\x05topic\x12;\n" +
	"\tendpoints\x18\x02 \x01(\v2\x1d.apache.rocketmq.v2.EndpointsR\tendpoints\"\x91\x01\n" +
	"\x12QueryRouteResponse\x122\n" +
	"\x06status\x18\x01 \x01(\v2\x1a.apache.rocketmq.v2.StatusR\x06status\x12G\n" +
	"\x0emessage_queues\x18\x02 \x03(\v2 .apache.rocketmq.v2.MessageQueueR\rmessageQueues\"M\n" +
	"\x12SendMessageRequest\x127\n" +
	"\bmessages\x18\x01 \x03(\v2\x1b.apache.rocketmq.v2.MessageR\bmessages\"\xc8\x01\n" +
	"\x0fSendResultEntry\x122\n" +
	"\x06status\x18\x01 \x01(\v2\x1a.apache.rocketmq.v2.StatusR\x06status\x12\x1d\n" +
	"\n" +
	"message_id\x18\x02 \x01(\tR\tmessageId\x12%\n" +
	"\x0etransaction_id\x18\x03 \x01(\tR\rtransactionId\x12\x16\n" +
	"\x06offset\x18\x04 \x01(\x03R\x06offset\x12#\n" +
	"\rrecall_handle\x18\x05 \x01(\tR\frecallHandle\"\x88\x01\n" +
	"\x13SendMessageResponse\x122\n" +
	"\x06status\x18\x01 \x01(\v2\x1a.apache.rocketmq.v2.StatusR\x06status\x12=\n" +
	"\aentries\x18\x02 \x03(\v2#.apache.rocketmq.v2.SendResultEntryR\aentries\"\xbd\x01\n" +
	"\x16QueryAssignmentRequest\x122\n" +
	"\x05topic\x18\x01 \x01(\v2\x1c.apache.rocketmq.v2.ResourceR\x05topic\x122\n" +
	"\x05group\x18\x02 \x01(\v2\x1c.apache.rocketmq.v2.ResourceR\x05group\x12;\n" +
	"\tendpoints\x18\x03 \x01(\v2\x1d.apache.rocketmq.v2.EndpointsR\tendpoints\"\x8f\x01\n" +
	"\x17QueryAssignmentResponse\x122\n" +
	"\x06status\x18\x01 \x01(\v2\x1a.apache.rocketmq.v2.StatusR\x06status\x12@\n" +
	"\vassignments\x18\x02 \x03(\v2\x1e.apache.rocketmq.v2.AssignmentR\vassignments\"\xa7\x04\n" +
	"\x15ReceiveMessageRequest\x122\n" +
	"\x05group\x18\x01 \x01(\v2\x1c.apache.rocketmq.v2.ResourceR\x05group\x12E\n" +
	"\rmessage_queue\x18\x02 \x01(\v2 .apache.rocketmq.v2.MessageQueueR\fmessageQueue\x12Q\n" +
	"\x11filter_expression\x18\x03 \x01(\v2$.apache.rocketmq.v2.FilterExpressionR\x10filterExpression\x12\x1d\n" +
	"\n" +
	"batch_size\x18\x04 \x01(\x05R\tbatchSize\x12M\n" +
	"\x12invisible_duration\x18\x05 \x01(\v2\x19.google.protobuf.DurationH\x00R\x11invisibleDuration\x88\x01\x01\x12\x1d\n" +
	"\n" +
	"auto_renew\x18\x06 \x01(\bR\tautoRenew\x12P\n" +
	"\x14long_polling_timeout\x18\a \x01(\v2\x19.google.protobuf.DurationH\x01R\x12longPollingTimeout\x88\x01\x01\x12\"\n" +
	"\n" +
	"attempt_id\x18\b \x01(\tH\x02R\tattemptId\x88\x01\x01B\x15\n" +
	"\x13_invisible_durationB\x17\n" +
	"\x15_long_polling_timeoutB\r\n" +
	"\v_attempt_id\"\xdf\x01\n" +
	"\x16ReceiveMessageResponse\x124\n" +
	"\x06status\x18\x01 \x01(\v2\x1a.apache.rocketmq.v2.StatusH\x00R\x06status\x127\n" +
	"\amessage\x18\x02 \x01(\v2\x1b.apache.rocketmq.v2.MessageH\x00R\amessage\x12K\n" +
	"\x12delivery_timestamp\x18\x03 \x01(\v2\x1a.google.protobuf.TimestampH\x00R\x11deliveryTimestampB\t\n" +
	"\acontent\"W\n" +
	"\x0fAckMessageEntry\x12\x1d\n" +
	"\n" +
	"message_id\x18\x01 \x01(\tR\tmessageId\x12%\n" +
	"\x0ereceipt_handle\x18\x02 \x01(\tR\rreceiptHandle\"\xba\x01\n" +
	"\x11AckMessageRequest\x122\n" +
	"\x05group\x18\x01 \x01(\v2\x1c.apache.rocketmq.v2.ResourceR\x05group\x122\n" +
	"\x05topic\x18\x02 \x01(\v2\x1c.apache.rocketmq.v2.ResourceR\x05topic\x12=\n" +
	"\aentries\x18\x03 \x03(\v2#.apache.rocketmq.v2.AckMessageEntryR\aentries\"\x91\x01\n" +
	"\x15AckMessageResultEntry\x12\x1d\n" +
	"\n" +
	"message_id\x18\x01 \x01(\tR\tmessageId\x12%\n" +
	"\x0ereceipt_handle\x18\x02 \x01(\tR\rreceiptHandle\x122\n" +
	"\x06status\x18\x03 \x01(\v2\x1a.apache.rocketmq.v2.StatusR\x06status\"\x8d\x01\n" +
	"\x12AckMessageResponse\x122\n" +
	"\x06status\x18\x01 \x01(\v2\x1a.apache.rocketmq.v2.StatusR\x06status\x12C\n" +
	"\aentries\x18\x02 \x03(\v2).apache.rocketmq.v2.AckMessageResultEntryR\aentries\"\xb5\x02\n" +
	"&ForwardMessageToDeadLetterQueueRequest\x122\n" +
	"\x05group\x18\x01 \x01(\v2\x1c.apache.rocketmq.v2.ResourceR\x05group\x122\n" +
	"\x05topic\x18\x02 \x01(\v2\x1c.apache.rocketmq.v2.ResourceR\x05topic\x12%\n" +
	"\x0ereceipt_handle\x18\x03 \x01(\tR\rreceiptHandle\x12\x1d\n" +
	"\n" +
	"message_id\x18\x04 \x01(\tR\tmessageId\x12)\n" +
	"\x10delivery_attempt\x18\x05 \x01(\x05R\x0fdeliveryAttempt\x122\n" +
	"\x15max_delivery_attempts\x18\x06 \x01(\x05R\x13maxDeliveryAttempts\"]\n" +
	"'ForwardMessageToDeadLetterQueueResponse\x122\n" +
	"\x06status\x18\x01 \x01(\v2\x1a.apache.rocketmq.v2.StatusR\x06status\"\x96\x01\n" +
	"\x10HeartbeatRequest\x127\n" +
	"\x05group\x18\x01 \x01(\v2\x1c.apache.rocketmq.v2.ResourceH\x00R\x05group\x88\x01\x01\x12?\n" +
	"\vclient_type\x18\x02 \x01(\x0e2\x1e.apache.rocketmq.v2.ClientTypeR\n" +
	"clientTypeB\b\n" +
	"\x06_group\"G\n" +
	"\x11HeartbeatResponse\x122\n" +
	"\x06status\x18\x01 \x01(\v2\x1a.apache.rocketmq.v2.StatusR\x06status\"\xc0\x02\n" +
	"\x15EndTransactionRequest\x122\n" +
	"\x05topic\x18\x01 \x01(\v2\x1c.apache.rocketmq.v2.ResourceR\x05topic\x12\x1d\n" +
	"\n" +
	"message_id\x18\x02 \x01(\tR\tmessageId\x12%\n" +
	"\x0etransaction_id\x18\x03 \x01(\tR\rtransactionId\x12I\n" +
	"\n" +
	"resolution\x18\x04 \x01(\x0e2).apache.rocketmq.v2.TransactionResolutionR\n" +
	"resolution\x12=\n" +
	"\x06source\x18\x05 \x01(\x0e2%.apache.rocketmq.v2.TransactionSourceR\x06source\x12#\n" +
	"\rtrace_context\x18\x06 \x01(\tR\ftraceContext\"L\n" +
	"\x16EndTransactionResponse\x122\n" +
	"\x06status\x18\x01 \x01(\v2\x1a.apache.rocketmq.v2.StatusR\x06status\"4\n" +
	"\x1cPrintThreadStackTraceCommand\x12\x14\n" +
	"\x05nonce\x18\x01 \x01(\tR\x05nonce\"1\n" +
	"\x19ReconnectEndpointsCommand\x12\x14\n" +
	"\x05nonce\x18\x01 \x01(\tR\x05nonce\"r\n" +
	"\x10ThreadStackTrace\x12\x14\n" +
	"\x05nonce\x18\x01 \x01(\tR\x05nonce\x121\n" +
	"\x12thread_stack_trace\x18\x02 \x01(\tH\x00R\x10threadStackTrace\x88\x01\x01B\x15\n" +
	"\x13_thread_stack_trace\"c\n" +
	"\x14VerifyMessageCommand\x12\x14\n" +
	"\x05nonce\x18\x01 \x01(\tR\x05nonce\x125\n" +
	"\amessage\x18\x02 \x01(\v2\x1b.apache.rocketmq.v2.MessageR\amessage\"+\n" +
	"\x13VerifyMessageResult\x12\x14\n" +
	"\x05nonce\x18\x01 \x01(\tR\x05nonce\"\x81\x01\n" +
	"!RecoverOrphanedTransactionCommand\x125\n" +
	"\amessage\x18\x01 \x01(\v2\x1b.apache.rocketmq.v2.MessageR\amessage\x12%\n" +
	"\x0etransaction_id\x18\x02 \x01(\tR\rtransactionId\"\xac\x06\n" +
	"\x10TelemetryCommand\x127\n" +
	"\x06status\x18\x01 \x01(\v2\x1a.apache.rocketmq.v2.StatusH\x01R\x06status\x88\x01\x01\x12:\n" +
	"\bsettings\x18\x02 \x01(\v2\x1c.apache.rocketmq.v2.SettingsH\x00R\bsettings\x12T\n" +
	"\x12thread_stack_trace\x18\x03 \x01(\v2$.apache.rocketmq.v2.ThreadStackTraceH\x00R\x10threadStackTrace\x12]\n" +
	"\x15verify_message_result\x18\x04 \x01(\v2'.apache.rocketmq.v2.VerifyMessageResultH\x00R\x13verifyMessageResult\x12\x88\x01\n" +
	"$recover_orphaned_transaction_command\x18\x05 \x01(\v25.apache.rocketmq.v2.RecoverOrphanedTransactionCommandH\x00R!recoverOrphanedTransactionCommand\x12z\n" +
	" print_thread_stack_trace_command\x18\x06 \x01(\v20.apache.rocketmq.v2.PrintThreadStackTraceCommandH\x00R\x1cprintThreadStackTraceCommand\x12`\n" +
	"\x16verify_message_command\x18\a \x01(\v2(.apache.rocketmq.v2.VerifyMessageCommandH\x00R\x14verifyMessageCommand\x12o\n" +
	"\x1breconnect_endpoints_command\x18\b \x01(\v2-.apache.rocketmq.v2.ReconnectEndpointsCommandH\x00R\x19reconnectEndpointsCommandB\t\n" +
	"\acommandB\t\n" +
	"\a_status\"c\n" +
	"\x1eNotifyClientTerminationRequest\x127\n" +
	"\x05group\x18\x01 \x01(\v2\x1c.apache.rocketmq.v2.ResourceH\x00R\x05group\x88\x01\x01B\b\n" +
	"\x06_group\"U\n" +
	"\x1fNotifyClientTerminationResponse\x122\n" +
	"\x06status\x18\x01 \x01(\v2\x1a.apache.rocketmq.v2.StatusR\x06status\"\x98\x02\n" +
	"\x1eChangeInvisibleDurationRequest\x122\n" +
	"\x05group\x18\x01 \x01(\v2\x1c.apache.rocketmq.v2.ResourceR\x05group\x122\n" +
	"\x05topic\x18\x02 \x01(\v2\x1c.apache.rocketmq.v2.ResourceR\x05topic\x12%\n" +
	"\x0ereceipt_handle\x18\x03 \x01(\tR\rreceiptHandle\x12H\n" +
	"\x12invisible_duration\x18\x04 \x01(\v2\x19.google.protobuf.DurationR\x11invisibleDuration\x12\x1d\n" +
	"\n" +
	"message_id\x18\x05 \x01(\tR\tmessageId\"|\n" +
	"\x1fChangeInvisibleDurationResponse\x122\n" +
	"\x06status\x18\x01 \x01(\v2\x1a.apache.rocketmq.v2.StatusR\x06status\x12%\n" +
	"\x0ereceipt_handle\x18\x02 \x01(\tR\rreceiptHandle\"\xe6\x02\n" +
	"\x12PullMessageRequest\x122\n" +
	"\x05group\x18\x01 \x01(\v2\x1c.apache.rocketmq.v2.ResourceR\x05group\x12E\n" +
	"\rmessage_queue\x18\x02 \x01(\v2 .apache.rocketmq.v2.MessageQueueR\fmessageQueue\x12\x16\n" +
	"\x06offset\x18\x03 \x01(\x03R\x06offset\x12\x1d\n" +
	"\n" +
	"batch_size\x18\x04 \x01(\x05R\tbatchSize\x12Q\n" +
	"\x11filter_expression\x18\x05 \x01(\v2$.apache.rocketmq.v2.FilterExpressionR\x10filterExpression\x12K\n" +
	"\x14long_polling_timeout\x18\x06 \x01(\v2\x19.google.protobuf.DurationR\x12longPollingTimeout\"\xb2\x01\n" +
	"\x13PullMessageResponse\x124\n" +
	"\x06status\x18\x01 \x01(\v2\x1a.apache.rocketmq.v2.StatusH\x00R\x06status\x127\n" +
	"\amessage\x18\x02 \x01(\v2\x1b.apache.rocketmq.v2.MessageH\x00R\amessage\x12!\n" +
	"\vnext_offset\x18\x03 \x01(\x03H\x00R\n" +
	"nextOffsetB\t\n" +
	"\acontent\"\xa8\x01\n" +
	"\x13UpdateOffsetRequest\x122\n" +
	"\x05group\x18\x01 \x01(\v2\x1c.apache.rocketmq.v2.ResourceR\x05group\x12E\n" +
	"\rmessage_queue\x18\x02 \x01(\v2 .apache.rocketmq.v2.MessageQueueR\fmessageQueue\x12\x16\n" +
	"\x06offset\x18\x03 \x01(\x03R\x06offset\"J\n" +
	"\x14UpdateOffsetResponse\x122\n" +
	"\x06status\x18\x01 \x01(\v2\x1a.apache.rocketmq.v2.StatusR\x06status\"\x8d\x01\n" +
	"\x10GetOffsetRequest\x122\n" +
	"\x05group\x18\x01 \x01(\v2\x1c.apache.rocketmq.v2.ResourceR\x05group\x12E\n" +
	"\rmessage_queue\x18\x02 \x01(\v2 .apache.rocketmq.v2.MessageQueueR\fmessageQueue\"_\n" +
	"\x11GetOffsetResponse\x122\n" +
	"\x06status\x18\x01 \x01(\v2\x1a.apache.rocketmq.v2.StatusR\x06status\x12\x16\n" +
	"\x06offset\x18\x02 \x01(\x03R\x06offset\"\xff\x01\n" +
	"\x12QueryOffsetRequest\x12E\n" +
	"\rmessage_queue\x18\x01 \x01(\v2 .apache.rocketmq.v2.MessageQueueR\fmessageQueue\x12U\n" +
	"\x13query_offset_policy\x18\x02 \x01(\x0e2%.apache.rocketmq.v2.QueryOffsetPolicyR\x11queryOffsetPolicy\x12=\n" +
	"\ttimestamp\x18\x03 \x01(\v2\x1a.google.protobuf.TimestampH\x00R\ttimestamp\x88\x01\x01B\f\n" +
	"\n" +
	"_timestamp\"a\n" +
	"\x13QueryOffsetResponse\x122\n" +
	"\x06status\x18\x01 \x01(\v2\x1a.apache.rocketmq.v2.StatusR\x06status\x12\x16\n" +
	"\x06offset\x18\x02 \x01(\x03R\x06offset\"o\n" +
	"\x14RecallMessageRequest\x122\n" +
	"\x05topic\x18\x01 \x01(\v2\x1c.apache.rocketmq.v2.ResourceR\x05topic\x12#\n" +
	"\rrecall_handle\x18\x02 \x01(\tR\frecallHandle\"j\n" +
	"\x15RecallMessageResponse\x122\n" +
	"\x06status\x18\x01 \x01(\v2\x1a.apache.rocketmq.v2.StatusR\x06status\x12\x1d\n" +
	"\n" +
	"message_id\x18\x02 \x01(\tR\tmessageId2\xcf\r\n" +
	"\x10MessagingService\x12]\n" +
	"\n" +
	"QueryRoute\x12%.apache.rocketmq.v2.QueryRouteRequest\x1a&.apache.rocketmq.v2.QueryRouteResponse\"\x00\x12Z\n" +
	"\tHeartbeat\x12$.apache.rocketmq.v2.HeartbeatRequest\x1a%.apache.rocketmq.v2.HeartbeatResponse\"\x00\x12`\n" +
	"\vSendMessage\x12&.apache.rocketmq.v2.SendMessageRequest\x1a'.apache.rocketmq.v2.SendMessageResponse\"\x00\x12l\n" +
	"\x0fQueryAssignment\x12*.apache.rocketmq.v2.QueryAssignmentRequest\x1a+.apache.rocketmq.v2.QueryAssignmentResponse\"\x00\x12k\n" +
	"\x0eReceiveMessage\x12).apache.rocketmq.v2.ReceiveMessageRequest\x1a*.apache.rocketmq.v2.ReceiveMessageResponse\"\x000\x01\x12]\n" +
	"\n" +
	"AckMessage\x12%.apache.rocketmq.v2.AckMessageRequest\x1a&.apache.rocketmq.v2.AckMessageResponse\"\x00\x12\x9c\x01\n" +
	"\x1fForwardMessageToDeadLetterQueue\x12:.apache.rocketmq.v2.ForwardMessageToDeadLetterQueueRequest\x1a;.apache.rocketmq.v2.ForwardMessageToDeadLetterQueueResponse\"\x00\x12b\n" +
	"\vPullMessage\x12&.apache.rocketmq.v2.PullMessageRequest\x1a'.apache.rocketmq.v2.PullMessageResponse\"\x000\x01\x12c\n" +
	"\fUpdateOffset\x12'.apache.rocketmq.v2.UpdateOffsetRequest\x1a(.apache.rocketmq.v2.UpdateOffsetResponse\"\x00\x12Z\n" +
	"\tGetOffset\x12$.apache.rocketmq.v2.GetOffsetRequest\x1a%.apache.rocketmq.v2.GetOffsetResponse\"\x00\x12`\n" +
	"\vQueryOffset\x12&.apache.rocketmq.v2.QueryOffsetRequest\x1a'.apache.rocketmq.v2.QueryOffsetResponse\"\x00\x12i\n" +
	"\x0eEndTransaction\x12).apache.rocketmq.v2.EndTransactionRequest\x1a*.apache.rocketmq.v2.EndTransactionResponse\"\x00\x12]\n" +
	"\tTelemetry\x12$.apache.rocketmq.v2.TelemetryCommand\x1a$.apache.rocketmq.v2.TelemetryCommand\"\x00(\x010\x01\x12\x84\x01\n" +
	"\x17NotifyClientTermination\x122.apache.rocketmq.v2.NotifyClientTerminationRequest\x1a3.apache.rocketmq.v2.NotifyClientTerminationResponse\"\x00\x12\x84\x01\n" +
	"\x17ChangeInvisibleDuration\x122.apache.rocketmq.v2.ChangeInvisibleDurationRequest\x1a3.apache.rocketmq.v2.ChangeInvisibleDurationResponse\"\x00\x12f\n" +
	"\rRecallMessage\x12(.apache.rocketmq.v2.RecallMessageRequest\x1a).apache.rocketmq.v2.RecallMessageResponse\"\x00BP\n" +
	"\x12apache.rocketmq.v2B\tMQServiceP\x01Z\x12apache.rocketmq.v2\xa0\x01\x01\xd8\x01\x01\xaa\x02\x12Apache.Rocketmq.V2b\x06proto3"

var (
	file_apache_rocketmq_v2_service_proto_rawDescOnce sync.Once
	file_apache_rocketmq_v2_service_proto_rawDescData []byte
)

func file_apache_rocketmq_v2_service_proto_rawDescGZIP() []byte {
	file_apache_rocketmq_v2_service_proto_rawDescOnce.Do(func() {
		file_apache_rocketmq_v2_service_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_apache_rocketmq_v2_service_proto_rawDesc), len(file_apache_rocketmq_v2_service_proto_rawDesc)))
	})
	return file_apache_rocketmq_v2_service_proto_rawDescData
}

var file_apache_rocketmq_v2_service_proto_msgTypes = make([]protoimpl.MessageInfo, 40)
var file_apache_rocketmq_v2_service_proto_goTypes = []any{
	(*QueryRouteRequest)(nil),                       // 0: apache.rocketmq.v2.QueryRouteRequest
	(*QueryRouteResponse)(nil),                      // 1: apache.rocketmq.v2.QueryRouteResponse
	(*SendMessageRequest)(nil),                      // 2: apache.rocketmq.v2.SendMessageRequest
	(*SendResultEntry)(nil),                         // 3: apache.rocketmq.v2.SendResultEntry
	(*SendMessageResponse)(nil),                     // 4: apache.rocketmq.v2.SendMessageResponse
	(*QueryAssignmentRequest)(nil),                  // 5: apache.rocketmq.v2.QueryAssignmentRequest
	(*QueryAssignmentResponse)(nil),                 // 6: apache.rocketmq.v2.QueryAssignmentResponse
	(*ReceiveMessageRequest)(nil),                   // 7: apache.rocketmq.v2.ReceiveMessageRequest
	(*ReceiveMessageResponse)(nil),                  // 8: apache.rocketmq.v2.ReceiveMessageResponse
	(*AckMessageEntry)(nil),                         // 9: apache.rocketmq.v2.AckMessageEntry
	(*AckMessageRequest)(nil),                       // 10: apache.rocketmq.v2.AckMessageRequest
	(*AckMessageResultEntry)(nil),                   // 11: apache.rocketmq.v2.AckMessageResultEntry
	(*AckMessageResponse)(nil),                      // 12: apache.rocketmq.v2.AckMessageResponse
	(*ForwardMessageToDeadLetterQueueRequest)(nil),  // 13: apache.rocketmq.v2.ForwardMessageToDeadLetterQueueRequest
	(*ForwardMessageToDeadLetterQueueResponse)(nil), // 14: apache.rocketmq.v2.ForwardMessageToDeadLetterQueueResponse
	(*HeartbeatRequest)(nil),                        // 15: apache.rocketmq.v2.HeartbeatRequest
	(*HeartbeatResponse)(nil),                       // 16: apache.rocketmq.v2.HeartbeatResponse
	(*EndTransactionRequest)(nil),                   // 17: apache.rocketmq.v2.EndTransactionRequest
	(*EndTransactionResponse)(nil),                  // 18: apache.rocketmq.v2.EndTransactionResponse
	(*PrintThreadStackTraceCommand)(nil),            // 19: apache.rocketmq.v2.PrintThreadStackTraceCommand
	(*ReconnectEndpointsCommand)(nil),               // 20: apache.rocketmq.v2.ReconnectEndpointsCommand
	(*ThreadStackTrace)(nil),                        // 21: apache.rocketmq.v2.ThreadStackTrace
	(*VerifyMessageCommand)(nil),                    // 22: apache.rocketmq.v2.VerifyMessageCommand
	(*VerifyMessageResult)(nil),                     // 23: apache.rocketmq.v2.VerifyMessageResult
	(*RecoverOrphanedTransactionCommand)(nil),       // 24: apache.rocketmq.v2.RecoverOrphanedTransactionCommand
	(*TelemetryCommand)(nil),                        // 25: apache.rocketmq.v2.TelemetryCommand
	(*NotifyClientTerminationRequest)(nil),          // 26: apache.rocketmq.v2.NotifyClientTerminationRequest
	(*NotifyClientTerminationResponse)(nil),         // 27: apache.rocketmq.v2.NotifyClientTerminationResponse
	(*ChangeInvisibleDurationRequest)(nil),          // 28: apache.rocketmq.v2.ChangeInvisibleDurationRequest
	(*ChangeInvisibleDurationResponse)(nil),         // 29: apache.rocketmq.v2.ChangeInvisibleDurationResponse
	(*PullMessageRequest)(nil),                      // 30: apache.rocketmq.v2.PullMessageRequest
	(*PullMessageResponse)(nil),                     // 31: apache.rocketmq.v2.PullMessageResponse
	(*UpdateOffsetRequest)(nil),                     // 32: apache.rocketmq.v2.UpdateOffsetRequest
	(*UpdateOffsetResponse)(nil),                    // 33: apache.rocketmq.v2.UpdateOffsetResponse
	(*GetOffsetRequest)(nil),                        // 34: apache.rocketmq.v2.GetOffsetRequest
	(*GetOffsetResponse)(nil),                       // 35: apache.rocketmq.v2.GetOffsetResponse
	(*QueryOffsetRequest)(nil),                      // 36: apache.rocketmq.v2.QueryOffsetRequest
	(*QueryOffsetResponse)(nil),                     // 37: apache.rocketmq.v2.QueryOffsetResponse
	(*RecallMessageRequest)(nil),                    // 38: apache.rocketmq.v2.RecallMessageRequest
	(*RecallMessageResponse)(nil),                   // 39: apache.rocketmq.v2.RecallMessageResponse
	(*Resource)(nil),                                // 40: apache.rocketmq.v2.Resource
	(*Endpoints)(nil),                               // 41: apache.rocketmq.v2.Endpoints
	(*Status)(nil),                                  // 42: apache.rocketmq.v2.Status
	(*MessageQueue)(nil),                            // 43: apache.rocketmq.v2.MessageQueue
	(*Message)(nil),                                 // 44: apache.rocketmq.v2.Message
	(*Assignment)(nil),                              // 45: apache.rocketmq.v2.Assignment
	(*FilterExpression)(nil),                        // 46: apache.rocketmq.v2.FilterExpression
	(*durationpb.Duration)(nil),                     // 47: google.protobuf.Duration
	(*timestamppb.Timestamp)(nil),                   // 48: google.protobuf.Timestamp
	(ClientType)(0),                                 // 49: apache.rocketmq.v2.ClientType
	(TransactionResolution)(0),                      // 50: apache.rocketmq.v2.TransactionResolution
	(TransactionSource)(0),                          // 51: apache.rocketmq.v2.TransactionSource
	(*Settings)(nil),                                // 52: apache.rocketmq.v2.Settings
	(QueryOffsetPolicy)(0),                          // 53: apache.rocketmq.v2.QueryOffsetPolicy
}
var file_apache_rocketmq_v2_service_proto_depIdxs = []int32{
	40, // 0: apache.rocketmq.v2.QueryRouteRequest.topic:type_name -> apache.rocketmq.v2.Resource
	41, // 1: apache.rocketmq.v2.QueryRouteRequest.endpoints:type_name -> apache.rocketmq.v2.Endpoints
	42, // 2: apache.rocketmq.v2.QueryRouteResponse.status:type_name -> apache.rocketmq.v2.Status
	43, // 3: apache.rocketmq.v2.QueryRouteResponse.message_queues:type_name -> apache.rocketmq.v2.MessageQueue
	44, // 4: apache.rocketmq.v2.SendMessageRequest.messages:type_name -> apache.rocketmq.v2.Message
	42, // 5: apache.rocketmq.v2.SendResultEntry.status:type_name -> apache.rocketmq.v2.Status
	42, // 6: apache.rocketmq.v2.SendMessageResponse.status:type_name -> apache.rocketmq.v2.Status
	3,  // 7: apache.rocketmq.v2.SendMessageResponse.entries:type_name -> apache.rocketmq.v2.SendResultEntry
	40, // 8: apache.rocketmq.v2.QueryAssignmentRequest.topic:type_name -> apache.rocketmq.v2.Resource
	40, // 9: apache.rocketmq.v2.QueryAssignmentRequest.group:type_name -> apache.rocketmq.v2.Resource
	41, // 10: apache.rocketmq.v2.QueryAssignmentRequest.endpoints:type_name -> apache.rocketmq.v2.Endpoints
	42, // 11: apache.rocketmq.v2.QueryAssignmentResponse.status:type_name -> apache.rocketmq.v2.Status
	45, // 12: apache.rocketmq.v2.QueryAssignmentResponse.assignments:type_name -> apache.rocketmq.v2.Assignment
	40, // 13: apache.rocketmq.v2.ReceiveMessageRequest.group:type_name -> apache.rocketmq.v2.Resource
	43, // 14: apache.rocketmq.v2.ReceiveMessageRequest.message_queue:type_name -> apache.rocketmq.v2.MessageQueue
	46, // 15: apache.rocketmq.v2.ReceiveMessageRequest.filter_expression:type_name -> apache.rocketmq.v2.FilterExpression
	47, // 16: apache.rocketmq.v2.ReceiveMessageRequest.invisible_duration:type_name -> google.protobuf.Duration
	47, // 17: apache.rocketmq.v2.ReceiveMessageRequest.long_polling_timeout:type_name -> google.protobuf.Duration
	42, // 18: apache.rocketmq.v2.ReceiveMessageResponse.status:type_name -> apache.rocketmq.v2.Status
	44, // 19: apache.rocketmq.v2.ReceiveMessageResponse.message:type_name -> apache.rocketmq.v2.Message
	48, // 20: apache.rocketmq.v2.ReceiveMessageResponse.delivery_timestamp:type_name -> google.protobuf.Timestamp
	40, // 21: apache.rocketmq.v2.AckMessageRequest.group:type_name -> apache.rocketmq.v2.Resource
	40, // 22: apache.rocketmq.v2.AckMessageRequest.topic:type_name -> apache.rocketmq.v2.Resource
	9,  // 23: apache.rocketmq.v2.AckMessageRequest.entries:type_name -> apache.rocketmq.v2.AckMessageEntry
	42, // 24: apache.rocketmq.v2.AckMessageResultEntry.status:type_name -> apache.rocketmq.v2.Status
	42, // 25: apache.rocketmq.v2.AckMessageResponse.status:type_name -> apache.rocketmq.v2.Status
	11, // 26: apache.rocketmq.v2.AckMessageResponse.entries:type_name -> apache.rocketmq.v2.AckMessageResultEntry
	40, // 27: apache.rocketmq.v2.ForwardMessageToDeadLetterQueueRequest.group:type_name -> apache.rocketmq.v2.Resource
	40, // 28: apache.rocketmq.v2.ForwardMessageToDeadLetterQueueRequest.topic:type_name -> apache.rocketmq.v2.Resource
	42, // 29: apache.rocketmq.v2.ForwardMessageToDeadLetterQueueResponse.status:type_name -> apache.rocketmq.v2.Status
	40, // 30: apache.rocketmq.v2.HeartbeatRequest.group:type_name -> apache.rocketmq.v2.Resource
	49, // 31: apache.rocketmq.v2.HeartbeatRequest.client_type:type_name -> apache.rocketmq.v2.ClientType
	42, // 32: apache.rocketmq.v2.HeartbeatResponse.status:type_name -> apache.rocketmq.v2.Status
	40, // 33: apache.rocketmq.v2.EndTransactionRequest.topic:type_name -> apache.rocketmq.v2.Resource
	50, // 34: apache.rocketmq.v2.EndTransactionRequest.resolution:type_name -> apache.rocketmq.v2.TransactionResolution
	51, // 35: apache.rocketmq.v2.EndTransactionRequest.source:type_name -> apache.rocketmq.v2.TransactionSource
	42, // 36: apache.rocketmq.v2.EndTransactionResponse.status:type_name -> apache.rocketmq.v2.Status
	44, // 37: apache.rocketmq.v2.VerifyMessageCommand.message:type_name -> apache.rocketmq.v2.Message
	44, // 38: apache.rocketmq.v2.RecoverOrphanedTransactionCommand.message:type_name -> apache.rocketmq.v2.Message
	42, // 39: apache.rocketmq.v2.TelemetryCommand.status:type_name -> apache.rocketmq.v2.Status
	52, // 40: apache.rocketmq.v2.TelemetryCommand.settings:type_name -> apache.rocketmq.v2.Settings
	21, // 41: apache.rocketmq.v2.TelemetryCommand.thread_stack_trace:type_name -> apache.rocketmq.v2.ThreadStackTrace
	23, // 42: apache.rocketmq.v2.TelemetryCommand.verify_message_result:type_name -> apache.rocketmq.v2.VerifyMessageResult
	24, // 43: apache.rocketmq.v2.TelemetryCommand.recover_orphaned_transaction_command:type_name -> apache.rocketmq.v2.RecoverOrphanedTransactionCommand
	19, // 44: apache.rocketmq.v2.TelemetryCommand.print_thread_stack_trace_command:type_name -> apache.rocketmq.v2.PrintThreadStackTraceCommand
	22, // 45: apache.rocketmq.v2.TelemetryCommand.verify_message_command:type_name -> apache.rocketmq.v2.VerifyMessageCommand
	20, // 46: apache.rocketmq.v2.TelemetryCommand.reconnect_endpoints_command:type_name -> apache.rocketmq.v2.ReconnectEndpointsCommand
	40, // 47: apache.rocketmq.v2.NotifyClientTerminationRequest.group:type_name -> apache.rocketmq.v2.Resource
	42, // 48: apache.rocketmq.v2.NotifyClientTerminationResponse.status:type_name -> apache.rocketmq.v2.Status
	40, // 49: apache.rocketmq.v2.ChangeInvisibleDurationRequest.group:type_name -> apache.rocketmq.v2.Resource
	40, // 50: apache.rocketmq.v2.ChangeInvisibleDurationRequest.topic:type_name -> apache.rocketmq.v2.Resource
	47, // 51: apache.rocketmq.v2.ChangeInvisibleDurationRequest.invisible_duration:type_name -> google.protobuf.Duration
	42, // 52: apache.rocketmq.v2.ChangeInvisibleDurationResponse.status:type_name -> apache.rocketmq.v2.Status
	40, // 53: apache.rocketmq.v2.PullMessageRequest.group:type_name -> apache.rocketmq.v2.Resource
	43, // 54: apache.rocketmq.v2.PullMessageRequest.message_queue:type_name -> apache.rocketmq.v2.MessageQueue
	46, // 55: apache.rocketmq.v2.PullMessageRequest.filter_expression:type_name -> apache.rocketmq.v2.FilterExpression
	47, // 56: apache.rocketmq.v2.PullMessageRequest.long_polling_timeout:type_name -> google.protobuf.Duration
	42, // 57: apache.rocketmq.v2.PullMessageResponse.status:type_name -> apache.rocketmq.v2.Status
	44, // 58: apache.rocketmq.v2.PullMessageResponse.message:type_name -> apache.rocketmq.v2.Message
	40, // 59: apache.rocketmq.v2.UpdateOffsetRequest.group:type_name -> apache.rocketmq.v2.Resource
	43, // 60: apache.rocketmq.v2.UpdateOffsetRequest.message_queue:type_name -> apache.rocketmq.v2.MessageQueue
	42, // 61: apache.rocketmq.v2.UpdateOffsetResponse.status:type_name -> apache.rocketmq.v2.Status
	40, // 62: apache.rocketmq.v2.GetOffsetRequest.group:type_name -> apache.rocketmq.v2.Resource
	43, // 63: apache.rocketmq.v2.GetOffsetRequest.message_queue:type_name -> apache.rocketmq.v2.MessageQueue
	42, // 64: apache.rocketmq.v2.GetOffsetResponse.status:type_name -> apache.rocketmq.v2.Status
	43, // 65: apache.rocketmq.v2.QueryOffsetRequest.message_queue:type_name -> apache.rocketmq.v2.MessageQueue
	53, // 66: apache.rocketmq.v2.QueryOffsetRequest.query_offset_policy:type_name -> apache.rocketmq.v2.QueryOffsetPolicy
	48, // 67: apache.rocketmq.v2.QueryOffsetRequest.timestamp:type_name -> google.protobuf.Timestamp
	42, // 68: apache.rocketmq.v2.QueryOffsetResponse.status:type_name -> apache.rocketmq.v2.Status
	40, // 69: apache.rocketmq.v2.RecallMessageRequest.topic:type_name -> apache.rocketmq.v2.Resource
	42, // 70: apache.rocketmq.v2.RecallMessageResponse.status:type_name -> apache.rocketmq.v2.Status
	0,  // 71: apache.rocketmq.v2.MessagingService.QueryRoute:input_type -> apache.rocketmq.v2.QueryRouteRequest
	15, // 72: apache.rocketmq.v2.MessagingService.Heartbeat:input_type -> apache.rocketmq.v2.HeartbeatRequest
	2,  // 73: apache.rocketmq.v2.MessagingService.SendMessage:input_type -> apache.rocketmq.v2.SendMessageRequest
	5,  // 74: apache.rocketmq.v2.MessagingService.QueryAssignment:input_type -> apache.rocketmq.v2.QueryAssignmentRequest
	7,  // 75: apache.rocketmq.v2.MessagingService.ReceiveMessage:input_type -> apache.rocketmq.v2.ReceiveMessageRequest
	10, // 76: apache.rocketmq.v2.MessagingService.AckMessage:input_type -> apache.rocketmq.v2.AckMessageRequest
	13, // 77: apache.rocketmq.v2.MessagingService.ForwardMessageToDeadLetterQueue:input_type -> apache.rocketmq.v2.ForwardMessageToDeadLetterQueueRequest
	30, // 78: apache.rocketmq.v2.MessagingService.PullMessage:input_type -> apache.rocketmq.v2.PullMessageRequest
	32, // 79: apache.rocketmq.v2.MessagingService.UpdateOffset:input_type -> apache.rocketmq.v2.UpdateOffsetRequest
	34, // 80: apache.rocketmq.v2.MessagingService.GetOffset:input_type -> apache.rocketmq.v2.GetOffsetRequest
	36, // 81: apache.rocketmq.v2.MessagingService.QueryOffset:input_type -> apache.rocketmq.v2.QueryOffsetRequest
	17, // 82: apache.rocketmq.v2.MessagingService.EndTransaction:input_type -> apache.rocketmq.v2.EndTransactionRequest
	25, // 83: apache.rocketmq.v2.MessagingService.Telemetry:input_type -> apache.rocketmq.v2.TelemetryCommand
	26, // 84: apache.rocketmq.v2.MessagingService.NotifyClientTermination:input_type -> apache.rocketmq.v2.NotifyClientTerminationRequest
	28, // 85: apache.rocketmq.v2.MessagingService.ChangeInvisibleDuration:input_type -> apache.rocketmq.v2.ChangeInvisibleDurationRequest
	38, // 86: apache.rocketmq.v2.MessagingService.RecallMessage:input_type -> apache.rocketmq.v2.RecallMessageRequest
	1,  // 87: apache.rocketmq.v2.MessagingService.QueryRoute:output_type -> apache.rocketmq.v2.QueryRouteResponse
	16, // 88: apache.rocketmq.v2.MessagingService.Heartbeat:output_type -> apache.rocketmq.v2.HeartbeatResponse
	4,  // 89: apache.rocketmq.v2.MessagingService.SendMessage:output_type -> apache.rocketmq.v2.SendMessageResponse
	6,  // 90: apache.rocketmq.v2.MessagingService.QueryAssignment:output_type -> apache.rocketmq.v2.QueryAssignmentResponse
	8,  // 91: apache.rocketmq.v2.MessagingService.ReceiveMessage:output_type -> apache.rocketmq.v2.ReceiveMessageResponse
	12, // 92: apache.rocketmq.v2.MessagingService.AckMessage:output_type -> apache.rocketmq.v2.AckMessageResponse
	14, // 93: apache.rocketmq.v2.MessagingService.ForwardMessageToDeadLetterQueue:output_type -> apache.rocketmq.v2.ForwardMessageToDeadLetterQueueResponse
	31, // 94: apache.rocketmq.v2.MessagingService.PullMessage:output_type -> apache.rocketmq.v2.PullMessageResponse
	33, // 95: apache.rocketmq.v2.MessagingService.UpdateOffset:output_type -> apache.rocketmq.v2.UpdateOffsetResponse
	35, // 96: apache.rocketmq.v2.MessagingService.GetOffset:output_type -> apache.rocketmq.v2.GetOffsetResponse
	37, // 97: apache.rocketmq.v2.MessagingService.QueryOffset:output_type -> apache.rocketmq.v2.QueryOffsetResponse
	18, // 98: apache.rocketmq.v2.MessagingService.EndTransaction:output_type -> apache.rocketmq.v2.EndTransactionResponse
	25, // 99: apache.rocketmq.v2.MessagingService.Telemetry:output_type -> apache.rocketmq.v2.TelemetryCommand
	27, // 100: apache.rocketmq.v2.MessagingService.NotifyClientTermination:output_type -> apache.rocketmq.v2.NotifyClientTerminationResponse
	29, // 101: apache.rocketmq.v2.MessagingService.ChangeInvisibleDuration:output_type -> apache.rocketmq.v2.ChangeInvisibleDurationResponse
	39, // 102: apache.rocketmq.v2.MessagingService.RecallMessage:output_type -> apache.rocketmq.v2.RecallMessageResponse
	87, // [87:103] is the sub-list for method output_type
	71, // [71:87] is the sub-list for method input_type
	71, // [71:71] is the sub-list for extension type_name
	71, // [71:71] is the sub-list for extension extendee
	0,  // [0:71] is the sub-list for field type_name
}

func init() { file_apache_rocketmq_v2_service_proto_init() }
func file_apache_rocketmq_v2_service_proto_init() {
	if File_apache_rocketmq_v2_service_proto != nil {
		return
	}
	file_apache_rocketmq_v2_definition_proto_init()
	file_apache_rocketmq_v2_service_proto_msgTypes[7].OneofWrappers = []any{}
	file_apache_rocketmq_v2_service_proto_msgTypes[8].OneofWrappers = []any{
		(*ReceiveMessageResponse_Status)(nil),
		(*ReceiveMessageResponse_Message)(nil),
		(*ReceiveMessageResponse_DeliveryTimestamp)(nil),
	}
	file_apache_rocketmq_v2_service_proto_msgTypes[15].OneofWrappers = []any{}
	file_apache_rocketmq_v2_service_proto_msgTypes[21].OneofWrappers = []any{}
	file_apache_rocketmq_v2_service_proto_msgTypes[25].OneofWrappers = []any{
		(*TelemetryCommand_Settings)(nil),
		(*TelemetryCommand_ThreadStackTrace)(nil),
		(*TelemetryCommand_VerifyMessageResult)(nil),
		(*TelemetryCommand_RecoverOrphanedTransactionCommand)(nil),
		(*TelemetryCommand_PrintThreadStackTraceCommand)(nil),
		(*TelemetryCommand_VerifyMessageCommand)(nil),
		(*TelemetryCommand_ReconnectEndpointsCommand)(nil),
	}
	file_apache_rocketmq_v2_service_proto_msgTypes[26].OneofWrappers = []any{}
	file_apache_rocketmq_v2_service_proto_msgTypes[31].OneofWrappers = []any{
		(*PullMessageResponse_Status)(nil),
		(*PullMessageResponse_Message)(nil),
		(*PullMessageResponse_NextOffset)(nil),
	}
	file_apache_rocketmq_v2_service_proto_msgTypes[36].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_apache_rocketmq_v2_service_proto_rawDesc), len(file_apache_rocketmq_v2_service_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   40,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_apache_rocketmq_v2_service_proto_goTypes,
		DependencyIndexes: file_apache_rocketmq_v2_service_proto_depIdxs,
		MessageInfos:      file_apache_rocketmq_v2_service_proto_msgTypes,
	}.Build()
	File_apache_rocketmq_v2_service_proto = out.File
	file_apache_rocketmq_v2_service_proto_goTypes = nil
	file_apache_rocketmq_v2_service_proto_depIdxs = nil
}
