/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.tools;

import java.io.File;
import java.io.IOException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.fdf.FDFDocument;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.tools.ImportFDF;

public class ImportXFDF {
    public void importFDF(PDDocument pdfDocument, FDFDocument fdfDocument) throws IOException {
        PDDocumentCatalog docCatalog = pdfDocument.getDocumentCatalog();
        PDAcroForm acroForm = docCatalog.getAcroForm();
        acroForm.setCacheFields(true);
        acroForm.importFDF(fdfDocument);
    }

    public static void main(String[] args) throws IOException {
        System.setProperty("apple.awt.UIElement", "true");
        ImportXFDF importer = new ImportXFDF();
        importer.importXFDF(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importXFDF(String[] args) throws IOException {
        PDDocument pdf = null;
        FDFDocument fdf = null;
        try {
            if (args.length != 3) {
                ImportXFDF.usage();
            } else {
                ImportFDF importer = new ImportFDF();
                pdf = PDDocument.load(new File(args[0]));
                fdf = FDFDocument.loadXFDF(args[1]);
                importer.importFDF(pdf, fdf);
                pdf.save(args[2]);
            }
        }
        finally {
            this.close(fdf);
            this.close(pdf);
        }
    }

    private static void usage() {
        System.err.println("usage: org.apache.pdfbox.tools.ImportXFDF <pdf-file> <fdf-file> <output-file>");
        System.exit(1);
    }

    public void close(FDFDocument doc) throws IOException {
        if (doc != null) {
            doc.close();
        }
    }

    public void close(PDDocument doc) throws IOException {
        if (doc != null) {
            doc.close();
        }
    }
}

