/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.provider.hook;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.registry.hook.Event;
import org.apache.nifi.registry.hook.EventField;
import org.apache.nifi.registry.hook.WhitelistFilteringEventHookProvider;
import org.apache.nifi.registry.provider.ProviderConfigurationContext;
import org.apache.nifi.registry.provider.ProviderCreationException;
import org.apache.nifi.registry.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptEventHookProvider
extends WhitelistFilteringEventHookProvider {
    static final Logger LOGGER = LoggerFactory.getLogger(ScriptEventHookProvider.class);
    static final String SCRIPT_PATH_PROP = "Script Path";
    static final String SCRIPT_WORKDIR_PROP = "Working Directory";
    private File scriptFile;
    private File workDirFile;

    public void handle(Event event) {
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.scriptFile.getAbsolutePath());
        command.add(event.getEventType().name());
        for (EventField arg : event.getFields()) {
            command.add(arg.getValue());
        }
        String commandString = StringUtils.join(command, (String)" ");
        ProcessBuilder builder = new ProcessBuilder(command);
        builder.directory(this.workDirFile);
        LOGGER.debug("Execution of {}", (Object)commandString);
        try {
            builder.start();
        }
        catch (IOException e) {
            LOGGER.error("Command Execution Failed: {}", (Object)commandString, (Object)e);
        }
    }

    public void onConfigured(ProviderConfigurationContext configurationContext) throws ProviderCreationException {
        super.onConfigured(configurationContext);
        Map props = configurationContext.getProperties();
        if (!props.containsKey(SCRIPT_PATH_PROP)) {
            throw new ProviderCreationException("The property Script Path must be provided");
        }
        String scripPath = (String)props.get(SCRIPT_PATH_PROP);
        if (StringUtils.isBlank((CharSequence)scripPath)) {
            throw new ProviderCreationException("The property Script Path cannot be null or blank");
        }
        if (props.containsKey(SCRIPT_WORKDIR_PROP) && !StringUtils.isBlank((CharSequence)((CharSequence)props.get(SCRIPT_WORKDIR_PROP)))) {
            String workdir = (String)props.get(SCRIPT_WORKDIR_PROP);
            try {
                this.workDirFile = new File(workdir);
                FileUtils.ensureDirectoryExistAndCanRead((File)this.workDirFile);
            }
            catch (IOException e) {
                throw new ProviderCreationException("The working directory " + workdir + " cannot be read.");
            }
        }
        this.scriptFile = new File(scripPath);
        if (!this.scriptFile.isFile() || !this.scriptFile.canExecute()) {
            throw new ProviderCreationException("The script file " + this.scriptFile.getAbsolutePath() + " cannot be executed.");
        }
        LOGGER.info("Configured ScriptEventHookProvider with script {}", (Object)this.scriptFile.getAbsolutePath());
    }
}

