/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.tf.tools.enhancer;

import java.util.HashSet;
import java.util.Set;
import org.glassfish.pfl.basic.contain.SynchronizedHolder;
import org.glassfish.pfl.objectweb.asm.ClassVisitor;
import org.glassfish.pfl.objectweb.asm.Label;
import org.glassfish.pfl.objectweb.asm.MethodAdapter;
import org.glassfish.pfl.objectweb.asm.MethodVisitor;
import org.glassfish.pfl.objectweb.asm.Type;
import org.glassfish.pfl.objectweb.asm.commons.LocalVariablesSorter;
import org.glassfish.pfl.objectweb.asm.tree.LabelNode;
import org.glassfish.pfl.objectweb.asm.tree.LocalVariableNode;
import org.glassfish.pfl.tf.spi.EnhancedClassData;
import org.glassfish.pfl.tf.spi.MethodMonitor;
import org.glassfish.pfl.tf.spi.Util;
import org.glassfish.pfl.tf.spi.annotation.TraceEnhanceLevel;
import org.glassfish.pfl.tf.tools.enhancer.SimpleMethodTracer;
import org.glassfish.pfl.tf.tools.enhancer.TFEnhanceAdapter;

public class ClassTracer
extends TFEnhanceAdapter {
    private static final int MAX_EXTRA_STACK = 7;
    private final Util util;
    private final EnhancedClassData ecd;
    private State current = State.NORMAL;

    private void info(int level, String msg) {
        this.util.info(level, "ClassTracer: " + msg);
    }

    public ClassTracer(Util util, EnhancedClassData ecd, ClassVisitor cv) {
        super(cv, TraceEnhanceLevel.PHASE1, TraceEnhanceLevel.PHASE2, ecd);
        this.util = util;
        this.ecd = ecd;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String sig, String[] exceptions) {
        this.info(2, "visitMethod: " + name + desc);
        String fullDesc = this.util.getFullMethodDescriptor(name, desc);
        EnhancedClassData.MethodType mtype = this.ecd.classifyMethod(fullDesc);
        MethodVisitor mv = super.visitMethod(access, name, desc, sig, exceptions);
        if (this.util.getDebug()) {
            mv = new SimpleMethodTracer(mv, this.util);
        }
        switch (mtype) {
            case STATIC_INITIALIZER: 
            case INFO_METHOD: 
            case NORMAL_METHOD: {
                return mv;
            }
            case MONITORED_METHOD: {
                MonitoredMethodEnhancer mme = new MonitoredMethodEnhancer(access, name, desc, mv);
                LocalVariablesSorter lvs = new LocalVariablesSorter(access, desc, (MethodVisitor)mme);
                mme.setLocalVariablesSorter(lvs);
                return lvs;
            }
        }
        return null;
    }

    private class MonitoredMethodEnhancer
    extends MethodAdapter {
        private final int access;
        private final String name;
        private final String desc;
        private final MethodVisitor lmv;
        private final int identVal;
        private final Set<Integer> returnOpcodes;
        private final Label start;
        private final LabelNode startNode;
        private final Label excHandler;
        private final LabelNode excHandlerNode;
        private final Label end;
        private final LabelNode endNode;
        private final Label afterExcStore;
        private final LabelNode afterExcStoreNode;
        private LocalVariablesSorter lvs;
        private LocalVariableNode __result;
        private LocalVariableNode __mm;
        private LocalVariableNode __exc;

        public void setLocalVariablesSorter(LocalVariablesSorter lvs) {
            this.lvs = lvs;
            Type type = Type.getReturnType((String)this.desc);
            this.__result = !type.equals((Object)Type.VOID_TYPE) ? new LocalVariableNode("__$result$__", type.getDescriptor(), null, this.startNode, this.endNode, lvs.newLocal(type)) : null;
            type = Type.getType(MethodMonitor.class);
            this.__mm = new LocalVariableNode("__$mm$__", type.getDescriptor(), null, this.startNode, this.endNode, lvs.newLocal(type));
            type = Type.getType(Throwable.class);
            this.__exc = new LocalVariableNode("__$exc$__", type.getDescriptor(), null, this.excHandlerNode, this.endNode, lvs.newLocal(type));
        }

        public MonitoredMethodEnhancer(int access, String name, String desc, MethodVisitor mv) {
            super(mv);
            this.returnOpcodes = new HashSet<Integer>();
            this.start = new Label();
            this.startNode = new LabelNode(this.start);
            this.excHandler = new Label();
            this.excHandlerNode = new LabelNode(this.excHandler);
            this.end = new Label();
            this.endNode = new LabelNode(this.end);
            this.afterExcStore = new Label();
            this.afterExcStoreNode = new LabelNode(this.end);
            this.lvs = null;
            this.__result = null;
            this.__mm = null;
            this.__exc = null;
            this.access = access;
            this.name = name;
            this.desc = desc;
            this.lmv = mv;
            this.identVal = ClassTracer.this.ecd.getMethodIndex(name);
            this.returnOpcodes.add(177);
            this.returnOpcodes.add(172);
            this.returnOpcodes.add(176);
            this.returnOpcodes.add(173);
            this.returnOpcodes.add(174);
            this.returnOpcodes.add(175);
        }

        public void visitCode() {
            ClassTracer.this.info(2, "visitCode");
            if (this.__result != null) {
                ClassTracer.this.util.initLocal(this.lmv, this.__result);
            }
            String fullDesc = ClassTracer.this.util.getFullMethodDescriptor(this.name, this.desc);
            ClassTracer.this.info(2, "fullDesc = " + fullDesc);
            String fname = ClassTracer.this.ecd.getHolderName(fullDesc);
            this.lmv.visitFieldInsn(178, ClassTracer.this.ecd.getClassName(), fname, Type.getDescriptor(SynchronizedHolder.class));
            this.lmv.visitMethodInsn(182, EnhancedClassData.SH_NAME, "content", "()Ljava/lang/Object;");
            this.lmv.visitTypeInsn(192, EnhancedClassData.MM_NAME);
            this.lmv.visitVarInsn(58, this.__mm.index);
            this.lmv.visitVarInsn(25, this.__mm.index);
            this.lmv.visitJumpInsn(198, this.start);
            this.lmv.visitVarInsn(25, this.__mm.index);
            ClassTracer.this.util.emitIntConstant(this.lmv, this.identVal);
            ClassTracer.this.util.wrapArgs(this.lmv, this.access, this.desc);
            this.lmv.visitMethodInsn(185, EnhancedClassData.MM_NAME, "enter", "(I[Ljava/lang/Object;)V");
            this.lmv.visitLabel(this.start);
        }

        private void emitExceptionReport(int excIndex) {
            ClassTracer.this.info(2, "emitExceptionReport called");
            Label skipLabel = new Label();
            this.lmv.visitVarInsn(25, this.__mm.index);
            this.lmv.visitJumpInsn(198, skipLabel);
            this.lmv.visitVarInsn(25, this.__mm.index);
            ClassTracer.this.util.emitIntConstant(this.lmv, this.identVal);
            this.lmv.visitVarInsn(25, excIndex);
            this.lmv.visitMethodInsn(185, EnhancedClassData.MM_NAME, "exception", "(ILjava/lang/Throwable;)V");
            this.lmv.visitLabel(skipLabel);
        }

        private void emitFinally() {
            ClassTracer.this.info(2, "emitFinally called");
            Label skipLabel = new Label();
            this.lmv.visitVarInsn(25, this.__mm.index);
            this.lmv.visitJumpInsn(198, skipLabel);
            this.lmv.visitVarInsn(25, this.__mm.index);
            ClassTracer.this.util.emitIntConstant(this.lmv, this.identVal);
            Type rtype = Type.getReturnType((String)this.desc);
            if (rtype.equals((Object)Type.VOID_TYPE)) {
                this.lmv.visitMethodInsn(185, EnhancedClassData.MM_NAME, "exit", "(I)V");
            } else {
                ClassTracer.this.util.wrapArg(this.lmv, this.__result.index, Type.getType((String)this.__result.desc));
                this.lmv.visitMethodInsn(185, EnhancedClassData.MM_NAME, "exit", "(ILjava/lang/Object;)V");
            }
            this.lmv.visitLabel(skipLabel);
        }

        public void visitInsn(int opcode) {
            ClassTracer.this.info(2, "visitInsn[" + Util.opcodeToString((int)opcode) + "] called");
            if (opcode == 1) {
                ClassTracer.this.current = ClassTracer.this.current.transition(ClassTracer.this.util, this.mv, Input.ACONST_NULL_BC);
                if (ClassTracer.this.current == State.NORMAL) {
                    this.lmv.visitInsn(opcode);
                }
            } else if (opcode == 3) {
                ClassTracer.this.current = ClassTracer.this.current.transition(ClassTracer.this.util, this.mv, Input.ICONST_0_BC);
                if (ClassTracer.this.current == State.NORMAL) {
                    this.lmv.visitInsn(opcode);
                }
            } else {
                ClassTracer.this.current = ClassTracer.this.current.transition(ClassTracer.this.util, this.mv, Input.OTHER);
                if (opcode == 191) {
                    ClassTracer.this.info(2, "handling throw");
                    int exc = this.lvs.newLocal(Type.getType(Throwable.class));
                    this.lmv.visitVarInsn(58, exc);
                    this.emitExceptionReport(exc);
                    this.lmv.visitVarInsn(25, exc);
                } else if (this.returnOpcodes.contains(opcode)) {
                    ClassTracer.this.info(2, "handling return");
                    ClassTracer.this.util.storeFromXReturn(this.lmv, opcode, this.__result);
                    this.emitFinally();
                    ClassTracer.this.util.loadFromXReturn(this.lmv, opcode, this.__result);
                }
                this.lmv.visitInsn(opcode);
            }
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            ClassTracer.this.info(2, "MM method: visitMethodInsn[" + Util.opcodeToString((int)opcode) + "]: " + owner + "." + name + desc);
            String fullDesc = ClassTracer.this.util.getFullMethodDescriptor(name, desc);
            if (opcode == 183 && owner.equals(ClassTracer.this.ecd.getClassName()) && ClassTracer.this.ecd.classifyMethod(fullDesc) == EnhancedClassData.MethodType.INFO_METHOD) {
                ClassTracer.this.info(2, "rewriting method call");
                ClassTracer.this.current = ClassTracer.this.current.transition(ClassTracer.this.util, this.lmv, Input.INFO_METHOD_CALL);
                this.lmv.visitVarInsn(25, this.__mm.index);
                ClassTracer.this.util.emitIntConstant(this.lmv, this.identVal);
                this.lmv.visitMethodInsn(opcode, owner, name, desc);
            } else {
                ClassTracer.this.current = ClassTracer.this.current.transition(ClassTracer.this.util, this.lmv, Input.OTHER);
                this.lmv.visitMethodInsn(opcode, owner, name, desc);
            }
        }

        public void visitMaxs(int maxStack, int maxLocals) {
            ClassTracer.this.info(2, "MM method: visitMaxs");
            this.lmv.visitLabel(this.end);
            this.lmv.visitLabel(this.excHandler);
            this.lmv.visitTryCatchBlock(this.start, this.end, this.excHandler, null);
            this.lmv.visitTryCatchBlock(this.excHandler, this.afterExcStore, this.excHandler, null);
            this.lmv.visitVarInsn(58, this.__exc.index);
            this.lmv.visitLabel(this.afterExcStore);
            this.emitFinally();
            this.lmv.visitVarInsn(25, this.__exc.index);
            this.lmv.visitInsn(191);
            if (this.__result != null) {
                this.__result.accept(this.lmv);
            }
            this.__mm.accept(this.lmv);
            this.__exc.accept(this.lmv);
            this.lmv.visitMaxs(maxStack + 7, maxLocals);
        }

        public void visitIntInsn(int opcode, int operand) {
            ClassTracer.this.info(2, "visitIntInsn[" + Util.opcodeToString((int)opcode) + "] operand=" + operand);
            ClassTracer.this.current = ClassTracer.this.current.transition(ClassTracer.this.util, this.mv, Input.OTHER);
            this.lmv.visitIntInsn(opcode, operand);
        }

        public void visitVarInsn(int opcode, int var) {
            ClassTracer.this.info(2, "visitVarInsn[" + Util.opcodeToString((int)opcode) + "] var=" + var);
            ClassTracer.this.current = ClassTracer.this.current.transition(ClassTracer.this.util, this.mv, Input.OTHER);
            this.lmv.visitVarInsn(opcode, var);
        }

        public void visitTypeInsn(int opcode, String type) {
            ClassTracer.this.info(2, "visitTypeInsn[" + Util.opcodeToString((int)opcode) + "] type=" + type);
            ClassTracer.this.current = ClassTracer.this.current.transition(ClassTracer.this.util, this.mv, Input.OTHER);
            this.lmv.visitTypeInsn(opcode, type);
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            ClassTracer.this.info(2, "visitFieldInsn[" + Util.opcodeToString((int)opcode) + "] " + owner + "." + name + desc);
            ClassTracer.this.current = ClassTracer.this.current.transition(ClassTracer.this.util, this.mv, Input.OTHER);
            this.lmv.visitFieldInsn(opcode, owner, name, desc);
        }

        public void visitJumpInsn(int opcode, Label label) {
            ClassTracer.this.info(2, "visitTypeInsn[" + Util.opcodeToString((int)opcode) + "] label=" + label);
            ClassTracer.this.current = ClassTracer.this.current.transition(ClassTracer.this.util, this.mv, Input.OTHER);
            this.lmv.visitJumpInsn(opcode, label);
        }

        public void visitLdcInsn(Object cst) {
            ClassTracer.this.info(2, "visitLdcInsn " + cst);
            ClassTracer.this.current = ClassTracer.this.current.transition(ClassTracer.this.util, this.mv, Input.OTHER);
            this.lmv.visitLdcInsn(cst);
        }

        public void visitIincInsn(int var, int increment) {
            ClassTracer.this.info(2, "visitIincInsn  var=" + var + " increment=" + increment);
            ClassTracer.this.current = ClassTracer.this.current.transition(ClassTracer.this.util, this.mv, Input.OTHER);
            this.lmv.visitIincInsn(var, increment);
        }

        public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
            ClassTracer.this.current = ClassTracer.this.current.transition(ClassTracer.this.util, this.mv, Input.OTHER);
            this.lmv.visitTableSwitchInsn(min, max, dflt, labels);
        }

        public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
            ClassTracer.this.current = ClassTracer.this.current.transition(ClassTracer.this.util, this.mv, Input.OTHER);
            this.lmv.visitLookupSwitchInsn(dflt, keys, labels);
        }

        public void visitMultiANewArrayInsn(String desc, int dims) {
            ClassTracer.this.current = ClassTracer.this.current.transition(ClassTracer.this.util, this.mv, Input.OTHER);
            this.lmv.visitMultiANewArrayInsn(desc, dims);
        }
    }

    public static enum State {
        NULL1{

            @Override
            public State transition(Util util, MethodVisitor mv, Input input) {
                State.info(util, 3, "State transition: NULL1 state, Input " + (Object)((Object)input));
                switch (input) {
                    case ICONST_0_BC: {
                        return NULL2;
                    }
                    case ACONST_NULL_BC: 
                    case INFO_METHOD_CALL: 
                    case OTHER: {
                        State.info(util, 4, "Emitting 1 ACONST_NULL");
                        mv.visitInsn(1);
                        return NORMAL;
                    }
                }
                return null;
            }
        }
        ,
        NULL2{

            @Override
            public State transition(Util util, MethodVisitor mv, Input input) {
                State.info(util, 3, "State transition: NULL2 state, Input " + (Object)((Object)input));
                switch (input) {
                    case ICONST_0_BC: 
                    case ACONST_NULL_BC: 
                    case OTHER: {
                        State.info(util, 4, "Emitting ACONST_NULL,ICONST_0");
                        mv.visitInsn(1);
                        mv.visitInsn(3);
                        return NORMAL;
                    }
                    case INFO_METHOD_CALL: {
                        return NORMAL;
                    }
                }
                return null;
            }
        }
        ,
        NORMAL{

            @Override
            public State transition(Util util, MethodVisitor mv, Input input) {
                State.info(util, 3, "State transition: NORMAL state, Input " + (Object)((Object)input));
                switch (input) {
                    case ACONST_NULL_BC: {
                        return NULL1;
                    }
                    case ICONST_0_BC: 
                    case INFO_METHOD_CALL: 
                    case OTHER: {
                        return NORMAL;
                    }
                }
                return null;
            }
        };


        private static void info(Util util, int level, String msg) {
            util.info(level, "ClassTracer.State: " + msg);
        }

        public abstract State transition(Util var1, MethodVisitor var2, Input var3);
    }

    public static enum Input {
        ACONST_NULL_BC,
        ICONST_0_BC,
        INFO_METHOD_CALL,
        OTHER;

    }
}

