/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.xml.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.juneau.AnnotationApplier;
import org.apache.juneau.Context;
import org.apache.juneau.commons.annotation.AppliedAnnotationObject;
import org.apache.juneau.commons.annotation.AppliedOnClassAnnotationObject;
import org.apache.juneau.commons.reflect.AnnotationInfo;
import org.apache.juneau.commons.reflect.ClassInfo;
import org.apache.juneau.commons.reflect.FieldInfo;
import org.apache.juneau.commons.reflect.MethodInfo;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.svl.VarResolverSession;
import org.apache.juneau.xml.annotation.Xml;
import org.apache.juneau.xml.annotation.XmlFormat;

public class XmlAnnotation {
    public static final Xml DEFAULT = XmlAnnotation.create().build();

    public static Xml copy(Xml a, VarResolverSession r) {
        return ((Builder)XmlAnnotation.create().childName(r.resolve(a.childName())).format(a.format()).namespace(r.resolve(a.namespace())).on(r.resolve(a.on())).onClass((Class[])a.onClass())).prefix(r.resolve(a.prefix())).build();
    }

    public static Builder create() {
        return new Builder();
    }

    public static Builder create(Class<?> ... on) {
        return XmlAnnotation.create().on((Class[])on);
    }

    public static Builder create(String ... on) {
        return XmlAnnotation.create().on(on);
    }

    public static class Builder
    extends AppliedAnnotationObject.BuilderTMF {
        private String[] description = new String[0];
        private String childName = "";
        private String namespace = "";
        private String prefix = "";
        private XmlFormat format = XmlFormat.DEFAULT;

        protected Builder() {
            super(Xml.class);
        }

        public Xml build() {
            return new Object(this);
        }

        public Builder description(String ... value) {
            this.description = value;
            return this;
        }

        public Builder childName(String value) {
            this.childName = value;
            return this;
        }

        public Builder format(XmlFormat value) {
            this.format = value;
            return this;
        }

        public Builder namespace(String value) {
            this.namespace = value;
            return this;
        }

        public Builder prefix(String value) {
            this.prefix = value;
            return this;
        }

        @Override
        public Builder on(String ... value) {
            super.on(value);
            return this;
        }

        @Override
        public Builder on(Class<?> ... value) {
            super.on(value);
            return this;
        }

        @Override
        public Builder onClass(Class<?> ... value) {
            super.onClass(value);
            return this;
        }

        @Override
        public Builder on(Method ... value) {
            super.on(value);
            return this;
        }

        @Override
        public Builder on(Field ... value) {
            super.on(value);
            return this;
        }

        @Override
        public Builder on(ClassInfo ... value) {
            super.on(value);
            return this;
        }

        @Override
        public Builder onClass(ClassInfo ... value) {
            super.onClass(value);
            return this;
        }

        @Override
        public Builder on(FieldInfo ... value) {
            super.on(value);
            return this;
        }

        @Override
        public Builder on(MethodInfo ... value) {
            super.on(value);
            return this;
        }
    }

    private static class Object
    extends AppliedOnClassAnnotationObject
    implements Xml {
        private final String[] description;
        private final String childName;
        private final String namespace;
        private final String prefix;
        private final XmlFormat format;

        Object(Builder b) {
            super(b);
            this.description = CollectionUtils.copyOf(b.description);
            this.childName = b.childName;
            this.format = b.format;
            this.namespace = b.namespace;
            this.prefix = b.prefix;
        }

        @Override
        public String childName() {
            return this.childName;
        }

        @Override
        public XmlFormat format() {
            return this.format;
        }

        @Override
        public String namespace() {
            return this.namespace;
        }

        @Override
        public String prefix() {
            return this.prefix;
        }

        @Override
        public String[] description() {
            return this.description;
        }
    }

    @Documented
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    public static @interface Array {
        public Xml[] value();
    }

    public static class Apply
    extends AnnotationApplier<Xml, Context.Builder> {
        public Apply(VarResolverSession vr) {
            super(Xml.class, Context.Builder.class, vr);
        }

        @Override
        public void apply(AnnotationInfo<Xml> ai, Context.Builder b) {
            Xml a = ai.inner();
            if (CollectionUtils.isEmptyArray(a.on()) && CollectionUtils.isEmptyArray(a.onClass())) {
                return;
            }
            b.annotations(XmlAnnotation.copy(a, this.vr()));
        }
    }
}

