/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.juneau.AnnotationApplier;
import org.apache.juneau.BeanContext;
import org.apache.juneau.annotation.Beanp;
import org.apache.juneau.commons.annotation.AppliedAnnotationObject;
import org.apache.juneau.commons.reflect.AnnotationInfo;
import org.apache.juneau.commons.reflect.FieldInfo;
import org.apache.juneau.commons.reflect.MethodInfo;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.svl.VarResolverSession;

public class BeanpAnnotation {
    public static final Beanp DEFAULT = BeanpAnnotation.create().build();

    public static Beanp copy(Beanp a, VarResolverSession r) {
        return BeanpAnnotation.create().dictionary(a.dictionary()).format(r.resolve(a.format())).name(r.resolve(a.name())).on(r.resolve(a.on())).params(a.params()).properties(r.resolve(a.properties())).ro(r.resolve(a.ro())).type(a.type()).value(r.resolve(a.value())).wo(r.resolve(a.wo())).build();
    }

    public static Builder create() {
        return new Builder();
    }

    public static Builder create(String ... on) {
        return BeanpAnnotation.create().on(on);
    }

    public static class Builder
    extends AppliedAnnotationObject.BuilderMF {
        private String[] description = new String[0];
        private Class<?> type = Void.TYPE;
        private Class<?>[] dictionary = new Class[0];
        private Class<?>[] params = new Class[0];
        private String format = "";
        private String name = "";
        private String properties = "";
        private String ro = "";
        private String value = "";
        private String wo = "";

        protected Builder() {
            super(Beanp.class);
        }

        public Beanp build() {
            return new Object(this);
        }

        public Builder description(String ... value) {
            this.description = value;
            return this;
        }

        public Builder dictionary(Class<?> ... value) {
            this.dictionary = value;
            return this;
        }

        public Builder format(String value) {
            this.format = value;
            return this;
        }

        public Builder name(String value) {
            this.name = value;
            return this;
        }

        public Builder params(Class<?> ... value) {
            this.params = value;
            return this;
        }

        public Builder properties(String value) {
            this.properties = value;
            return this;
        }

        public Builder ro(String value) {
            this.ro = value;
            return this;
        }

        public Builder type(Class<?> value) {
            this.type = value;
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            return this;
        }

        public Builder wo(String value) {
            this.wo = value;
            return this;
        }

        public Builder on(String ... value) {
            super.on(value);
            return this;
        }

        public Builder on(Method ... value) {
            super.on(value);
            return this;
        }

        public Builder on(Field ... value) {
            super.on(value);
            return this;
        }

        public Builder on(FieldInfo ... value) {
            super.on(value);
            return this;
        }

        public Builder on(MethodInfo ... value) {
            super.on(value);
            return this;
        }
    }

    private static class Object
    extends AppliedAnnotationObject
    implements Beanp {
        private final String[] description;
        private final Class<?> type;
        private final Class<?>[] params;
        private final Class<?>[] dictionary;
        private final String name;
        private final String value;
        private final String properties;
        private final String format;
        private final String ro;
        private final String wo;

        Object(Builder b) {
            super((AppliedAnnotationObject.Builder)b);
            this.description = (String[])CollectionUtils.copyOf((java.lang.Object[])b.description);
            this.dictionary = (Class[])CollectionUtils.copyOf((java.lang.Object[])b.dictionary);
            this.format = b.format;
            this.name = b.name;
            this.params = (Class[])CollectionUtils.copyOf((java.lang.Object[])b.params);
            this.properties = b.properties;
            this.ro = b.ro;
            this.type = b.type;
            this.value = b.value;
            this.wo = b.wo;
        }

        @Override
        public Class<?>[] dictionary() {
            return this.dictionary;
        }

        @Override
        public String format() {
            return this.format;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Class<?>[] params() {
            return this.params;
        }

        @Override
        public String properties() {
            return this.properties;
        }

        @Override
        public String ro() {
            return this.ro;
        }

        @Override
        public Class<?> type() {
            return this.type;
        }

        @Override
        public String value() {
            return this.value;
        }

        @Override
        public String wo() {
            return this.wo;
        }

        @Override
        public String[] description() {
            return this.description;
        }
    }

    @Documented
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    public static @interface Array {
        public Beanp[] value();
    }

    public static class Applier
    extends AnnotationApplier<Beanp, BeanContext.Builder> {
        public Applier(VarResolverSession vr) {
            super(Beanp.class, BeanContext.Builder.class, vr);
        }

        @Override
        public void apply(AnnotationInfo<Beanp> ai, BeanContext.Builder b) {
            Beanp a = (Beanp)ai.inner();
            if (CollectionUtils.isEmptyArray((java.lang.Object[])a.on())) {
                return;
            }
            b.annotations(BeanpAnnotation.copy(a, this.vr()));
        }
    }
}

