/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.engine.constraint;

import java.util.Objects;
import java.util.Set;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.shacl.compact.writer.CompactOut;
import org.apache.jena.shacl.engine.ValidationContext;
import org.apache.jena.shacl.engine.constraint.ConstraintPairwise;
import org.apache.jena.shacl.lib.ShLib;
import org.apache.jena.shacl.parser.ConstraintVisitor;
import org.apache.jena.shacl.parser.Shape;
import org.apache.jena.shacl.vocabulary.SHACL;
import org.apache.jena.sparql.path.Path;

public class LessThanOrEqualsConstraint
extends ConstraintPairwise {
    public LessThanOrEqualsConstraint(Node value) {
        super(value, SHACL.LessThanOrEqualsConstraintComponent);
    }

    @Override
    public void validate(ValidationContext vCxt, Shape shape, Node focusNode, Path path, Set<Node> pathNodes, Set<Node> compareNodes) {
        for (Node vn : pathNodes) {
            for (Node v : compareNodes) {
                int r = super.compare(vn, v);
                boolean passed = true;
                if (r != -1 && r != 0) {
                    passed = false;
                    String msg = this.toString() + ": value node " + ShLib.displayStr(vn) + " is not less than or equal to " + ShLib.displayStr(v);
                    vCxt.reportEntry(msg, shape, focusNode, path, vn, this);
                }
                boolean finalPassed = passed;
                vCxt.notifyValidationListener(() -> this.makeEventSingleCompareNode(vCxt, shape, focusNode, path, vn, v, finalPassed));
            }
        }
    }

    @Override
    public void visit(ConstraintVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void printCompact(IndentedWriter out, NodeFormatter nodeFmt) {
        CompactOut.compact(out, nodeFmt, "lessThanOrEquals", this.value);
    }

    public String toString() {
        return "LessThanOrEquals[" + ShLib.displayStr(this.value) + "]";
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.value, 4);
    }
}

