/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.grpc;

import io.grpc.ForwardingServerCall;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.Status;
import io.micrometer.core.instrument.binder.grpc.GrpcObservationDocumentation;
import io.micrometer.core.instrument.binder.grpc.GrpcServerObservationContext;
import io.micrometer.observation.Observation;

class ObservationGrpcServerCall<ReqT, RespT>
extends ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT> {
    private final Observation observation;

    ObservationGrpcServerCall(ServerCall<ReqT, RespT> delegate, Observation observation) {
        super(delegate);
        this.observation = observation;
    }

    public void sendHeaders(Metadata headers) {
        super.sendHeaders(headers);
        Observation.Context context2 = this.observation.getContext();
        if (context2 instanceof GrpcServerObservationContext) {
            Metadata headersToKeep = new Metadata();
            headersToKeep.merge(headers);
            ((GrpcServerObservationContext)context2).setHeaders(headersToKeep);
        }
    }

    public void sendMessage(RespT message) {
        this.observation.event(GrpcObservationDocumentation.GrpcServerEvents.MESSAGE_SENT);
        super.sendMessage(message);
    }

    public void close(Status status, Metadata trailers) {
        if (status.getCause() != null) {
            this.observation.error(status.getCause());
        }
        Metadata trailersToKeep = new Metadata();
        trailersToKeep.merge(trailers);
        GrpcServerObservationContext context2 = (GrpcServerObservationContext)this.observation.getContext();
        context2.setStatusCode(status.getCode());
        context2.setTrailers(trailersToKeep);
        context2.setCancelled(this.isCancelled());
        super.close(status, trailers);
    }
}

