/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.cassandra.init.configuration;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.configuration2.Configuration;
import org.apache.james.util.Host;

public class ClusterConfiguration {
    private static final String CASSANDRA_NODES = "cassandra.nodes";
    public static final String CASSANDRA_CREATE_KEYSPACE = "cassandra.keyspace.create";
    public static final String CASSANDRA_USER = "cassandra.user";
    public static final String CASSANDRA_PASSWORD = "cassandra.password";
    public static final String CASSANDRA_LOCAL_DC = "cassandra.local.dc";
    public static final String CONNECTION_MAX_RETRY = "cassandra.retryConnection.maxRetries";
    public static final String CONNECTION_RETRY_MIN_DELAY = "cassandra.retryConnection.minDelay";
    private static final int DEFAULT_CONNECTION_MAX_RETRIES = 10;
    private static final int DEFAULT_CONNECTION_MIN_DELAY = 5000;
    public static final int DEFAULT_CASSANDRA_PORT = 9042;
    private final List<Host> hosts;
    private final Optional<String> localDC;
    private final boolean createKeyspace;
    private final int minDelay;
    private final int maxRetry;
    private final Optional<String> username;
    private final Optional<String> password;

    public static Builder builder() {
        return new Builder();
    }

    public static ClusterConfiguration from(Configuration configuration) {
        boolean createKeySpace = Optional.ofNullable(configuration.getBoolean(CASSANDRA_CREATE_KEYSPACE, null)).filter(Boolean::booleanValue).isPresent();
        Builder builder = ClusterConfiguration.builder().hosts(ClusterConfiguration.listCassandraServers(configuration)).localDC(Optional.ofNullable(configuration.getString(CASSANDRA_LOCAL_DC, null))).minDelay(Optional.ofNullable(configuration.getInteger(CONNECTION_RETRY_MIN_DELAY, null))).maxRetry(Optional.ofNullable(configuration.getInteger(CONNECTION_MAX_RETRY, null))).username(Optional.ofNullable(configuration.getString(CASSANDRA_USER, null))).password(Optional.ofNullable(configuration.getString(CASSANDRA_PASSWORD, null)));
        if (createKeySpace) {
            builder = builder.createKeyspace();
        }
        return builder.build();
    }

    private static List<Host> listCassandraServers(Configuration configuration) {
        String[] ipAndPorts = configuration.getStringArray(CASSANDRA_NODES);
        return (List)Arrays.stream(ipAndPorts).map(string -> Host.parseConfString((String)string, (int)9042)).collect(ImmutableList.toImmutableList());
    }

    private ClusterConfiguration(List<Host> hosts, Optional<String> localDC, boolean createKeyspace, int minDelay, int maxRetry, Optional<String> username, Optional<String> password) {
        this.hosts = hosts;
        this.localDC = localDC;
        this.createKeyspace = createKeyspace;
        this.minDelay = minDelay;
        this.maxRetry = maxRetry;
        this.username = username;
        this.password = password;
    }

    public Optional<String> getLocalDC() {
        return this.localDC;
    }

    public List<Host> getHosts() {
        return this.hosts;
    }

    public boolean shouldCreateKeyspace() {
        return this.createKeyspace;
    }

    public int getMinDelay() {
        return this.minDelay;
    }

    public int getMaxRetry() {
        return this.maxRetry;
    }

    public Optional<String> getUsername() {
        return this.username;
    }

    public Optional<String> getPassword() {
        return this.password;
    }

    public final boolean equals(Object o) {
        if (o instanceof ClusterConfiguration) {
            ClusterConfiguration that = (ClusterConfiguration)o;
            return Objects.equals(this.minDelay, that.minDelay) && Objects.equals(this.maxRetry, that.maxRetry) && Objects.equals(this.hosts, that.hosts) && Objects.equals(this.createKeyspace, that.createKeyspace) && Objects.equals(this.username, that.username) && Objects.equals(this.password, that.password);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.hosts, this.createKeyspace, this.minDelay, this.maxRetry, this.username, this.password);
    }

    public static class Builder {
        private ImmutableList.Builder<Host> hosts = ImmutableList.builder();
        private boolean createKeyspace = false;
        private Optional<Integer> minDelay = Optional.empty();
        private Optional<Integer> maxRetry = Optional.empty();
        private Optional<String> username = Optional.empty();
        private Optional<String> password = Optional.empty();
        private Optional<String> localDC = Optional.empty();

        public Builder host(Host host) {
            this.hosts.add((Object)host);
            return this;
        }

        public Builder hosts(Collection<Host> hosts) {
            this.hosts.addAll(hosts);
            return this;
        }

        public Builder hosts(Host ... hosts) {
            this.hosts.addAll(Arrays.asList(hosts));
            return this;
        }

        public Builder localDC(Optional<String> localDC) {
            this.localDC = localDC;
            return this;
        }

        public Builder localDC(String localDC) {
            this.localDC = Optional.of(localDC);
            return this;
        }

        public Builder createKeyspace() {
            this.createKeyspace = true;
            return this;
        }

        public Builder minDelay(Optional<Integer> minDelay) {
            this.minDelay = minDelay;
            return this;
        }

        public Builder minDelay(int minDelay) {
            return this.minDelay(Optional.of(minDelay));
        }

        public Builder maxRetry(Optional<Integer> maxRetry) {
            this.maxRetry = maxRetry;
            return this;
        }

        public Builder maxRetry(int maxRetry) {
            return this.maxRetry(Optional.of(maxRetry));
        }

        public Builder username(Optional<String> username) {
            this.username = username;
            return this;
        }

        public Builder username(String username) {
            return this.username(Optional.of(username));
        }

        public Builder password(Optional<String> password) {
            this.password = password;
            return this;
        }

        public Builder password(String password) {
            return this.password(Optional.of(password));
        }

        public ClusterConfiguration build() {
            return new ClusterConfiguration((List<Host>)this.hosts.build(), this.localDC, this.createKeyspace, this.minDelay.orElse(5000), this.maxRetry.orElse(10), this.username, this.password);
        }
    }
}

