/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.NodeRef;
import org.apache.iotdb.db.queryengine.plan.relational.planner.ExpressionExtractor;
import org.apache.iotdb.db.queryengine.plan.relational.planner.PlanNodeSearcher;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.Lookup;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.AggregationNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.WindowNode;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DefaultExpressionTraversalVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DefaultTraversalVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DereferenceExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Identifier;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.QualifiedName;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SubqueryExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SymbolReference;

public final class SymbolsExtractor {
    private SymbolsExtractor() {
    }

    public static Set<Symbol> extractUnique(PlanNode node) {
        ImmutableSet.Builder uniqueSymbols = ImmutableSet.builder();
        ExpressionExtractor.extractExpressions(node).forEach(expression -> uniqueSymbols.addAll(SymbolsExtractor.extractUnique(expression)));
        return uniqueSymbols.build();
    }

    public static Set<Symbol> extractUniqueNonRecursive(PlanNode node) {
        ImmutableSet.Builder uniqueSymbols = ImmutableSet.builder();
        ExpressionExtractor.extractExpressionsNonRecursive(node).forEach(expression -> uniqueSymbols.addAll(SymbolsExtractor.extractUnique(expression)));
        return uniqueSymbols.build();
    }

    public static Set<Symbol> extractUnique(PlanNode node, Lookup lookup) {
        ImmutableSet.Builder uniqueSymbols = ImmutableSet.builder();
        ExpressionExtractor.extractExpressions(node, lookup).forEach(expression -> uniqueSymbols.addAll(SymbolsExtractor.extractUnique(expression)));
        return uniqueSymbols.build();
    }

    public static Set<Symbol> extractUnique(Expression expression) {
        return ImmutableSet.copyOf(SymbolsExtractor.extractAll(expression));
    }

    public static Set<Symbol> extractUnique(Iterable<? extends Expression> expressions) {
        ImmutableSet.Builder unique = ImmutableSet.builder();
        for (Expression expression : expressions) {
            unique.addAll(SymbolsExtractor.extractAll(expression));
        }
        return unique.build();
    }

    public static Set<Symbol> extractUnique(AggregationNode.Aggregation aggregation) {
        return ImmutableSet.copyOf(SymbolsExtractor.extractAll(aggregation));
    }

    public static Set<Symbol> extractUnique(WindowNode.Function function) {
        return ImmutableSet.copyOf(SymbolsExtractor.extractAll(function));
    }

    public static List<Symbol> extractAll(Expression expression) {
        ImmutableList.Builder builder = ImmutableList.builder();
        new SymbolBuilderVisitor().process(expression, builder);
        return builder.build();
    }

    public static List<Symbol> extractAll(AggregationNode.Aggregation aggregation) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Expression argument : aggregation.getArguments()) {
            builder.addAll(SymbolsExtractor.extractAll(argument));
        }
        aggregation.getFilter().ifPresent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        aggregation.getOrderingScheme().ifPresent(orderBy -> builder.addAll(orderBy.getOrderBy()));
        aggregation.getMask().ifPresent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return builder.build();
    }

    public static List<Symbol> extractAll(WindowNode.Function function) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Expression argument : function.getArguments()) {
            builder.addAll(SymbolsExtractor.extractAll(argument));
        }
        function.getFrame().getEndValue().ifPresent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        function.getFrame().getSortKeyCoercedForFrameEndComparison().ifPresent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        function.getFrame().getStartValue().ifPresent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        function.getFrame().getSortKeyCoercedForFrameStartComparison().ifPresent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return builder.build();
    }

    public static Set<QualifiedName> extractNames(Expression expression, Set<NodeRef<Expression>> columnReferences) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        new QualifiedNameBuilderVisitor(columnReferences, true).process(expression, builder);
        return builder.build();
    }

    public static Set<QualifiedName> extractNamesNoSubqueries(Expression expression, Set<NodeRef<Expression>> columnReferences) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        new QualifiedNameBuilderVisitor(columnReferences, false).process(expression, builder);
        return builder.build();
    }

    public static Set<Symbol> extractOutputSymbols(PlanNode planNode) {
        return SymbolsExtractor.extractOutputSymbols(planNode, Lookup.noLookup());
    }

    public static Set<Symbol> extractOutputSymbols(PlanNode planNode, Lookup lookup) {
        return (Set)PlanNodeSearcher.searchFrom(planNode, lookup).findAll().stream().flatMap(node -> node.getOutputSymbols().stream()).collect(ImmutableSet.toImmutableSet());
    }

    private static class SymbolBuilderVisitor
    extends DefaultExpressionTraversalVisitor<ImmutableList.Builder<Symbol>> {
        private SymbolBuilderVisitor() {
        }

        @Override
        protected Void visitSymbolReference(SymbolReference node, ImmutableList.Builder<Symbol> builder) {
            builder.add((Object)Symbol.from(node));
            return null;
        }
    }

    private static class QualifiedNameBuilderVisitor
    extends DefaultTraversalVisitor<ImmutableSet.Builder<QualifiedName>> {
        private final Set<NodeRef<Expression>> columnReferences;
        private final boolean recurseIntoSubqueries;

        private QualifiedNameBuilderVisitor(Set<NodeRef<Expression>> columnReferences, boolean recurseIntoSubqueries) {
            this.columnReferences = Objects.requireNonNull(columnReferences, "columnReferences is null");
            this.recurseIntoSubqueries = recurseIntoSubqueries;
        }

        @Override
        protected Void visitDereferenceExpression(DereferenceExpression node, ImmutableSet.Builder<QualifiedName> builder) {
            if (this.columnReferences.contains(NodeRef.of(node))) {
                builder.add((Object)DereferenceExpression.getQualifiedName(node));
            } else {
                this.process(node.getBase(), builder);
            }
            return null;
        }

        @Override
        protected Void visitIdentifier(Identifier node, ImmutableSet.Builder<QualifiedName> builder) {
            builder.add((Object)QualifiedName.of(node.getValue()));
            return null;
        }

        @Override
        protected Void visitSubqueryExpression(SubqueryExpression node, ImmutableSet.Builder<QualifiedName> context) {
            if (!this.recurseIntoSubqueries) {
                return null;
            }
            return super.visitSubqueryExpression(node, context);
        }
    }
}

