/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.sink.client;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.db.pipe.resource.PipeDataNodeResourceManager;
import org.apache.iotdb.db.pipe.resource.memory.PipeMemoryBlock;
import org.apache.iotdb.db.pipe.resource.memory.PipeMemoryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface IoTDBDataNodeCacheLeaderClientManager {
    public static final LeaderCacheManager LEADER_CACHE_MANAGER = new LeaderCacheManager();

    public static class LeaderCacheManager {
        private static final Logger LOGGER = LoggerFactory.getLogger(LeaderCacheManager.class);
        private static final PipeConfig CONFIG = PipeConfig.getInstance();
        private final Cache<String, TEndPoint> device2endpoint;
        private final ConcurrentHashMap<TEndPoint, TEndPoint> endPoints = new ConcurrentHashMap();

        public LeaderCacheManager() {
            PipeDataNodeResourceManager.memory();
            long initMemorySizeInBytes = PipeMemoryManager.getTotalNonFloatingMemorySizeInBytes() / 10L;
            PipeMemoryBlock allocatedMemoryBlock = PipeDataNodeResourceManager.memory().tryAllocate(initMemorySizeInBytes);
            this.device2endpoint = Caffeine.newBuilder().maximumWeight(allocatedMemoryBlock.getMemoryUsageInBytes()).weigher((device, endPoint) -> device.getBytes().length).recordStats().build();
            allocatedMemoryBlock.setShrinkMethod(oldMemory -> Math.max(oldMemory / 2L, 1L)).setShrinkCallback((oldMemory, newMemory) -> {
                this.device2endpoint.policy().eviction().ifPresent(eviction -> eviction.setMaximum(newMemory.longValue()));
                LOGGER.info("LeaderCacheManager.allocatedMemoryBlock has shrunk from {} to {}.", oldMemory, newMemory);
            }).setExpandMethod(oldMemory -> {
                long l = Math.max(oldMemory, 1L) * 2L;
                PipeDataNodeResourceManager.memory();
                return Math.min(l, (long)((float)PipeMemoryManager.getTotalNonFloatingMemorySizeInBytes() * CONFIG.getPipeLeaderCacheMemoryUsagePercentage()));
            }).setExpandCallback((oldMemory, newMemory) -> {
                this.device2endpoint.policy().eviction().ifPresent(eviction -> eviction.setMaximum(newMemory.longValue()));
                LOGGER.info("LeaderCacheManager.allocatedMemoryBlock has expanded from {} to {}.", oldMemory, newMemory);
            });
        }

        public TEndPoint getLeaderEndPoint(String deviceId) {
            return deviceId == null ? null : (TEndPoint)this.device2endpoint.getIfPresent((Object)deviceId);
        }

        public void updateLeaderEndPoint(String deviceId, TEndPoint endPoint) {
            if (deviceId == null || endPoint == null) {
                return;
            }
            TEndPoint endPointFromMap = this.endPoints.putIfAbsent(endPoint, endPoint);
            if (endPointFromMap != null) {
                this.device2endpoint.put((Object)deviceId, (Object)endPointFromMap);
            } else {
                this.device2endpoint.put((Object)deviceId, (Object)endPoint);
            }
        }
    }
}

