/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.dist.worker;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.bifromq.util.TopicUtil;
import org.apache.bifromq.util.index.Branch;
import org.apache.bifromq.util.index.TopicLevelTrie;
import org.apache.bifromq.util.index.ValueStrategy;

public final class TopicIndex<V>
extends TopicLevelTrie<V> {
    private static final TopicLevelTrie.BranchSelector TopicMatcher = new TopicLevelTrie.BranchSelector(){

        public <T> Map<Branch<T>, TopicLevelTrie.BranchSelector.Action> selectBranch(Map<String, Branch<T>> branches, List<String> topicLevels, int currentLevel) {
            if (currentLevel < topicLevels.size() - 1) {
                String topicLevelToMatch = topicLevels.get(currentLevel);
                boolean matchParent = currentLevel + 1 == topicLevels.size() - 1 && topicLevels.get(currentLevel + 1).equals("#");
                switch (topicLevelToMatch) {
                    case "+": {
                        HashMap<Branch<T>, TopicLevelTrie.BranchSelector.Action> result = new HashMap<Branch<T>, TopicLevelTrie.BranchSelector.Action>();
                        for (Map.Entry<String, Branch<T>> entry : branches.entrySet()) {
                            Branch<T> branch = entry.getValue();
                            if (currentLevel == 0 && entry.getKey().startsWith("$")) continue;
                            result.put(branch, matchParent ? TopicLevelTrie.BranchSelector.Action.MATCH_AND_CONTINUE : TopicLevelTrie.BranchSelector.Action.CONTINUE);
                        }
                        return result;
                    }
                }
                assert (!topicLevelToMatch.equals("#")) : "MULTI_WILDCARD should be the last level";
                if (branches.containsKey(topicLevelToMatch)) {
                    return Map.of(branches.get(topicLevelToMatch), matchParent ? TopicLevelTrie.BranchSelector.Action.MATCH_AND_CONTINUE : TopicLevelTrie.BranchSelector.Action.CONTINUE);
                }
                return Collections.emptyMap();
            }
            if (currentLevel == topicLevels.size() - 1) {
                String topicLevelToMatch;
                switch (topicLevelToMatch = topicLevels.get(currentLevel)) {
                    case "+": {
                        HashMap<Branch<T>, TopicLevelTrie.BranchSelector.Action> result = new HashMap<Branch<T>, TopicLevelTrie.BranchSelector.Action>();
                        for (Map.Entry<String, Branch<T>> entry : branches.entrySet()) {
                            Branch<T> branch = entry.getValue();
                            if (currentLevel == 0 && entry.getKey().startsWith("$")) continue;
                            result.put(branch, TopicLevelTrie.BranchSelector.Action.MATCH_AND_STOP);
                        }
                        return result;
                    }
                    case "#": {
                        HashMap<Branch<T>, TopicLevelTrie.BranchSelector.Action> result = new HashMap<Branch<T>, TopicLevelTrie.BranchSelector.Action>();
                        for (Map.Entry<String, Branch<T>> entry : branches.entrySet()) {
                            Branch<T> branch = entry.getValue();
                            if (currentLevel == 0 && entry.getKey().startsWith("$")) continue;
                            result.put(branch, TopicLevelTrie.BranchSelector.Action.MATCH_AND_CONTINUE);
                        }
                        return result;
                    }
                }
                if (branches.containsKey(topicLevelToMatch)) {
                    return Map.of(branches.get(topicLevelToMatch), TopicLevelTrie.BranchSelector.Action.MATCH_AND_STOP);
                }
                return Collections.emptyMap();
            }
            HashMap<Branch<T>, TopicLevelTrie.BranchSelector.Action> result = new HashMap<Branch<T>, TopicLevelTrie.BranchSelector.Action>();
            for (Map.Entry<String, Branch<T>> entry : branches.entrySet()) {
                Branch<T> branch = entry.getValue();
                result.put(branch, TopicLevelTrie.BranchSelector.Action.MATCH_AND_CONTINUE);
            }
            return result;
        }
    };
    private static final TopicLevelTrie.BranchSelector TopicGetter = new TopicLevelTrie.BranchSelector(){

        public <T> Map<Branch<T>, TopicLevelTrie.BranchSelector.Action> selectBranch(Map<String, Branch<T>> branches, List<String> topicLevels, int currentLevel) {
            String topicLevelToMatch = topicLevels.get(currentLevel);
            if (branches.containsKey(topicLevelToMatch)) {
                return Map.of(branches.get(topicLevelToMatch), currentLevel < topicLevels.size() - 1 ? TopicLevelTrie.BranchSelector.Action.CONTINUE : TopicLevelTrie.BranchSelector.Action.MATCH_AND_STOP);
            }
            return Collections.emptyMap();
        }
    };

    public TopicIndex() {
        super(ValueStrategy.identity());
    }

    public void add(String topic, V value) {
        this.add(TopicUtil.parse((String)topic, (boolean)false), value);
    }

    public void remove(String topic, V value) {
        this.remove(TopicUtil.parse((String)topic, (boolean)false), value);
    }

    public Set<V> get(String topic) {
        return this.lookup(TopicUtil.parse((String)topic, (boolean)false), TopicGetter);
    }

    public Set<V> match(String topicFilter) {
        return this.match(TopicUtil.parse((String)topicFilter, (boolean)false));
    }

    public Set<V> match(List<String> topicFilterLevels) {
        return this.lookup(topicFilterLevels, TopicMatcher);
    }
}

