/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.baserpc.server;

import com.google.common.base.Preconditions;
import io.grpc.ServerServiceDefinition;
import io.netty.handler.ssl.SslContext;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import lombok.Generated;
import lombok.NonNull;
import org.apache.bifromq.baserpc.BluePrint;
import org.apache.bifromq.baserpc.server.IRPCServer;
import org.apache.bifromq.baserpc.server.RPCServer;
import org.apache.bifromq.baserpc.trafficgovernor.GlobalProcessId;
import org.apache.bifromq.baserpc.trafficgovernor.IRPCServiceTrafficService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RPCServerBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RPCServerBuilder.class);
    String id = GlobalProcessId.ID + "/" + this.hashCode();
    String host;
    int port = 0;
    int workerThreads = 0;
    IRPCServiceTrafficService trafficService;
    SslContext sslContext;
    final Map<String, ServiceDefinition> serviceDefinitions = new HashMap<String, ServiceDefinition>();

    public RPCServerBuilder sslContext(SslContext sslContext) {
        if (sslContext != null) {
            Preconditions.checkArgument((boolean)sslContext.isServer(), (Object)"Server auth must be enabled");
        }
        this.sslContext = sslContext;
        return this;
    }

    public RPCServerBuilder bindService(@NonNull ServerServiceDefinition serviceDefinition, @NonNull BluePrint bluePrint, @NonNull Map<String, String> attributes, @NonNull Set<String> defaultGroupTags, @NonNull Executor executor) {
        if (serviceDefinition == null) {
            throw new NullPointerException("serviceDefinition is marked non-null but is null");
        }
        if (bluePrint == null) {
            throw new NullPointerException("bluePrint is marked non-null but is null");
        }
        if (attributes == null) {
            throw new NullPointerException("attributes is marked non-null but is null");
        }
        if (defaultGroupTags == null) {
            throw new NullPointerException("defaultGroupTags is marked non-null but is null");
        }
        if (executor == null) {
            throw new NullPointerException("executor is marked non-null but is null");
        }
        this.serviceDefinitions.put(serviceDefinition.getServiceDescriptor().getName(), new ServiceDefinition(serviceDefinition, bluePrint, attributes, defaultGroupTags, executor));
        return this;
    }

    public IRPCServer build() {
        Preconditions.checkArgument((!this.serviceDefinitions.isEmpty() ? 1 : 0) != 0);
        return new RPCServer(this);
    }

    @Generated
    public RPCServerBuilder id(String id) {
        this.id = id;
        return this;
    }

    @Generated
    public RPCServerBuilder host(String host) {
        this.host = host;
        return this;
    }

    @Generated
    public RPCServerBuilder port(int port) {
        this.port = port;
        return this;
    }

    @Generated
    public RPCServerBuilder workerThreads(int workerThreads) {
        this.workerThreads = workerThreads;
        return this;
    }

    @Generated
    public RPCServerBuilder trafficService(IRPCServiceTrafficService trafficService) {
        this.trafficService = trafficService;
        return this;
    }

    @Generated
    RPCServerBuilder() {
    }

    @Generated
    public String id() {
        return this.id;
    }

    record ServiceDefinition(ServerServiceDefinition definition, BluePrint bluePrint, Map<String, String> attributes, Set<String> defaultGroupTags, Executor executor) {
    }
}

