/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basecrdt.store;

import com.google.protobuf.ByteString;
import io.reactivex.rxjava3.core.Observable;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import lombok.NonNull;
import org.apache.bifromq.basecrdt.core.api.ICRDTOperation;
import org.apache.bifromq.basecrdt.core.api.ICausalCRDT;
import org.apache.bifromq.basecrdt.proto.Replica;
import org.apache.bifromq.basecrdt.store.CRDTStore;
import org.apache.bifromq.basecrdt.store.CRDTStoreOptions;
import org.apache.bifromq.basecrdt.store.proto.CRDTStoreMessage;

public interface ICRDTStore {
    public static ICRDTStore newInstance(@NonNull CRDTStoreOptions options) {
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        return new CRDTStore(options);
    }

    public String id();

    public <O extends ICRDTOperation, T extends ICausalCRDT<O>> T host(Replica var1, ByteString var2);

    public CompletableFuture<Void> stopHosting(Replica var1);

    public void join(Replica var1, Set<ByteString> var2);

    public Observable<CRDTStoreMessage> storeMessages();

    public void start(Observable<CRDTStoreMessage> var1);

    public void stop();
}

