/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basecrdt.core.internal;

import com.google.protobuf.ByteString;
import org.apache.bifromq.basecrdt.core.api.DWFlagOperation;
import org.apache.bifromq.basecrdt.core.internal.CoalesceOperation;
import org.apache.bifromq.basecrdt.core.internal.ICoalesceOperation;
import org.apache.bifromq.basecrdt.core.internal.IDotSet;
import org.apache.bifromq.basecrdt.core.internal.ProtoUtils;
import org.apache.bifromq.basecrdt.proto.Replacement;

class DWFlagCoalesceOperation
extends CoalesceOperation<IDotSet, DWFlagOperation> {
    DWFlagOperation op;

    DWFlagCoalesceOperation(ByteString replicaId, DWFlagOperation op) {
        super(replicaId);
        this.coalesce(op);
    }

    @Override
    public void coalesce(DWFlagOperation op) {
        this.op = op;
    }

    @Override
    public Iterable<Replacement> delta(IDotSet current, ICoalesceOperation.IEventGenerator eventGenerator) {
        long ver = eventGenerator.nextEvent();
        switch (this.op.type) {
            case Disable: {
                return ProtoUtils.replacements(ProtoUtils.dot(this.replicaId, ver, ProtoUtils.singleDot(this.replicaId, ver)), current);
            }
        }
        return ProtoUtils.replacements(ProtoUtils.dot(this.replicaId, ver), current);
    }
}

