/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basescheduler;

import com.google.common.base.Preconditions;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

class EMALong {
    private static final double NANOS_PER_SECOND = 1.0E9;
    private final Supplier<Long> nowSupplier;
    private final double alpha;
    private final double decay;
    private final long decayDelayNanos;
    private final AtomicReference<State> state;

    public EMALong(Supplier<Long> nowSupplier, double alpha, double decay, long decayDelayNanos) {
        Preconditions.checkArgument((alpha > 0.0 && alpha <= 1.0 ? 1 : 0) != 0, (Object)"alpha must be in (0,1]");
        Preconditions.checkArgument((decay > 0.0 && decay <= 1.0 ? 1 : 0) != 0, (Object)"decay must be in (0,1]");
        Preconditions.checkArgument((decayDelayNanos >= 0L ? 1 : 0) != 0, (Object)"decayDelayNanos must be non-negative");
        this.nowSupplier = nowSupplier;
        this.alpha = alpha;
        this.decay = decay;
        this.decayDelayNanos = decayDelayNanos;
        this.state = new AtomicReference<State>(new State(0L, 0L));
    }

    public void update(long newValue) {
        long newEma;
        State next;
        State prev;
        long now = this.nowSupplier.get();
        while (!this.state.compareAndSet(prev = this.state.get(), next = new State(newEma = prev.ema == 0L ? newValue : (long)Math.ceil((double)prev.ema * (1.0 - this.alpha) + (double)newValue * this.alpha), now))) {
        }
    }

    public long get() {
        long dt;
        long now = this.nowSupplier.get();
        State s = this.state.get();
        if (s.ema == 0L || s.lastTs == 0L) {
            return s.ema;
        }
        if (this.decayDelayNanos < Long.MAX_VALUE && (dt = now - s.lastTs) > this.decayDelayNanos) {
            double seconds = Math.ceil((double)(dt - this.decayDelayNanos) / 1.0E9);
            double decayed = (double)s.ema * Math.pow(this.decay, seconds);
            return decayed < 1.0 ? 0L : Math.round(decayed);
        }
        return s.ema;
    }

    private record State(long ema, long lastTs) {
    }
}

