/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageDataIdentifier;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageResource;

public class TieredStorageResourceRegistry {
    private final Map<TieredStorageDataIdentifier, List<TieredStorageResource>> registeredResources = new HashMap<TieredStorageDataIdentifier, List<TieredStorageResource>>();

    public void registerResource(TieredStorageDataIdentifier owner, TieredStorageResource tieredStorageResource) {
        this.registeredResources.computeIfAbsent(owner, ignore -> new ArrayList()).add(tieredStorageResource);
    }

    public void clearResourceFor(TieredStorageDataIdentifier owner) {
        List<TieredStorageResource> cleanersForOwner = this.registeredResources.remove(owner);
        if (cleanersForOwner != null) {
            cleanersForOwner.forEach(TieredStorageResource::release);
        }
    }
}

