/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.orabulkloader;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.DbCache;
import org.apache.hop.core.SourceToTargetMapping;
import org.apache.hop.core.SqlStatement;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.orabulkloader.OraBulkLoaderMappingMeta;
import org.apache.hop.pipeline.transforms.orabulkloader.OraBulkLoaderMeta;
import org.apache.hop.ui.core.ConstUi;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.database.dialog.DatabaseExplorerDialog;
import org.apache.hop.ui.core.database.dialog.SqlEditor;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterMappingDialog;
import org.apache.hop.ui.core.dialog.EnterSelectionDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.MetaSelectionLine;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.pipeline.transform.ITableItemInsertListener;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class OraBulkLoaderDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = OraBulkLoaderDialog.class;
    public static final String CONST_ORA_BULK_LOADER_DIALOG_DATE_MASK_LABEL = "OraBulkLoaderDialog.DateMask.Label";
    public static final String CONST_ORA_BULK_LOADER_DIALOG_DATE_TIME_MASK_LABEL = "OraBulkLoaderDialog.DateTimeMask.Label";
    public static final String CONST_ORA_BULK_LOADER_DIALOG_BROWSE_BUTTON = "OraBulkLoaderDialog.Browse.Button";
    private MetaSelectionLine<DatabaseMeta> wConnection;
    private TextVar wSchema;
    private TextVar wTable;
    private TextVar wSqlldr;
    private CCombo wLoadMethod;
    private CCombo wLoadAction;
    private TextVar wMaxErrors;
    private TextVar wCommit;
    private TextVar wBindSize;
    private TextVar wReadSize;
    private TableView wReturn;
    private TextVar wControlFile;
    private TextVar wDataFile;
    private TextVar wLogFile;
    private TextVar wBadFile;
    private TextVar wDiscardFile;
    private Combo wEncoding;
    private Combo wCharacterSetName;
    private Button wDirectPath;
    private Button wEraseFiles;
    private Button wFailOnWarning;
    private Button wFailOnError;
    private Button wParallel;
    private TextVar wAltRecordTerm;
    private OraBulkLoaderMeta input;
    private final List<String> inputFields = new ArrayList<String>();
    private ColumnInfo[] ciReturn;
    private List<ColumnInfo> tableFieldColumns = new ArrayList<ColumnInfo>();
    private static String[] encodings = new String[]{"", "US-ASCII", "ISO-8859-1", "UTF-8", "UTF-16BE", "UTF-16LE", "UTF-16"};
    private static String[] characterSetNames = new String[]{"", "US7ASCII", "WE8ISO8859P1", "UTF8"};
    private static final String[] ALL_FILETYPES = new String[]{BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.Filetype.All", (String[])new String[0])};

    public OraBulkLoaderDialog(Shell parent, IVariables variables, OraBulkLoaderMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.input = transformMeta;
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.shell.setText(BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.Shell.Title", (String[])new String[0]));
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        ModifyListener lsTableMod = arg0 -> {
            this.input.setChanged();
            this.setTableFieldCombo();
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"System.TransformName.Label", (String[])new String[0]));
        this.wlTransformName.setToolTipText(BaseMessages.getString(PKG, (String)"System.TransformName.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        FormData fdlTransformName = new FormData();
        fdlTransformName.left = new FormAttachment(0, 0);
        fdlTransformName.right = new FormAttachment(middle, -margin);
        fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        FormData fdTransformName = new FormData();
        fdTransformName.left = new FormAttachment(middle, 0);
        fdTransformName.top = new FormAttachment(0, margin);
        fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)fdTransformName);
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wSql = new Button((Composite)this.shell, 8);
        this.wSql.setText(BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.SQL.Button", (String[])new String[0]));
        this.wSql.addListener(13, e -> this.create());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel, this.wSql}, margin, null);
        CTabFolder wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        PropsUi.setLook((Widget)wTabFolder, (int)4);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wTransformName, margin);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        wTabFolder.setLayoutData((Object)fdTabFolder);
        CTabItem wBulkLoaderTab = new CTabItem(wTabFolder, 0);
        wBulkLoaderTab.setText(BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.BulkLoader.Label", (String[])new String[0]));
        Composite wBulkLoaderComposite = new Composite((Composite)wTabFolder, 0);
        FormLayout fdBulkLoaderLayout = new FormLayout();
        fdBulkLoaderLayout.marginWidth = 3;
        fdBulkLoaderLayout.marginHeight = 3;
        wBulkLoaderComposite.setLayout((Layout)fdBulkLoaderLayout);
        PropsUi.setLook((Widget)wBulkLoaderComposite);
        FormData fdComp = new FormData();
        fdComp.left = new FormAttachment(0, 0);
        fdComp.top = new FormAttachment(0, 0);
        fdComp.right = new FormAttachment(100, 0);
        fdComp.bottom = new FormAttachment(100, 0);
        wBulkLoaderComposite.setLayoutData((Object)fdComp);
        SelectionAdapter lsSelection = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OraBulkLoaderDialog.this.input.setChanged();
                OraBulkLoaderDialog.this.setTableFieldCombo();
            }
        };
        this.wConnection = this.addConnectionLine(wBulkLoaderComposite, (Control)this.wTransformName, this.input.getConnection(), lsMod);
        this.wConnection.addSelectionListener((SelectionListener)lsSelection);
        Label wlSchema = new Label(wBulkLoaderComposite, 131072);
        wlSchema.setText(BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.TargetSchema.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlSchema);
        FormData fdlSchema = new FormData();
        fdlSchema.left = new FormAttachment(0, 0);
        fdlSchema.right = new FormAttachment(middle, -margin);
        fdlSchema.top = new FormAttachment(this.wConnection, margin * 2);
        wlSchema.setLayoutData((Object)fdlSchema);
        Button wbSchema = new Button(wBulkLoaderComposite, 0x1000008);
        PropsUi.setLook((Widget)wbSchema);
        wbSchema.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        wbSchema.addListener(13, e -> this.getSchemaNames());
        FormData fdbSchema = new FormData();
        fdbSchema.top = new FormAttachment(this.wConnection, 2 * margin);
        fdbSchema.right = new FormAttachment(100, 0);
        wbSchema.setLayoutData((Object)fdbSchema);
        this.wSchema = new TextVar(this.variables, wBulkLoaderComposite, 18436);
        PropsUi.setLook((Widget)this.wSchema);
        this.wSchema.addModifyListener(lsTableMod);
        FormData fdSchema = new FormData();
        fdSchema.left = new FormAttachment(middle, 0);
        fdSchema.top = new FormAttachment(this.wConnection, margin * 2);
        fdSchema.right = new FormAttachment((Control)wbSchema, -margin);
        this.wSchema.setLayoutData((Object)fdSchema);
        Label wlTable = new Label(wBulkLoaderComposite, 131072);
        wlTable.setText(BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.TargetTable.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlTable);
        FormData fdlTable = new FormData();
        fdlTable.left = new FormAttachment(0, 0);
        fdlTable.right = new FormAttachment(middle, -margin);
        fdlTable.top = new FormAttachment((Control)wbSchema, margin);
        wlTable.setLayoutData((Object)fdlTable);
        Button wbTable = new Button(wBulkLoaderComposite, 0x1000008);
        PropsUi.setLook((Widget)wbTable);
        wbTable.setText(BaseMessages.getString(PKG, (String)CONST_ORA_BULK_LOADER_DIALOG_BROWSE_BUTTON, (String[])new String[0]));
        wbTable.addListener(13, e -> this.getTableName());
        FormData fdbTable = new FormData();
        fdbTable.right = new FormAttachment(100, 0);
        fdbTable.top = new FormAttachment((Control)wbSchema, margin);
        wbTable.setLayoutData((Object)fdbTable);
        this.wTable = new TextVar(this.variables, wBulkLoaderComposite, 18436);
        PropsUi.setLook((Widget)this.wTable);
        this.wTable.addModifyListener(lsTableMod);
        FormData fdTable = new FormData();
        fdTable.left = new FormAttachment(middle, 0);
        fdTable.top = new FormAttachment((Control)wbSchema, margin);
        fdTable.right = new FormAttachment((Control)wbTable, -margin);
        this.wTable.setLayoutData((Object)fdTable);
        Label wlSqlldr = new Label(wBulkLoaderComposite, 131072);
        wlSqlldr.setText(BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.Sqlldr.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlSqlldr);
        FormData fdlSqlldr = new FormData();
        fdlSqlldr.left = new FormAttachment(0, 0);
        fdlSqlldr.right = new FormAttachment(middle, -margin);
        fdlSqlldr.top = new FormAttachment((Control)this.wTable, margin);
        wlSqlldr.setLayoutData((Object)fdlSqlldr);
        Button wbSqlldr = new Button(wBulkLoaderComposite, 0x1000008);
        PropsUi.setLook((Widget)wbSqlldr);
        wbSqlldr.setText(BaseMessages.getString(PKG, (String)CONST_ORA_BULK_LOADER_DIALOG_BROWSE_BUTTON, (String[])new String[0]));
        FormData fdbSqlldr = new FormData();
        fdbSqlldr.right = new FormAttachment(100, 0);
        fdbSqlldr.top = new FormAttachment((Control)this.wTable, margin);
        wbSqlldr.setLayoutData((Object)fdbSqlldr);
        this.wSqlldr = new TextVar(this.variables, wBulkLoaderComposite, 18436);
        PropsUi.setLook((Widget)this.wSqlldr);
        this.wSqlldr.addModifyListener(lsMod);
        FormData fdSqlldr = new FormData();
        fdSqlldr.left = new FormAttachment(middle, 0);
        fdSqlldr.top = new FormAttachment((Control)this.wTable, margin);
        fdSqlldr.right = new FormAttachment((Control)wbSqlldr, -margin);
        this.wSqlldr.setLayoutData((Object)fdSqlldr);
        Label wlLoadMethod = new Label(wBulkLoaderComposite, 131072);
        wlLoadMethod.setText(BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.LoadMethod.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlLoadMethod);
        FormData fdlLoadMethod = new FormData();
        fdlLoadMethod.left = new FormAttachment(0, 0);
        fdlLoadMethod.right = new FormAttachment(middle, -margin);
        fdlLoadMethod.top = new FormAttachment((Control)this.wSqlldr, margin);
        wlLoadMethod.setLayoutData((Object)fdlLoadMethod);
        this.wLoadMethod = new CCombo(wBulkLoaderComposite, 2060);
        this.wLoadMethod.add(BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.AutoEndLoadMethod.Label", (String[])new String[0]));
        this.wLoadMethod.add(BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.ManualLoadMethod.Label", (String[])new String[0]));
        this.wLoadMethod.add(BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.AutoConcLoadMethod.Label", (String[])new String[0]));
        this.wLoadMethod.select(0);
        this.wLoadMethod.addModifyListener(lsMod);
        PropsUi.setLook((Widget)this.wLoadMethod);
        FormData fdLoadMethod = new FormData();
        fdLoadMethod.left = new FormAttachment(middle, 0);
        fdLoadMethod.top = new FormAttachment((Control)this.wSqlldr, margin);
        fdLoadMethod.right = new FormAttachment(100, 0);
        this.wLoadMethod.setLayoutData((Object)fdLoadMethod);
        fdLoadMethod = new FormData();
        fdLoadMethod.left = new FormAttachment(middle, 0);
        fdLoadMethod.top = new FormAttachment((Control)this.wSqlldr, margin);
        fdLoadMethod.right = new FormAttachment(100, 0);
        this.wLoadMethod.setLayoutData((Object)fdLoadMethod);
        Label wlLoadAction = new Label(wBulkLoaderComposite, 131072);
        wlLoadAction.setText(BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.LoadAction.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlLoadAction);
        FormData fdlLoadAction = new FormData();
        fdlLoadAction.left = new FormAttachment(0, 0);
        fdlLoadAction.right = new FormAttachment(middle, -margin);
        fdlLoadAction.top = new FormAttachment((Control)this.wLoadMethod, margin);
        wlLoadAction.setLayoutData((Object)fdlLoadAction);
        this.wLoadAction = new CCombo(wBulkLoaderComposite, 2060);
        this.wLoadAction.add(BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.AppendLoadAction.Label", (String[])new String[0]));
        this.wLoadAction.add(BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.InsertLoadAction.Label", (String[])new String[0]));
        this.wLoadAction.add(BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.ReplaceLoadAction.Label", (String[])new String[0]));
        this.wLoadAction.add(BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.TruncateLoadAction.Label", (String[])new String[0]));
        this.wLoadAction.select(0);
        this.wLoadAction.addModifyListener(lsMod);
        PropsUi.setLook((Widget)this.wLoadAction);
        FormData fdLoadAction = new FormData();
        fdLoadAction.left = new FormAttachment(middle, 0);
        fdLoadAction.top = new FormAttachment((Control)this.wLoadMethod, margin);
        fdLoadAction.right = new FormAttachment(100, 0);
        this.wLoadAction.setLayoutData((Object)fdLoadAction);
        Label wlMaxErrors = new Label(wBulkLoaderComposite, 131072);
        wlMaxErrors.setText(BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.MaxErrors.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlMaxErrors);
        FormData fdlMaxErrors = new FormData();
        fdlMaxErrors.left = new FormAttachment(0, 0);
        fdlMaxErrors.top = new FormAttachment((Control)this.wLoadAction, margin);
        fdlMaxErrors.right = new FormAttachment(middle, -margin);
        wlMaxErrors.setLayoutData((Object)fdlMaxErrors);
        this.wMaxErrors = new TextVar(this.variables, wBulkLoaderComposite, 18436);
        PropsUi.setLook((Widget)this.wMaxErrors);
        this.wMaxErrors.addModifyListener(lsMod);
        FormData fdMaxErrors = new FormData();
        fdMaxErrors.left = new FormAttachment(middle, 0);
        fdMaxErrors.top = new FormAttachment((Control)this.wLoadAction, margin);
        fdMaxErrors.right = new FormAttachment(100, 0);
        this.wMaxErrors.setLayoutData((Object)fdMaxErrors);
        Label wlCommit = new Label(wBulkLoaderComposite, 131072);
        wlCommit.setText(BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.Commit.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlCommit);
        FormData fdlCommit = new FormData();
        fdlCommit.left = new FormAttachment(0, 0);
        fdlCommit.top = new FormAttachment((Control)this.wMaxErrors, margin);
        fdlCommit.right = new FormAttachment(middle, -margin);
        wlCommit.setLayoutData((Object)fdlCommit);
        this.wCommit = new TextVar(this.variables, wBulkLoaderComposite, 18436);
        PropsUi.setLook((Widget)this.wCommit);
        this.wCommit.addModifyListener(lsMod);
        FormData fdCommit = new FormData();
        fdCommit.left = new FormAttachment(middle, 0);
        fdCommit.top = new FormAttachment((Control)this.wMaxErrors, margin);
        fdCommit.right = new FormAttachment(100, 0);
        this.wCommit.setLayoutData((Object)fdCommit);
        Label wlBindSize = new Label(wBulkLoaderComposite, 131072);
        wlBindSize.setText(BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.BindSize.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlBindSize);
        FormData fdlBindSize = new FormData();
        fdlBindSize.left = new FormAttachment(0, 0);
        fdlBindSize.top = new FormAttachment((Control)this.wCommit, margin);
        fdlBindSize.right = new FormAttachment(middle, -margin);
        wlBindSize.setLayoutData((Object)fdlBindSize);
        this.wBindSize = new TextVar(this.variables, wBulkLoaderComposite, 18436);
        PropsUi.setLook((Widget)this.wBindSize);
        this.wBindSize.addModifyListener(lsMod);
        FormData fdBindSize = new FormData();
        fdBindSize.left = new FormAttachment(middle, 0);
        fdBindSize.top = new FormAttachment((Control)this.wCommit, margin);
        fdBindSize.right = new FormAttachment(100, 0);
        this.wBindSize.setLayoutData((Object)fdBindSize);
        Label wlReadSize = new Label(wBulkLoaderComposite, 131072);
        wlReadSize.setText(BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.ReadSize.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlReadSize);
        FormData fdlReadSize = new FormData();
        fdlReadSize.left = new FormAttachment(0, 0);
        fdlReadSize.top = new FormAttachment((Control)this.wBindSize, margin);
        fdlReadSize.right = new FormAttachment(middle, -margin);
        wlReadSize.setLayoutData((Object)fdlReadSize);
        this.wReadSize = new TextVar(this.variables, wBulkLoaderComposite, 18436);
        PropsUi.setLook((Widget)this.wReadSize);
        this.wReadSize.addModifyListener(lsMod);
        FormData fdReadSize = new FormData();
        fdReadSize.left = new FormAttachment(middle, 0);
        fdReadSize.top = new FormAttachment((Control)this.wBindSize, margin);
        fdReadSize.right = new FormAttachment(100, 0);
        this.wReadSize.setLayoutData((Object)fdReadSize);
        Label wlControlFile = new Label(wBulkLoaderComposite, 131072);
        wlControlFile.setText(BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.ControlFile.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlControlFile);
        FormData fdlControlFile = new FormData();
        fdlControlFile.left = new FormAttachment(0, 0);
        fdlControlFile.top = new FormAttachment((Control)this.wReadSize, margin);
        fdlControlFile.right = new FormAttachment(middle, -margin);
        wlControlFile.setLayoutData((Object)fdlControlFile);
        Button wbControlFile = new Button(wBulkLoaderComposite, 0x1000008);
        PropsUi.setLook((Widget)wbControlFile);
        wbControlFile.setText(BaseMessages.getString(PKG, (String)CONST_ORA_BULK_LOADER_DIALOG_BROWSE_BUTTON, (String[])new String[0]));
        FormData fdbControlFile = new FormData();
        fdbControlFile.right = new FormAttachment(100, 0);
        fdbControlFile.top = new FormAttachment((Control)this.wReadSize, margin);
        wbControlFile.setLayoutData((Object)fdbControlFile);
        this.wControlFile = new TextVar(this.variables, wBulkLoaderComposite, 18436);
        PropsUi.setLook((Widget)this.wControlFile);
        this.wControlFile.addModifyListener(lsMod);
        FormData fdControlFile = new FormData();
        fdControlFile.left = new FormAttachment(middle, 0);
        fdControlFile.top = new FormAttachment((Control)this.wReadSize, margin);
        fdControlFile.right = new FormAttachment((Control)wbControlFile, -margin);
        this.wControlFile.setLayoutData((Object)fdControlFile);
        Label wlDataFile = new Label(wBulkLoaderComposite, 131072);
        wlDataFile.setText(BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.DataFile.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlDataFile);
        FormData fdlDataFile = new FormData();
        fdlDataFile.left = new FormAttachment(0, 0);
        fdlDataFile.top = new FormAttachment((Control)this.wControlFile, margin);
        fdlDataFile.right = new FormAttachment(middle, -margin);
        wlDataFile.setLayoutData((Object)fdlDataFile);
        Button wbDataFile = new Button(wBulkLoaderComposite, 0x1000008);
        PropsUi.setLook((Widget)wbDataFile);
        wbDataFile.setText(BaseMessages.getString(PKG, (String)CONST_ORA_BULK_LOADER_DIALOG_BROWSE_BUTTON, (String[])new String[0]));
        FormData fdbDataFile = new FormData();
        fdbDataFile.right = new FormAttachment(100, 0);
        fdbDataFile.top = new FormAttachment((Control)this.wControlFile, margin);
        wbDataFile.setLayoutData((Object)fdbDataFile);
        this.wDataFile = new TextVar(this.variables, wBulkLoaderComposite, 18436);
        PropsUi.setLook((Widget)this.wDataFile);
        this.wDataFile.addModifyListener(lsMod);
        FormData fdDataFile = new FormData();
        fdDataFile.left = new FormAttachment(middle, 0);
        fdDataFile.top = new FormAttachment((Control)this.wControlFile, margin);
        fdDataFile.right = new FormAttachment((Control)wbDataFile, -margin);
        this.wDataFile.setLayoutData((Object)fdDataFile);
        Label wlLogFile = new Label(wBulkLoaderComposite, 131072);
        wlLogFile.setText(BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.LogFile.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlLogFile);
        FormData fdlLogFile = new FormData();
        fdlLogFile.left = new FormAttachment(0, 0);
        fdlLogFile.top = new FormAttachment((Control)this.wDataFile, margin);
        fdlLogFile.right = new FormAttachment(middle, -margin);
        wlLogFile.setLayoutData((Object)fdlLogFile);
        Button wbLogFile = new Button(wBulkLoaderComposite, 0x1000008);
        PropsUi.setLook((Widget)wbLogFile);
        wbLogFile.setText(BaseMessages.getString(PKG, (String)CONST_ORA_BULK_LOADER_DIALOG_BROWSE_BUTTON, (String[])new String[0]));
        FormData fdbLogFile = new FormData();
        fdbLogFile.right = new FormAttachment(100, 0);
        fdbLogFile.top = new FormAttachment((Control)this.wDataFile, margin);
        wbLogFile.setLayoutData((Object)fdbLogFile);
        this.wLogFile = new TextVar(this.variables, wBulkLoaderComposite, 18436);
        PropsUi.setLook((Widget)this.wLogFile);
        this.wLogFile.addModifyListener(lsMod);
        FormData fdLogFile = new FormData();
        fdLogFile.left = new FormAttachment(middle, 0);
        fdLogFile.top = new FormAttachment((Control)this.wDataFile, margin);
        fdLogFile.right = new FormAttachment((Control)wbLogFile, -margin);
        this.wLogFile.setLayoutData((Object)fdLogFile);
        Label wlBadFile = new Label(wBulkLoaderComposite, 131072);
        wlBadFile.setText(BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.BadFile.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlBadFile);
        FormData fdlBadFile = new FormData();
        fdlBadFile.left = new FormAttachment(0, 0);
        fdlBadFile.top = new FormAttachment((Control)this.wLogFile, margin);
        fdlBadFile.right = new FormAttachment(middle, -margin);
        wlBadFile.setLayoutData((Object)fdlBadFile);
        Button wbBadFile = new Button(wBulkLoaderComposite, 0x1000008);
        PropsUi.setLook((Widget)wbBadFile);
        wbBadFile.setText(BaseMessages.getString(PKG, (String)CONST_ORA_BULK_LOADER_DIALOG_BROWSE_BUTTON, (String[])new String[0]));
        FormData fdbBadFile = new FormData();
        fdbBadFile.right = new FormAttachment(100, 0);
        fdbBadFile.top = new FormAttachment((Control)this.wLogFile, margin);
        wbBadFile.setLayoutData((Object)fdbBadFile);
        this.wBadFile = new TextVar(this.variables, wBulkLoaderComposite, 18436);
        PropsUi.setLook((Widget)this.wBadFile);
        this.wBadFile.addModifyListener(lsMod);
        FormData fdBadFile = new FormData();
        fdBadFile.left = new FormAttachment(middle, 0);
        fdBadFile.top = new FormAttachment((Control)this.wLogFile, margin);
        fdBadFile.right = new FormAttachment((Control)wbBadFile, -margin);
        this.wBadFile.setLayoutData((Object)fdBadFile);
        Label wlDiscardFile = new Label(wBulkLoaderComposite, 131072);
        wlDiscardFile.setText(BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.DiscardFile.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlDiscardFile);
        FormData fdlDiscardFile = new FormData();
        fdlDiscardFile.left = new FormAttachment(0, 0);
        fdlDiscardFile.top = new FormAttachment((Control)this.wBadFile, margin);
        fdlDiscardFile.right = new FormAttachment(middle, -margin);
        wlDiscardFile.setLayoutData((Object)fdlDiscardFile);
        Button wbDiscardFile = new Button(wBulkLoaderComposite, 0x1000008);
        PropsUi.setLook((Widget)wbDiscardFile);
        wbDiscardFile.setText(BaseMessages.getString(PKG, (String)CONST_ORA_BULK_LOADER_DIALOG_BROWSE_BUTTON, (String[])new String[0]));
        FormData fdbDiscardFile = new FormData();
        fdbDiscardFile.right = new FormAttachment(100, 0);
        fdbDiscardFile.top = new FormAttachment((Control)this.wBadFile, margin);
        wbDiscardFile.setLayoutData((Object)fdbDiscardFile);
        this.wDiscardFile = new TextVar(this.variables, wBulkLoaderComposite, 18436);
        PropsUi.setLook((Widget)this.wDiscardFile);
        this.wDiscardFile.addModifyListener(lsMod);
        FormData fdDiscardFile = new FormData();
        fdDiscardFile.left = new FormAttachment(middle, 0);
        fdDiscardFile.top = new FormAttachment((Control)this.wBadFile, margin);
        fdDiscardFile.right = new FormAttachment((Control)wbDiscardFile, -margin);
        this.wDiscardFile.setLayoutData((Object)fdDiscardFile);
        Label wlEncoding = new Label(wBulkLoaderComposite, 131072);
        wlEncoding.setText(BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.Encoding.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlEncoding);
        FormData fdlEncoding = new FormData();
        fdlEncoding.left = new FormAttachment(0, 0);
        fdlEncoding.top = new FormAttachment((Control)this.wDiscardFile, margin);
        fdlEncoding.right = new FormAttachment(middle, -margin);
        wlEncoding.setLayoutData((Object)fdlEncoding);
        this.wEncoding = new Combo(wBulkLoaderComposite, 18436);
        this.wEncoding.setToolTipText(BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.Encoding.Tooltip", (String[])new String[0]));
        this.wEncoding.setItems(encodings);
        PropsUi.setLook((Widget)this.wEncoding);
        FormData fdEncoding = new FormData();
        fdEncoding.left = new FormAttachment(middle, 0);
        fdEncoding.top = new FormAttachment((Control)this.wDiscardFile, margin);
        fdEncoding.right = new FormAttachment(100, 0);
        this.wEncoding.setLayoutData((Object)fdEncoding);
        this.wEncoding.addModifyListener(lsMod);
        Label wlCharacterSetName = new Label(wBulkLoaderComposite, 131072);
        wlCharacterSetName.setText(BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.CharacterSetName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlCharacterSetName);
        FormData fdlCharacterSetName = new FormData();
        fdlCharacterSetName.left = new FormAttachment(0, 0);
        fdlCharacterSetName.top = new FormAttachment((Control)this.wEncoding, margin);
        fdlCharacterSetName.right = new FormAttachment(middle, -margin);
        wlCharacterSetName.setLayoutData((Object)fdlCharacterSetName);
        this.wCharacterSetName = new Combo(wBulkLoaderComposite, 18436);
        this.wCharacterSetName.setToolTipText(BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.CharacterSetName.Tooltip", (String[])new String[0]));
        this.wCharacterSetName.setItems(characterSetNames);
        PropsUi.setLook((Widget)this.wCharacterSetName);
        FormData fdCharacterSetName = new FormData();
        fdCharacterSetName.left = new FormAttachment(middle, 0);
        fdCharacterSetName.top = new FormAttachment((Control)this.wEncoding, margin);
        fdCharacterSetName.right = new FormAttachment(100, 0);
        this.wCharacterSetName.setLayoutData((Object)fdCharacterSetName);
        this.wCharacterSetName.addModifyListener(lsMod);
        Label wlAltRecordTerm = new Label(wBulkLoaderComposite, 131072);
        wlAltRecordTerm.setText(BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.AltRecordTerm.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlAltRecordTerm);
        FormData fdlAltRecordTerm = new FormData();
        fdlAltRecordTerm.left = new FormAttachment(0, 0);
        fdlAltRecordTerm.top = new FormAttachment((Control)this.wCharacterSetName, margin);
        fdlAltRecordTerm.right = new FormAttachment(middle, -margin);
        wlAltRecordTerm.setLayoutData((Object)fdlAltRecordTerm);
        this.wAltRecordTerm = new TextVar(this.variables, wBulkLoaderComposite, 18436);
        PropsUi.setLook((Widget)this.wAltRecordTerm);
        FormData fdAltRecordTerm = new FormData();
        fdAltRecordTerm.left = new FormAttachment(middle, 0);
        fdAltRecordTerm.top = new FormAttachment((Control)this.wCharacterSetName, margin);
        fdAltRecordTerm.right = new FormAttachment(100, 0);
        this.wAltRecordTerm.setLayoutData((Object)fdAltRecordTerm);
        this.wAltRecordTerm.addModifyListener(lsMod);
        Label wlDirectPath = new Label(wBulkLoaderComposite, 131072);
        wlDirectPath.setText(BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.DirectPath.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlDirectPath);
        FormData fdlDirectPath = new FormData();
        fdlDirectPath.left = new FormAttachment(0, 0);
        fdlDirectPath.top = new FormAttachment((Control)this.wAltRecordTerm, margin);
        fdlDirectPath.right = new FormAttachment(middle, -margin);
        wlDirectPath.setLayoutData((Object)fdlDirectPath);
        this.wDirectPath = new Button(wBulkLoaderComposite, 32);
        PropsUi.setLook((Widget)this.wDirectPath);
        FormData fdDirectPath = new FormData();
        fdDirectPath.left = new FormAttachment(middle, 0);
        fdDirectPath.top = new FormAttachment((Control)this.wAltRecordTerm, margin);
        fdDirectPath.right = new FormAttachment(100, 0);
        this.wDirectPath.setLayoutData((Object)fdDirectPath);
        this.wDirectPath.addListener(13, e -> {
            this.input.setChanged();
            if (!this.wDirectPath.getSelection()) {
                this.wParallel.setSelection(false);
            }
            this.wParallel.setEnabled(this.wDirectPath.getSelection());
        });
        Label wlEraseFiles = new Label(wBulkLoaderComposite, 131072);
        wlEraseFiles.setText(BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.EraseFiles.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlEraseFiles);
        FormData fdlEraseFiles = new FormData();
        fdlEraseFiles.left = new FormAttachment(0, 0);
        fdlEraseFiles.top = new FormAttachment((Control)this.wDirectPath, margin);
        fdlEraseFiles.right = new FormAttachment(middle, -margin);
        wlEraseFiles.setLayoutData((Object)fdlEraseFiles);
        this.wEraseFiles = new Button(wBulkLoaderComposite, 32);
        PropsUi.setLook((Widget)this.wEraseFiles);
        FormData fdEraseFiles = new FormData();
        fdEraseFiles.left = new FormAttachment(middle, 0);
        fdEraseFiles.top = new FormAttachment((Control)this.wDirectPath, margin);
        fdEraseFiles.right = new FormAttachment(100, 0);
        this.wEraseFiles.setLayoutData((Object)fdEraseFiles);
        this.wEraseFiles.addListener(13, e -> this.input.setChanged());
        Label wlFailOnWarning = new Label(wBulkLoaderComposite, 131072);
        wlFailOnWarning.setText(BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.FailOnWarning.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFailOnWarning);
        FormData fdlFailOnWarning = new FormData();
        fdlFailOnWarning.left = new FormAttachment(0, 0);
        fdlFailOnWarning.top = new FormAttachment((Control)this.wEraseFiles, margin);
        fdlFailOnWarning.right = new FormAttachment(middle, -margin);
        wlFailOnWarning.setLayoutData((Object)fdlFailOnWarning);
        this.wFailOnWarning = new Button(wBulkLoaderComposite, 32);
        PropsUi.setLook((Widget)this.wFailOnWarning);
        FormData fdFailOnWarning = new FormData();
        fdFailOnWarning.left = new FormAttachment(middle, 0);
        fdFailOnWarning.top = new FormAttachment((Control)this.wEraseFiles, margin);
        fdFailOnWarning.right = new FormAttachment(100, 0);
        this.wFailOnWarning.setLayoutData((Object)fdFailOnWarning);
        this.wFailOnWarning.addListener(13, e -> this.input.setChanged());
        Label wlFailOnError = new Label(wBulkLoaderComposite, 131072);
        wlFailOnError.setText(BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.FailOnError.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFailOnError);
        FormData fdlFailOnError = new FormData();
        fdlFailOnError.left = new FormAttachment(0, 0);
        fdlFailOnError.top = new FormAttachment((Control)this.wFailOnWarning, margin);
        fdlFailOnError.right = new FormAttachment(middle, -margin);
        wlFailOnError.setLayoutData((Object)fdlFailOnError);
        this.wFailOnError = new Button(wBulkLoaderComposite, 32);
        PropsUi.setLook((Widget)this.wFailOnError);
        FormData fdFailOnError = new FormData();
        fdFailOnError.left = new FormAttachment(middle, 0);
        fdFailOnError.top = new FormAttachment((Control)this.wFailOnWarning, margin);
        fdFailOnError.right = new FormAttachment(100, 0);
        this.wFailOnError.setLayoutData((Object)fdFailOnError);
        this.wFailOnError.addListener(13, e -> this.input.setChanged());
        Label wlParallel = new Label(wBulkLoaderComposite, 131072);
        wlParallel.setText(BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.Parallel.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlParallel);
        FormData fdlParallel = new FormData();
        fdlParallel.left = new FormAttachment(0, 0);
        fdlParallel.top = new FormAttachment((Control)this.wFailOnError, margin);
        fdlParallel.right = new FormAttachment(middle, -margin);
        wlParallel.setLayoutData((Object)fdlParallel);
        this.wParallel = new Button(wBulkLoaderComposite, 32);
        PropsUi.setLook((Widget)this.wParallel);
        FormData fdParallel = new FormData();
        fdParallel.left = new FormAttachment(middle, 0);
        fdParallel.top = new FormAttachment((Control)this.wFailOnError, margin);
        fdParallel.right = new FormAttachment(100, 0);
        this.wParallel.setLayoutData((Object)fdParallel);
        this.wParallel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OraBulkLoaderDialog.this.input.setChanged();
                if (OraBulkLoaderDialog.this.wParallel.getSelection()) {
                    OraBulkLoaderDialog.this.wDirectPath.setSelection(true);
                }
            }
        });
        CTabItem wFieldsTab = new CTabItem(wTabFolder, 0);
        wFieldsTab.setText(BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.Fields.Label", (String[])new String[0]));
        Composite wFieldsComposite = new Composite((Composite)wTabFolder, 0);
        PropsUi.setLook((Widget)wFieldsComposite);
        FormLayout fFieldsLayout = new FormLayout();
        fFieldsLayout.marginWidth = 3;
        fFieldsLayout.marginHeight = 3;
        wFieldsComposite.setLayout((Layout)fFieldsLayout);
        FormData fdDataComp = new FormData();
        fdDataComp.left = new FormAttachment(0, 0);
        fdDataComp.top = new FormAttachment(0, 0);
        fdDataComp.right = new FormAttachment(100, 0);
        fdDataComp.bottom = new FormAttachment(100, 0);
        wFieldsComposite.setLayoutData((Object)fdDataComp);
        int upInsCols = 3;
        int upInsRows = this.input.getMappings() != null ? this.input.getMappings().size() : 1;
        this.ciReturn = new ColumnInfo[upInsCols];
        this.ciReturn[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.ColumnInfo.TableField", (String[])new String[0]), 2, new String[]{""}, false);
        this.ciReturn[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.ColumnInfo.StreamField", (String[])new String[0]), 2, new String[]{""}, false);
        this.ciReturn[2] = new ColumnInfo(BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.ColumnInfo.DateMask", (String[])new String[0]), 2, new String[]{"", BaseMessages.getString(PKG, (String)CONST_ORA_BULK_LOADER_DIALOG_DATE_MASK_LABEL, (String[])new String[0]), BaseMessages.getString(PKG, (String)CONST_ORA_BULK_LOADER_DIALOG_DATE_TIME_MASK_LABEL, (String[])new String[0])}, true);
        this.tableFieldColumns.add(this.ciReturn[0]);
        this.wReturn = new TableView(this.variables, wFieldsComposite, 68354, this.ciReturn, upInsRows, lsMod, this.props);
        Button wGetLU = new Button(wFieldsComposite, 8);
        wGetLU.setText(BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.GetFields.Label", (String[])new String[0]));
        wGetLU.addListener(13, e -> this.getUpdate());
        FormData fdGetLU = new FormData();
        fdGetLU.top = new FormAttachment(0, 0);
        fdGetLU.right = new FormAttachment(100, 0);
        fdGetLU.left = new FormAttachment((Control)this.wReturn, margin);
        wGetLU.setLayoutData((Object)fdGetLU);
        Button wDoMapping = new Button(wFieldsComposite, 8);
        wDoMapping.setText(BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.EditMapping.Label", (String[])new String[0]));
        FormData fdDoMapping = new FormData();
        fdDoMapping.top = new FormAttachment((Control)wGetLU, margin);
        fdDoMapping.right = new FormAttachment(100, 0);
        wDoMapping.setLayoutData((Object)fdDoMapping);
        wDoMapping.addListener(13, e -> this.generateMappings());
        FormData fdReturn = new FormData();
        fdReturn.left = new FormAttachment(0, 0);
        fdReturn.top = new FormAttachment(0, 0);
        fdReturn.right = new FormAttachment((Control)wDoMapping, -margin);
        fdReturn.bottom = new FormAttachment(100, 0);
        this.wReturn.setLayoutData((Object)fdReturn);
        wBulkLoaderTab.setControl((Control)wBulkLoaderComposite);
        wFieldsTab.setControl((Control)wFieldsComposite);
        Runnable runnable = () -> {
            TransformMeta transformMeta = this.pipelineMeta.findTransform(this.transformName);
            if (transformMeta != null) {
                try {
                    IRowMeta row = this.pipelineMeta.getPrevTransformFields(this.variables, transformMeta);
                    for (int i = 0; i < row.size(); ++i) {
                        this.inputFields.add(row.getValueMeta(i).getName());
                    }
                    this.setComboBoxes();
                }
                catch (HopException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
                }
            }
        };
        new Thread(runnable).start();
        wbSqlldr.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(OraBulkLoaderDialog.this.shell, 4096);
                dialog.setFilterExtensions(new String[]{"*"});
                if (OraBulkLoaderDialog.this.wSqlldr.getText() != null) {
                    dialog.setFileName(OraBulkLoaderDialog.this.wSqlldr.getText());
                }
                dialog.setFilterNames(ALL_FILETYPES);
                if (dialog.open() != null) {
                    OraBulkLoaderDialog.this.wSqlldr.setText(dialog.getFilterPath() + Const.FILE_SEPARATOR + dialog.getFileName());
                }
            }
        });
        wbControlFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(OraBulkLoaderDialog.this.shell, 4096);
                dialog.setFilterExtensions(new String[]{"*"});
                if (OraBulkLoaderDialog.this.wControlFile.getText() != null) {
                    dialog.setFileName(OraBulkLoaderDialog.this.wControlFile.getText());
                }
                dialog.setFilterNames(ALL_FILETYPES);
                if (dialog.open() != null) {
                    OraBulkLoaderDialog.this.wControlFile.setText(dialog.getFilterPath() + Const.FILE_SEPARATOR + dialog.getFileName());
                }
            }
        });
        wbDataFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(OraBulkLoaderDialog.this.shell, 4096);
                dialog.setFilterExtensions(new String[]{"*"});
                if (OraBulkLoaderDialog.this.wDataFile.getText() != null) {
                    dialog.setFileName(OraBulkLoaderDialog.this.wDataFile.getText());
                }
                dialog.setFilterNames(ALL_FILETYPES);
                if (dialog.open() != null) {
                    OraBulkLoaderDialog.this.wDataFile.setText(dialog.getFilterPath() + Const.FILE_SEPARATOR + dialog.getFileName());
                }
            }
        });
        wbLogFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(OraBulkLoaderDialog.this.shell, 4096);
                dialog.setFilterExtensions(new String[]{"*"});
                if (OraBulkLoaderDialog.this.wLogFile.getText() != null) {
                    dialog.setFileName(OraBulkLoaderDialog.this.wLogFile.getText());
                }
                dialog.setFilterNames(ALL_FILETYPES);
                if (dialog.open() != null) {
                    OraBulkLoaderDialog.this.wLogFile.setText(dialog.getFilterPath() + Const.FILE_SEPARATOR + dialog.getFileName());
                }
            }
        });
        wbBadFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(OraBulkLoaderDialog.this.shell, 4096);
                dialog.setFilterExtensions(new String[]{"*"});
                if (OraBulkLoaderDialog.this.wBadFile.getText() != null) {
                    dialog.setFileName(OraBulkLoaderDialog.this.wBadFile.getText());
                }
                dialog.setFilterNames(ALL_FILETYPES);
                if (dialog.open() != null) {
                    OraBulkLoaderDialog.this.wBadFile.setText(dialog.getFilterPath() + Const.FILE_SEPARATOR + dialog.getFileName());
                }
            }
        });
        wbDiscardFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(OraBulkLoaderDialog.this.shell, 4096);
                dialog.setFilterExtensions(new String[]{"*"});
                if (OraBulkLoaderDialog.this.wDiscardFile.getText() != null) {
                    dialog.setFileName(OraBulkLoaderDialog.this.wDiscardFile.getText());
                }
                dialog.setFilterNames(ALL_FILETYPES);
                if (dialog.open() != null) {
                    OraBulkLoaderDialog.this.wDiscardFile.setText(dialog.getFilterPath() + Const.FILE_SEPARATOR + dialog.getFileName());
                }
            }
        });
        this.getData();
        wTabFolder.setSelection(0);
        this.setTableFieldCombo();
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    protected void setComboBoxes() {
        String[] fieldNames = ConstUi.sortFieldNames(this.inputFields);
        this.ciReturn[1].setComboValues(fieldNames);
    }

    private void setTableFieldCombo() {
        Runnable fieldLoader = () -> {
            if (!(this.wTable.isDisposed() || this.wConnection.isDisposed() || this.wSchema.isDisposed())) {
                DatabaseMeta databaseMeta;
                String tableName = this.wTable.getText();
                String connectionName = this.wConnection.getText();
                String schemaName = this.wSchema.getText();
                for (ColumnInfo colInfo : this.tableFieldColumns) {
                    colInfo.setComboValues(new String[0]);
                }
                if (!Utils.isEmpty((CharSequence)tableName) && (databaseMeta = this.pipelineMeta.findDatabase(connectionName, this.variables)) != null) {
                    Database db = new Database(loggingObject, this.variables, databaseMeta);
                    try {
                        String[] fieldNames;
                        db.connect();
                        String schemaTable = databaseMeta.getQuotedSchemaTableCombination(this.variables, schemaName, tableName);
                        IRowMeta rowMeta = db.getTableFields(schemaTable);
                        if (null != rowMeta && null != (fieldNames = rowMeta.getFieldNames())) {
                            for (ColumnInfo colInfo : this.tableFieldColumns) {
                                colInfo.setComboValues(fieldNames);
                            }
                        }
                    }
                    catch (Exception e) {
                        for (ColumnInfo colInfo : this.tableFieldColumns) {
                            colInfo.setComboValues(new String[0]);
                        }
                    }
                    finally {
                        try {
                            if (db != null) {
                                db.disconnect();
                            }
                        }
                        catch (Exception ignored) {
                            db = null;
                        }
                    }
                }
            }
        };
        this.shell.getDisplay().asyncExec(fieldLoader);
    }

    public void getData() {
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.Log.GettingKeyInfo", (String[])new String[0]));
        }
        this.wMaxErrors.setText(this.input.getMaxErrors());
        this.wCommit.setText(this.input.getCommitSize());
        this.wBindSize.setText(this.input.getBindSize());
        this.wReadSize.setText(this.input.getReadSize());
        for (int i = 0; i < this.input.getMappings().size(); ++i) {
            String dateMask;
            TableItem item = this.wReturn.table.getItem(i);
            OraBulkLoaderMappingMeta mapping = this.input.getMappings().get(i);
            if (mapping.getFieldTable() != null) {
                item.setText(1, mapping.getFieldTable());
            }
            if (mapping.getFieldStream() != null) {
                item.setText(2, mapping.getFieldStream());
            }
            if ((dateMask = mapping.getDateMask()) != null) {
                if ("DATE".equals(dateMask)) {
                    item.setText(3, BaseMessages.getString(PKG, (String)CONST_ORA_BULK_LOADER_DIALOG_DATE_MASK_LABEL, (String[])new String[0]));
                    continue;
                }
                if ("DATETIME".equals(dateMask)) {
                    item.setText(3, BaseMessages.getString(PKG, (String)CONST_ORA_BULK_LOADER_DIALOG_DATE_TIME_MASK_LABEL, (String[])new String[0]));
                    continue;
                }
                item.setText(3, "");
                continue;
            }
            item.setText(3, "");
        }
        if (this.input.getConnection() != null) {
            this.wConnection.setText(this.input.getConnection());
        }
        if (this.input.getSchemaName() != null) {
            this.wSchema.setText(this.input.getSchemaName());
        }
        if (this.input.getTableName() != null) {
            this.wTable.setText(this.input.getTableName());
        }
        if (this.input.getSqlldr() != null) {
            this.wSqlldr.setText(this.input.getSqlldr());
        }
        if (this.input.getControlFile() != null) {
            this.wControlFile.setText(this.input.getControlFile());
        }
        if (this.input.getDataFile() != null) {
            this.wDataFile.setText(this.input.getDataFile());
        }
        if (this.input.getLogFile() != null) {
            this.wLogFile.setText(this.input.getLogFile());
        }
        if (this.input.getBadFile() != null) {
            this.wBadFile.setText(this.input.getBadFile());
        }
        if (this.input.getDiscardFile() != null) {
            this.wDiscardFile.setText(this.input.getDiscardFile());
        }
        if (this.input.getEncoding() != null) {
            this.wEncoding.setText(this.input.getEncoding());
        }
        if (this.input.getCharacterSetName() != null) {
            this.wCharacterSetName.setText(this.input.getCharacterSetName());
        }
        if (this.input.getAltRecordTerm() != null) {
            this.wAltRecordTerm.setText(this.input.getAltRecordTerm());
        }
        this.wDirectPath.setSelection(this.input.isDirectPath());
        this.wEraseFiles.setSelection(this.input.isEraseFiles());
        this.wFailOnError.setSelection(this.input.isFailOnError());
        this.wParallel.setSelection(this.input.isParallel());
        this.wFailOnWarning.setSelection(this.input.isFailOnWarning());
        String method = this.input.getLoadMethod();
        if ("AUTO_END".equals(method)) {
            this.wLoadMethod.select(0);
        } else if ("MANUAL".equals(method)) {
            this.wLoadMethod.select(1);
        } else if ("AUTO_CONCURRENT".equals(method)) {
            this.wLoadMethod.select(2);
        } else {
            if (this.log.isDebug()) {
                this.logDebug("Internal error: load_method set to default 'auto at end'");
            }
            this.wLoadMethod.select(0);
        }
        String action = this.input.getLoadAction();
        if ("APPEND".equals(action)) {
            this.wLoadAction.select(0);
        } else if ("INSERT".equals(action)) {
            this.wLoadAction.select(1);
        } else if ("REPLACE".equals(action)) {
            this.wLoadAction.select(2);
        } else if ("TRUNCATE".equals(action)) {
            this.wLoadAction.select(3);
        } else {
            if (this.log.isDebug()) {
                this.logDebug("Internal error: load_action set to default 'append'");
            }
            this.wLoadAction.select(0);
        }
        this.wReturn.setRowNums();
        this.wReturn.optWidth(true);
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void getInfo(OraBulkLoaderMeta meta) {
        meta.setMaxErrors(this.wMaxErrors.getText());
        meta.setCommitSize(this.wCommit.getText());
        meta.setBindSize(this.wBindSize.getText());
        meta.setReadSize(this.wReadSize.getText());
        int nrfields = this.wReturn.nrNonEmpty();
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.Log.FoundFields", (String[])new String[]{"" + nrfields}));
        }
        ArrayList<OraBulkLoaderMappingMeta> mappings = new ArrayList<OraBulkLoaderMappingMeta>();
        for (int i = 0; i < nrfields; ++i) {
            OraBulkLoaderMappingMeta mapping = new OraBulkLoaderMappingMeta();
            TableItem item = this.wReturn.getNonEmpty(i);
            mapping.setFieldTable(item.getText(1));
            mapping.setFieldStream(item.getText(2));
            if (BaseMessages.getString(PKG, (String)CONST_ORA_BULK_LOADER_DIALOG_DATE_MASK_LABEL, (String[])new String[0]).equals(item.getText(3))) {
                mapping.setDateMask("DATE");
            } else if (BaseMessages.getString(PKG, (String)CONST_ORA_BULK_LOADER_DIALOG_DATE_TIME_MASK_LABEL, (String[])new String[0]).equals(item.getText(3))) {
                mapping.setDateMask("DATETIME");
            }
            mappings.add(mapping);
        }
        meta.setMappings(mappings);
        meta.setSchemaName(this.wSchema.getText());
        meta.setTableName(this.wTable.getText());
        meta.setConnection(this.wConnection.getText());
        meta.setSqlldr(this.wSqlldr.getText());
        meta.setControlFile(this.wControlFile.getText());
        meta.setDataFile(this.wDataFile.getText());
        meta.setLogFile(this.wLogFile.getText());
        meta.setBadFile(this.wBadFile.getText());
        meta.setDiscardFile(this.wDiscardFile.getText());
        meta.setEncoding(this.wEncoding.getText());
        meta.setCharacterSetName(this.wCharacterSetName.getText());
        meta.setAltRecordTerm(this.wAltRecordTerm.getText());
        meta.setDirectPath(this.wDirectPath.getSelection());
        meta.setEraseFiles(this.wEraseFiles.getSelection());
        meta.setFailOnError(this.wFailOnError.getSelection());
        meta.setParallel(this.wParallel.getSelection());
        meta.setFailOnWarning(this.wFailOnWarning.getSelection());
        String method = this.wLoadMethod.getText();
        if (BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.AutoConcLoadMethod.Label", (String[])new String[0]).equals(method)) {
            meta.setLoadMethod("AUTO_CONCURRENT");
        } else if (BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.AutoEndLoadMethod.Label", (String[])new String[0]).equals(method)) {
            meta.setLoadMethod("AUTO_END");
        } else if (BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.ManualLoadMethod.Label", (String[])new String[0]).equals(method)) {
            meta.setLoadMethod("MANUAL");
        } else {
            if (this.log.isDebug()) {
                this.logDebug("Internal error: load_method set to default 'auto concurrent', value found '" + method + "'.");
            }
            meta.setLoadMethod("AUTO_END");
        }
        String action = this.wLoadAction.getText();
        if (BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.AppendLoadAction.Label", (String[])new String[0]).equals(action)) {
            meta.setLoadAction("APPEND");
        } else if (BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.InsertLoadAction.Label", (String[])new String[0]).equals(action)) {
            meta.setLoadAction("INSERT");
        } else if (BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.ReplaceLoadAction.Label", (String[])new String[0]).equals(action)) {
            meta.setLoadAction("REPLACE");
        } else if (BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.TruncateLoadAction.Label", (String[])new String[0]).equals(action)) {
            meta.setLoadAction("TRUNCATE");
        } else {
            if (this.log.isDebug()) {
                this.logDebug("Internal error: load_action set to default 'append', value found '" + action + "'.");
            }
            meta.setLoadAction("APPEND");
        }
        this.transformName = this.wTransformName.getText();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.getInfo(this.input);
        if (this.input.getConnection() == null) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.InvalidConnection.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.InvalidConnection.DialogTitle", (String[])new String[0]));
            mb.open();
        }
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getSchemaNames() {
        DatabaseMeta databaseMeta = this.pipelineMeta.findDatabase(this.wConnection.getText(), this.variables);
        if (databaseMeta != null) {
            Database database = new Database(loggingObject, this.variables, databaseMeta);
            try {
                database.connect();
                String[] schemas = database.getSchemas();
                if (null != schemas && schemas.length > 0) {
                    EnterSelectionDialog dialog = new EnterSelectionDialog(this.shell, schemas = Const.sortStrings((String[])schemas), BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.AvailableSchemas.Title", (String[])new String[]{this.wConnection.getText()}), BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.AvailableSchemas.Message", (String[])new String[]{this.wConnection.getText()}));
                    String d = dialog.open();
                    if (d != null) {
                        this.wSchema.setText(Const.NVL((String)d, (String)""));
                        this.setTableFieldCombo();
                    }
                } else {
                    MessageBox mb = new MessageBox(this.shell, 33);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.NoSchema.Error", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.GetSchemas.Error", (String[])new String[0]));
                    mb.open();
                }
            }
            catch (Exception e) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.ErrorGettingSchemas", (String[])new String[0]), e);
            }
            finally {
                database.disconnect();
            }
        }
    }

    private void getTableName() {
        String connectionName = this.wConnection.getText();
        if (StringUtils.isEmpty((String)connectionName)) {
            return;
        }
        DatabaseMeta databaseMeta = this.pipelineMeta.findDatabase(connectionName, this.variables);
        if (databaseMeta != null) {
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.Log.LookingAtConnection", (String[])new String[0]) + databaseMeta.toString());
            }
            DatabaseExplorerDialog dialog = new DatabaseExplorerDialog(this.shell, 0, this.variables, databaseMeta, this.pipelineMeta.getDatabases());
            dialog.setSelectedSchemaAndTable(this.variables.resolve(this.wSchema.getText()), this.variables.resolve(this.wTable.getText()));
            if (dialog.open()) {
                this.wSchema.setText(Const.NVL((String)dialog.getSchemaName(), (String)""));
                this.wTable.setText(Const.NVL((String)dialog.getTableName(), (String)""));
            }
        } else {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.InvalidConnection.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.InvalidConnection.DialogTitle", (String[])new String[0]));
            mb.open();
        }
    }

    private void getUpdate() {
        try {
            IRowMeta r = this.pipelineMeta.getPrevInfoFields(this.variables, this.transformName);
            if (r != null) {
                ITableItemInsertListener listener = (tableItem, v) -> {
                    if (v.getType() == 3) {
                        tableItem.setText(3, BaseMessages.getString(PKG, (String)CONST_ORA_BULK_LOADER_DIALOG_DATE_MASK_LABEL, (String[])new String[0]));
                    } else {
                        tableItem.setText(3, "");
                    }
                    return true;
                };
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wReturn, (int)1, (int[])new int[]{1, 2}, (int[])new int[0], (int)-1, (int)-1, (ITableItemInsertListener)listener);
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void create() {
        try {
            OraBulkLoaderMeta info = new OraBulkLoaderMeta();
            this.getInfo(info);
            DatabaseMeta databaseMeta = this.pipelineMeta.findDatabase(info.getConnection(), this.variables);
            String name = this.transformName;
            TransformMeta transformMeta = new TransformMeta(BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.TransformMeta.Title", (String[])new String[0]), name, (ITransformMeta)info);
            IRowMeta prev = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            SqlStatement sql = info.getSqlStatements(this.variables, this.pipelineMeta, transformMeta, prev, this.metadataProvider);
            if (!sql.hasError()) {
                if (sql.hasSql()) {
                    SqlEditor sqledit = new SqlEditor(this.shell, 0, this.variables, databaseMeta, DbCache.getInstance(), sql.getSql());
                    sqledit.open();
                } else {
                    MessageBox mb = new MessageBox(this.shell, 34);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.NoSQLNeeds.DialogMessage", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.NoSQLNeeds.DialogTitle", (String[])new String[0]));
                    mb.open();
                }
            } else {
                MessageBox mb = new MessageBox(this.shell, 33);
                mb.setMessage(sql.getError());
                mb.setText(BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.SQLError.DialogTitle", (String[])new String[0]));
                mb.open();
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.CouldNotBuildSQL.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.CouldNotBuildSQL.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void generateMappings() {
        EnterMappingDialog d;
        IRowMeta targetFields;
        IRowMeta sourceFields;
        try {
            sourceFields = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformMeta);
        }
        catch (HopException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.DoMapping.UnableToFindSourceFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.DoMapping.UnableToFindSourceFields.Message", (String[])new String[0]), (Exception)((Object)e));
            return;
        }
        this.input.setConnection(this.wConnection.getText());
        this.input.setTableName(this.variables.resolve(this.wTable.getText()));
        ITransformMeta transformMetaInterface = this.transformMeta.getTransform();
        try {
            targetFields = transformMetaInterface.getRequiredFields(this.variables);
        }
        catch (HopException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.DoMapping.UnableToFindTargetFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.DoMapping.UnableToFindTargetFields.Message", (String[])new String[0]), (Exception)((Object)e));
            return;
        }
        String[] inputNames = new String[sourceFields.size()];
        for (int i = 0; i < sourceFields.size(); ++i) {
            IValueMeta value = sourceFields.getValueMeta(i);
            inputNames[i] = value.getName() + "            (" + value.getOrigin() + ")";
        }
        List<SourceToTargetMapping> mappings = new ArrayList();
        StringBuilder missingSourceFields = new StringBuilder();
        StringBuilder missingTargetFields = new StringBuilder();
        int nrFields = this.wReturn.nrNonEmpty();
        for (int i = 0; i < nrFields; ++i) {
            int targetIndex;
            TableItem item = this.wReturn.getNonEmpty(i);
            String source = item.getText(2);
            String target = item.getText(1);
            int sourceIndex = sourceFields.indexOfValue(source);
            if (sourceIndex < 0) {
                missingSourceFields.append(Const.CR).append("   ").append(source).append(" --> ").append(target);
            }
            if ((targetIndex = targetFields.indexOfValue(target)) < 0) {
                missingTargetFields.append(Const.CR).append("   ").append(source).append(" --> ").append(target);
            }
            if (sourceIndex < 0 || targetIndex < 0) continue;
            SourceToTargetMapping mapping = new SourceToTargetMapping(sourceIndex, targetIndex);
            mappings.add(mapping);
        }
        if (missingSourceFields.length() > 0 || missingTargetFields.length() > 0) {
            boolean goOn;
            Object message = "";
            if (missingSourceFields.length() > 0) {
                message = (String)message + BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.DoMapping.SomeSourceFieldsNotFound", (String[])new String[]{missingSourceFields.toString()}) + Const.CR;
            }
            if (missingTargetFields.length() > 0) {
                message = (String)message + BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.DoMapping.SomeTargetFieldsNotFound", (String[])new String[]{missingSourceFields.toString()}) + Const.CR;
            }
            message = (String)message + Const.CR;
            message = (String)message + BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.DoMapping.SomeFieldsNotFoundContinue", (String[])new String[0]) + Const.CR;
            int answer = BaseDialog.openMessageBox((Shell)this.shell, (String)BaseMessages.getString(PKG, (String)"OraBulkLoaderDialog.DoMapping.SomeFieldsNotFoundTitle", (String[])new String[0]), (String)message, (int)292);
            boolean bl = goOn = (answer & 0x20) != 0;
            if (!goOn) {
                return;
            }
        }
        if ((mappings = (d = new EnterMappingDialog(this.shell, sourceFields.getFieldNames(), targetFields.getFieldNames(), mappings)).open()) != null) {
            this.wReturn.table.removeAll();
            this.wReturn.table.setItemCount(mappings.size());
            for (int i = 0; i < mappings.size(); ++i) {
                SourceToTargetMapping mapping = (SourceToTargetMapping)mappings.get(i);
                TableItem item = this.wReturn.table.getItem(i);
                item.setText(2, sourceFields.getValueMeta(mapping.getSourcePosition()).getName());
                item.setText(1, targetFields.getValueMeta(mapping.getTargetPosition()).getName());
            }
            this.wReturn.setRowNums();
            this.wReturn.optWidth(true);
        }
    }
}

