/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.dialog;

import org.apache.hop.core.Const;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class MessageDialogWithToggle {
    private static final int OK = 0;
    private static final int CANCEL = 1;
    private Shell parent;
    private String title;
    private String message;
    private String[] buttonLabels;
    private int dialogImageType;
    private String toggleLabel;
    private boolean toggleState;
    private Shell shell;
    private final PropsUi props;
    private int returnCode = 0;

    public MessageDialogWithToggle(Shell parent, String title, String message, int dialogImageType, String[] buttonLabels, String toggleLabel, boolean toggleState) {
        this.parent = parent;
        this.title = title;
        this.message = message;
        this.dialogImageType = dialogImageType;
        this.buttonLabels = buttonLabels;
        this.toggleLabel = toggleLabel;
        this.toggleState = toggleState;
        this.props = PropsUi.getInstance();
    }

    public int open() {
        int margin = PropsUi.getMargin();
        this.shell = new Shell(this.parent, 65600);
        FormLayout shellLayout = new FormLayout();
        shellLayout.marginTop = margin;
        shellLayout.marginLeft = margin;
        shellLayout.marginRight = margin;
        shellLayout.marginBottom = margin;
        this.shell.setLayout((Layout)shellLayout);
        this.shell.setImage(GuiResource.getInstance().getImageHopUi());
        this.shell.setText(Const.NVL((String)this.title, (String)""));
        PropsUi.setLook((Widget)this.shell);
        Image[] image = new Image[1];
        Display display = this.parent.getDisplay();
        display.syncExec(() -> {
            image[0] = display.getSystemImage(this.dialogImageType);
        });
        Label wlImage = new Label((Composite)this.shell, 0);
        wlImage.setImage(image[0]);
        FormData fdImage = new FormData();
        fdImage.right = new FormAttachment(100, 0);
        fdImage.top = new FormAttachment(0, 0);
        wlImage.setLayoutData((Object)fdImage);
        Label wlMessage = new Label((Composite)this.shell, 64);
        PropsUi.setLook((Widget)wlMessage);
        wlMessage.setText(Const.NVL((String)this.message, (String)""));
        FormData fdMessage = new FormData();
        fdMessage.left = new FormAttachment(0, 0);
        fdMessage.top = new FormAttachment(0, 0);
        fdMessage.right = new FormAttachment((Control)wlImage, -margin);
        wlMessage.setLayoutData((Object)fdMessage);
        Button wToggle = new Button((Composite)this.shell, 16416);
        PropsUi.setLook((Widget)wToggle);
        wToggle.setText(this.toggleLabel);
        wToggle.setSelection(this.toggleState);
        FormData fdToggle = new FormData();
        fdToggle.left = new FormAttachment(0, 0);
        fdToggle.right = new FormAttachment(100, 0);
        fdToggle.top = new FormAttachment((Control)wlMessage, 2 * margin);
        wToggle.setLayoutData((Object)fdToggle);
        wToggle.addListener(13, e -> {
            this.toggleState = wToggle.getSelection();
        });
        Button[] buttons = new Button[this.buttonLabels.length];
        for (int i = 0; i < buttons.length; ++i) {
            int index = i;
            buttons[i] = new Button((Composite)this.shell, 8);
            PropsUi.setLook((Widget)buttons[i]);
            buttons[i].setText(this.buttonLabels[i]);
            buttons[i].addListener(13, e -> {
                this.returnCode = index;
                this.dispose();
            });
        }
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, buttons, margin, (Control)wToggle);
        BaseTransformDialog.setSize(this.shell);
        this.shell.pack();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.returnCode;
    }

    private void cancel() {
        this.returnCode = 1;
        this.dispose();
    }

    private void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    public boolean getToggleState() {
        return this.toggleState;
    }
}

