/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.samplerows;

import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.Range;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.samplerows.SampleRowsData;
import org.apache.hop.pipeline.transforms.samplerows.SampleRowsMeta;

public class SampleRows
extends BaseTransform<SampleRowsMeta, SampleRowsData> {
    private static final Class<?> PKG = SampleRowsMeta.class;

    public SampleRows(TransformMeta transformMeta, SampleRowsMeta meta, SampleRowsData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        int linesRead;
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            String realRange = this.resolve(((SampleRowsMeta)this.meta).getLinesRange());
            ((SampleRowsData)this.data).addlineField = !Utils.isEmpty((CharSequence)this.resolve(((SampleRowsMeta)this.meta).getLineNumberField()));
            ((SampleRowsData)this.data).previousRowMeta = this.getInputRowMeta().clone();
            ((SampleRowsData)this.data).NrPrevFields = ((SampleRowsData)this.data).previousRowMeta.size();
            ((SampleRowsData)this.data).outputRowMeta = ((SampleRowsData)this.data).previousRowMeta;
            if (((SampleRowsData)this.data).addlineField) {
                ((SampleRowsMeta)this.meta).getFields(((SampleRowsData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            }
            String[] rangePart = realRange.split(",");
            ImmutableRangeSet.Builder setBuilder = ImmutableRangeSet.builder();
            for (String part : rangePart) {
                if (part.matches("\\d+")) {
                    if (this.isDebug()) {
                        this.logDebug(BaseMessages.getString(PKG, (String)"SampleRows.Log.RangeValue", (String[])new String[]{part}));
                    }
                    int vpart = Integer.valueOf(part);
                    setBuilder.add(Range.singleton((Comparable)Integer.valueOf(vpart)));
                    continue;
                }
                if (!part.matches("\\d+\\.\\.\\d+")) continue;
                String[] rangeMultiPart = part.split("\\.\\.");
                Integer start = Integer.valueOf(rangeMultiPart[0]);
                Integer end = Integer.valueOf(rangeMultiPart[1]);
                Range range = Range.closed((Comparable)start, (Comparable)end);
                if (this.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"SampleRows.Log.RangeValue", (Object[])new Object[]{range}));
                }
                setBuilder.add(range);
            }
            ((SampleRowsData)this.data).rangeSet = setBuilder.build();
        }
        if (((SampleRowsData)this.data).addlineField) {
            ((SampleRowsData)this.data).outputRow = RowDataUtil.allocateRowData((int)((SampleRowsData)this.data).outputRowMeta.size());
            for (int i = 0; i < ((SampleRowsData)this.data).NrPrevFields; ++i) {
                ((SampleRowsData)this.data).outputRow[i] = r[i];
            }
        } else {
            ((SampleRowsData)this.data).outputRow = r;
        }
        if (((SampleRowsData)this.data).rangeSet.contains((Comparable)Integer.valueOf(linesRead = (int)this.getLinesRead()))) {
            if (((SampleRowsData)this.data).addlineField) {
                ((SampleRowsData)this.data).outputRow[((SampleRowsData)this.data).NrPrevFields] = this.getLinesRead();
            }
            this.putRow(((SampleRowsData)this.data).outputRowMeta, ((SampleRowsData)this.data).outputRow);
            if (this.isRowLevel()) {
                this.logRowlevel(BaseMessages.getString(PKG, (String)"SampleRows.Log.LineNumber", (String[])new String[]{linesRead + " : " + this.getInputRowMeta().getString(r)}));
            }
        }
        if (((SampleRowsData)this.data).rangeSet.isEmpty() || linesRead >= (Integer)((SampleRowsData)this.data).rangeSet.span().upperEndpoint()) {
            this.setOutputDone();
        }
        return true;
    }

    public boolean init() {
        return super.init();
    }
}

