/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400BidiTransform;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Impl;
import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Server;
import com.ibm.as400.access.BidiConversionProperties;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConverterImplRemote;
import com.ibm.as400.access.DataStream;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.RCCallProgramFailureReplyDataStream;
import com.ibm.as400.access.RCCallProgramReplyDataStream;
import com.ibm.as400.access.RCCallProgramRequestDataStream;
import com.ibm.as400.access.RCExchangeAttributesReplyDataStream;
import com.ibm.as400.access.RCExchangeAttributesRequestDataStream;
import com.ibm.as400.access.RCRunCommandReplyDataStream;
import com.ibm.as400.access.RCRunCommandRequestDataStream;
import com.ibm.as400.access.RemoteCommandImpl;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.util.StringTokenizer;

class RemoteCommandImplRemote
implements RemoteCommandImpl {
    private static final String CLASSNAME = "com.ibm.as400.access.RemoteCommandImplRemote";
    AS400ImplRemote system_;
    ConverterImplRemote converter_;
    ConverterImplRemote unicodeConverter_;
    boolean ccsidIsUserOveride_ = false;
    private AS400Server server_;
    AS400Message[] messageList_ = new AS400Message[0];
    int serverDataStreamLevel_ = 0;
    protected Boolean priorCallWasOnThread_ = null;

    RemoteCommandImplRemote() {
    }

    @Override
    public boolean isNative() {
        return false;
    }

    @Override
    public void setSystem(AS400Impl system) throws IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting up remote command implementation object.");
        }
        this.system_ = (AS400ImplRemote)system;
        int ccsid = this.system_.getUserOverrideCcsid();
        if (ccsid != 0) {
            if (ccsid == 65535) {
                if (Trace.traceOn_) {
                    Trace.log(4, "Disregarding specified user override CCSID: 65535");
                }
            } else {
                this.converter_ = ConverterImplRemote.getConverter(ccsid, this.system_);
                this.ccsidIsUserOveride_ = true;
            }
        }
    }

    @Override
    public String getJobInfo(Boolean threadSafety) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        String jobInfo;
        if (Trace.traceOn_) {
            Trace.log(1, "Getting job information from server_ object.");
        }
        this.openOffThread();
        if (null != this.server_ && null != (jobInfo = this.server_.getJobString()) && jobInfo.split("/").length == 3) {
            String[] info = this.server_.getJobString().split("/");
            StringBuffer buf = new StringBuffer();
            buf.append(info[2].trim());
            while (buf.length() < 10) {
                buf.append(' ');
            }
            buf.append(info[1].trim());
            while (buf.length() < 20) {
                buf.append(' ');
            }
            buf.append(info[0].trim());
            while (buf.length() < 26) {
                buf.append(' ');
            }
            if (Trace.traceOn_) {
                Trace.log(1, "Job information retrieved:", buf.toString());
            }
            return buf.toString();
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Getting job information from implementation object.");
        }
        ProgramParameter[] parameterList = new ProgramParameter[6];
        byte[] dataReceived = new byte[46];
        parameterList[0] = new ProgramParameter(dataReceived.length);
        byte[] receiverLength = BinaryConverter.intToByteArray(dataReceived.length);
        parameterList[1] = new ProgramParameter(receiverLength);
        byte[] formatName = new byte[]{-39, -29, -27, -61, -16, -15, -16, -16};
        parameterList[2] = new ProgramParameter(formatName);
        byte[] numAttributes = BinaryConverter.intToByteArray(1);
        parameterList[3] = new ProgramParameter(numAttributes);
        byte[] attributeKey = BinaryConverter.intToByteArray(1009);
        parameterList[4] = new ProgramParameter(attributeKey);
        parameterList[5] = new ProgramParameter(new byte[8]);
        try {
            boolean succeeded = ON_THREAD.equals(threadSafety) ? this.runProgramOnThread("QSYS", "QWCRTVCA", parameterList, 0, false) : this.runProgramOffThread("QSYS", "QWCRTVCA", parameterList, 0);
            if (!succeeded) {
                Trace.log(2, "Unable to retrieve job information.");
                throw new AS400Exception(this.messageList_);
            }
        }
        catch (ObjectDoesNotExistException e) {
            Trace.log(2, "Unexpected ObjectDoesNotExistException:", (Throwable)e);
            throw new InternalErrorException(10);
        }
        dataReceived = parameterList[0].getOutputData();
        if (Trace.traceOn_) {
            Trace.log(1, "Job information retrieved:", dataReceived);
        }
        return this.converter_.byteArrayToString(dataReceived, 20, 26);
    }

    @Override
    public AS400Message[] getMessageList() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting message list from implementation object.");
        }
        return this.messageList_;
    }

    @Override
    public int getThreadsafeIndicator(String command) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        int threadsafeIndicator;
        String cmdName;
        String libName;
        if (Trace.traceOn_) {
            Trace.log(1, "Retrieving command Threadsafe indicator.");
        }
        this.openOnThread();
        StringTokenizer tokenizer = new StringTokenizer(command);
        String cmdLibAndName = tokenizer.nextToken().toUpperCase();
        int slashPos = cmdLibAndName.indexOf(47);
        if (slashPos == -1) {
            libName = "*LIBL";
            cmdName = cmdLibAndName;
        } else {
            libName = cmdLibAndName.substring(0, slashPos);
            cmdName = cmdLibAndName.substring(slashPos + 1);
        }
        byte[] commandName = new byte[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
        this.converter_.stringToByteArray(cmdName, commandName);
        this.converter_.stringToByteArray(libName, commandName, 10);
        int numParms = AS400.nativeVRM.getVersionReleaseModification() >= 393472 || AS400.nativeVRM.getVersionReleaseModification() >= 328704 && !this.system_.isMissingPTF() ? 6 : 5;
        ProgramParameter[] parameterList = new ProgramParameter[numParms];
        parameterList[0] = new ProgramParameter(350);
        parameterList[1] = new ProgramParameter(new byte[]{0, 0, 1, 94});
        parameterList[2] = new ProgramParameter(new byte[]{-61, -44, -60, -55, -16, -15, -16, -16});
        parameterList[3] = new ProgramParameter(commandName);
        parameterList[4] = new ProgramParameter(new byte[8]);
        if (numParms > 5) {
            parameterList[5] = new ProgramParameter(new byte[]{-15});
        }
        try {
            boolean succeeded = this.runProgramOnThread("QSYS", "QCDRCMDI", parameterList, 0, true);
            if (!succeeded) {
                if (numParms > 5 && AS400.nativeVRM.getVersionReleaseModification() < 393472 && AS400.nativeVRM.getVersionReleaseModification() >= 328704 && this.messageList_[this.messageList_.length - 1].getID().equals("MCH0802")) {
                    if (Trace.traceOn_) {
                        Trace.log(4, "PTF SI29629 is not installed: (MCH0802) " + this.messageList_[this.messageList_.length - 1].getText());
                    }
                    this.system_.setMissingPTF();
                    ProgramParameter[] shorterParmList = new ProgramParameter[5];
                    System.arraycopy(parameterList, 0, shorterParmList, 0, 5);
                    succeeded = this.runProgramOnThread("QSYS", "QCDRCMDI", shorterParmList, 0, true);
                }
                if (!succeeded) {
                    Trace.log(2, "Unable to retrieve command information.");
                    String id = this.messageList_[this.messageList_.length - 1].getID();
                    byte[] substitutionBytes = this.messageList_[this.messageList_.length - 1].getSubstitutionData();
                    if (id.equals("CPF9801") && cmdName.equals(this.converter_.byteArrayToString(substitutionBytes, 0, 10).trim()) && libName.equals(this.converter_.byteArrayToString(substitutionBytes, 10, 10).trim()) && "CMD".equals(this.converter_.byteArrayToString(substitutionBytes, 20, 7).trim())) {
                        Trace.log(4, "Command not found.");
                        return 0;
                    }
                    if (id.equals("CPF9810") && libName.equals(this.converter_.byteArrayToString(substitutionBytes).trim())) {
                        Trace.log(4, "Command library not found.");
                        return 0;
                    }
                    throw new AS400Exception(this.messageList_);
                }
            }
        }
        catch (ObjectDoesNotExistException e) {
            Trace.log(2, "Unexpected ObjectDoesNotExistException:", (Throwable)e);
            throw new InternalErrorException(10);
        }
        byte[] dataReceived = parameterList[0].getOutputData();
        if (Trace.traceOn_) {
            Trace.log(1, "Command information retrieved:", dataReceived);
            Trace.log(1, "Multithreaded job action: " + (dataReceived[334] & 0xF));
        }
        int fieldValue = dataReceived[333] & 0xF;
        switch (fieldValue) {
            case 0: {
                threadsafeIndicator = 0;
                break;
            }
            case 1: {
                threadsafeIndicator = 1;
                break;
            }
            case 2: {
                threadsafeIndicator = 2;
                break;
            }
            default: {
                threadsafeIndicator = 0;
                if (!Trace.traceOn_) break;
                Trace.log(4, "Unrecognized threadsafe indicator value reported by QCDRCMDI:", fieldValue);
            }
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Threadsafe indicator:", threadsafeIndicator);
        }
        return threadsafeIndicator;
    }

    protected void open(Boolean threadSafety) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        this.openOffThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void openOffThread() throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        if (Trace.traceOn_) {
            Trace.log(1, "Remote implementation object open.");
        }
        AS400Server aS400Server = this.server_ = this.system_.getConnection(2, false, false);
        synchronized (aS400Server) {
            DataStream baseReply = this.server_.getExchangeAttrReply();
            if (baseReply == null) {
                try {
                    baseReply = this.server_.sendExchangeAttrRequest(new RCExchangeAttributesRequestDataStream(this.system_.getNLV()));
                }
                catch (IOException e) {
                    Trace.log(2, "IOException during exchange attributes:", (Throwable)e);
                    this.disconnectServer();
                    throw e;
                }
                if (!(baseReply instanceof RCExchangeAttributesReplyDataStream)) {
                    Trace.log(2, "Unknown exchange attributes reply datastream:", baseReply.data_);
                    this.disconnectServer();
                    throw new InternalErrorException(2);
                }
                this.processReturnCode(((RCExchangeAttributesReplyDataStream)baseReply).getRC());
            }
            RCExchangeAttributesReplyDataStream reply = (RCExchangeAttributesReplyDataStream)baseReply;
            if (!this.ccsidIsUserOveride_) {
                this.converter_ = ConverterImplRemote.getConverter(reply.getCCSID(), this.system_);
            }
            this.serverDataStreamLevel_ = reply.getDSLevel();
            if (this.serverDataStreamLevel_ >= 10) {
                this.unicodeConverter_ = ConverterImplRemote.getConverter(1200, this.system_);
            }
        }
    }

    protected void openOnThread() throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        this.openOffThread();
    }

    @Override
    public boolean runCommand(String command) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        return this.runCommandOffThread(command, 0);
    }

    @Override
    public boolean runCommand(String command, Boolean threadSafety, int messageOption) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        return this.runCommandOffThread(command, messageOption);
    }

    protected boolean runCommandOffThread(String command, int messageOption) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        if (Trace.traceOn_) {
            Trace.log(3, "Remote implementation running command: " + command);
            Trace.log(1, "Running command OFF-THREAD: " + command);
        }
        this.openOffThread();
        if (this.serverDataStreamLevel_ >= 10) {
            return this.runCommandOffThread(this.unicodeConverter_.stringToByteArray(command), messageOption, 1200);
        }
        command = AS400BidiTransform.SQL_statement_reordering(command, this.system_.getBidiStringType(), this.converter_.table_.bidiStringType_);
        return this.runCommandOffThread(this.converter_.stringToByteArray(command, new BidiConversionProperties(this.converter_.table_.bidiStringType_)), messageOption, 0);
    }

    @Override
    public boolean runCommand(byte[] commandAsBytes, String commandAsString) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        if (Trace.traceOn_) {
            Trace.log(3, "Remote implementation running command: " + commandAsString);
        }
        return this.runCommandOffThread(commandAsBytes, 0, 0);
    }

    @Override
    public boolean runCommand(byte[] command, Boolean threadSafety, int messageOption) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        return this.runCommandOffThread(command, messageOption, 0);
    }

    protected boolean runCommandOffThread(byte[] command, int messageOption, int ccsid) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        if (ON_THREAD.equals(this.priorCallWasOnThread_) && Trace.traceOn_) {
            Trace.log(1, "Prior call was on-thread, but this call is off-thread, so different job.");
        }
        this.priorCallWasOnThread_ = OFF_THREAD;
        this.openOffThread();
        try {
            DataStream baseReply = this.server_.sendAndReceive(new RCRunCommandRequestDataStream(command, this.serverDataStreamLevel_, messageOption, ccsid));
            if (!(baseReply instanceof RCRunCommandReplyDataStream)) {
                Trace.log(2, "Unknown run command reply datastream:", baseReply.data_);
                this.disconnectServer();
                throw new InternalErrorException(2);
            }
            RCRunCommandReplyDataStream reply = (RCRunCommandReplyDataStream)baseReply;
            this.messageList_ = reply.getMessageList(this.converter_);
            int rc = reply.getRC();
            this.processReturnCode(rc);
            return rc == 0;
        }
        catch (IOException e) {
            Trace.log(2, "Lost connection to remote command server:", (Throwable)e);
            this.disconnectServer();
            throw e;
        }
    }

    @Override
    public boolean runProgram(String library, String name, ProgramParameter[] parameterList) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        return this.runProgramOffThread(library, name, parameterList, 0);
    }

    @Override
    public boolean runProgram(String library, String name, ProgramParameter[] parameterList, Boolean threadSafety) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        return this.runProgramOffThread(library, name, parameterList, 0);
    }

    @Override
    public boolean runProgram(String library, String name, ProgramParameter[] parameterList, Boolean threadSafety, int messageOption) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        return this.runProgramOffThread(library, name, parameterList, messageOption);
    }

    protected boolean runProgramOnThread(String library, String name, ProgramParameter[] parameterList, int messageOption, boolean currentlyOpeningOnThisThread) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        return this.runProgramOffThread(library, name, parameterList, messageOption);
    }

    protected boolean runProgramOffThread(String library, String name, ProgramParameter[] parameterList, int messageOption) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(3, "Remote implementation running program: " + library + "/" + name);
            Trace.log(1, "Running program OFF-THREAD: " + library + "/" + name);
        }
        if (ON_THREAD.equals(this.priorCallWasOnThread_) && Trace.traceOn_) {
            Trace.log(1, "Prior call was on-thread, but this call is off-thread, so different job.");
        }
        this.priorCallWasOnThread_ = OFF_THREAD;
        this.openOffThread();
        try {
            String id;
            DataStream baseReply = this.server_.sendAndReceive(new RCCallProgramRequestDataStream(library, name, parameterList, this.converter_, this.serverDataStreamLevel_, messageOption));
            if (!(baseReply instanceof RCCallProgramReplyDataStream)) {
                Trace.log(2, "Unknown run program reply datastream ", baseReply.data_);
                this.disconnectServer();
                throw new InternalErrorException(2);
            }
            RCCallProgramReplyDataStream reply = (RCCallProgramReplyDataStream)baseReply;
            int rc = reply.getRC();
            this.processReturnCode(rc);
            if (rc == 0) {
                reply.getParameterList(parameterList);
                this.messageList_ = new AS400Message[0];
                return true;
            }
            this.messageList_ = reply.getMessageList(this.converter_);
            if (rc == 1280 && this.messageList_.length != 0 && (id = this.messageList_[this.messageList_.length - 1].getID()).equals("MCH3401")) {
                byte[] substitutionBytes = this.messageList_[this.messageList_.length - 1].getSubstitutionData();
                if (substitutionBytes[0] == 2 && substitutionBytes[1] == 1 && name.equals(this.converter_.byteArrayToString(substitutionBytes, 2, 30).trim())) {
                    throw new ObjectDoesNotExistException(QSYSObjectPathName.toPath(library, name, "PGM"), 2);
                }
                if (substitutionBytes[0] == 4 && substitutionBytes[1] == 1 && library.equals(this.converter_.byteArrayToString(substitutionBytes, 2, 30).trim())) {
                    throw new ObjectDoesNotExistException(QSYSObjectPathName.toPath(library, name, "PGM"), 1);
                }
            }
            return false;
        }
        catch (IOException e) {
            Trace.log(2, "Lost connection to remote command server:", (Throwable)e);
            this.disconnectServer();
            throw e;
        }
    }

    @Override
    public byte[] runServiceProgram(String library, String name, String procedureName, ProgramParameter[] serviceParameterList) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        return this.runServiceProgram(library, name, procedureName, 3, serviceParameterList, ProgramCall.getDefaultThreadSafety(), 37, 0, false);
    }

    @Override
    public byte[] runServiceProgram(String library, String name, String procedureName, int returnValueFormat, ProgramParameter[] serviceParameterList, Boolean threadSafety, int procedureNameCCSID, int messageOption, boolean alignOn16Bytes) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        int returnValueParmLength;
        if (Trace.traceOn_) {
            Trace.log(3, "Remote implementation running service program: " + library + "/" + name + " procedure name: " + procedureName);
        }
        this.open(threadSafety);
        ProgramParameter[] programParameterList = new ProgramParameter[7 + serviceParameterList.length];
        byte[] serviceProgramBytes = new byte[20];
        for (int i = 0; i < 20; ++i) {
            serviceProgramBytes[i] = 64;
        }
        this.converter_.stringToByteArray(name, serviceProgramBytes, 0);
        this.converter_.stringToByteArray(library, serviceProgramBytes, 10);
        programParameterList[0] = new ProgramParameter(serviceProgramBytes);
        ConverterImplRemote procedureNameConverter = ConverterImplRemote.getConverter(procedureNameCCSID, this.system_);
        byte[] procedureNameBytesUnterminated = procedureNameConverter.stringToByteArray(procedureName);
        byte[] procedureNameBytes = new byte[procedureNameBytesUnterminated.length + 1];
        System.arraycopy(procedureNameBytesUnterminated, 0, procedureNameBytes, 0, procedureNameBytesUnterminated.length);
        programParameterList[1] = new ProgramParameter(procedureNameBytes);
        byte[] returnValueFormatBytes = new byte[4];
        BinaryConverter.intToByteArray(returnValueFormat, returnValueFormatBytes, 0);
        programParameterList[2] = new ProgramParameter(returnValueFormatBytes);
        byte[] parameterFormatBytes = new byte[serviceParameterList.length * 4];
        for (int i = 0; i < serviceParameterList.length; ++i) {
            int parameterType = serviceParameterList[i].getParameterType();
            if (this.serverDataStreamLevel_ < 6 && serviceParameterList[i].getUsage() == 255) {
                parameterType = 1;
            }
            BinaryConverter.intToByteArray(parameterType, parameterFormatBytes, i * 4);
        }
        programParameterList[3] = new ProgramParameter(parameterFormatBytes);
        byte[] parameterNumberBytes = new byte[4];
        BinaryConverter.intToByteArray(serviceParameterList.length, parameterNumberBytes, 0);
        programParameterList[4] = new ProgramParameter(parameterNumberBytes);
        int errorCodeParmLength = 8;
        int n = returnValueParmLength = returnValueFormat == 0 ? 4 : 8;
        if (alignOn16Bytes && serviceParameterList.length != 0) {
            int parmsByteCount = 0;
            parmsByteCount += serviceProgramBytes.length;
            parmsByteCount += procedureNameBytes.length;
            parmsByteCount += returnValueFormatBytes.length;
            parmsByteCount += parameterFormatBytes.length;
            parmsByteCount += parameterNumberBytes.length;
            parmsByteCount += errorCodeParmLength;
            int remainder = (parmsByteCount += returnValueParmLength) % 16;
            if (remainder != 0) {
                errorCodeParmLength += 16 - remainder;
                if (Trace.traceOn_) {
                    Trace.log(1, "To achieve 16-byte alignment, padding 'error code' parameter to length " + errorCodeParmLength);
                }
            }
        }
        programParameterList[5] = new ProgramParameter(errorCodeParmLength);
        programParameterList[6] = new ProgramParameter(returnValueParmLength);
        System.arraycopy(serviceParameterList, 0, programParameterList, 7, serviceParameterList.length);
        boolean succeeded = this.runProgram("QSYS", "QZRUCLSP", programParameterList, threadSafety, messageOption);
        if (!succeeded) {
            return null;
        }
        return programParameterList[6].getOutputData();
    }

    private void processReturnCode(int rc) throws ErrorCompletingRequestException {
        if (Trace.traceOn_) {
            byte[] rcBytes = new byte[2];
            BinaryConverter.unsignedShortToByteArray(rc, rcBytes, 0);
            Trace.log(1, "Remote command server return code:", rcBytes);
        }
        switch (rc) {
            case 0: {
                if (Trace.traceOn_) {
                    Trace.log(3, "Request processed successfully.");
                }
                return;
            }
            case 256: {
                if (Trace.traceOn_) {
                    Trace.log(4, "Limited user.");
                }
                return;
            }
            case 257: {
                Trace.log(2, "Exchange attributes request not valid.");
                this.disconnectServer();
                throw new InternalErrorException(5);
            }
            case 258: {
                Trace.log(2, "Datastream level not valid.");
                this.disconnectServer();
                throw new InternalErrorException(1);
            }
            case 259: {
                Trace.log(2, "Version not valid.");
                this.disconnectServer();
                throw new InternalErrorException(7);
            }
            case 260: {
                if (Trace.traceOn_) {
                    Trace.log(4, "CCSID not valid.");
                }
                return;
            }
            case 261: {
                if (Trace.traceOn_) {
                    Trace.log(4, "NLV not valid");
                }
                return;
            }
            case 262: {
                if (Trace.traceOn_) {
                    Trace.log(4, "NLV not installed.");
                }
                return;
            }
            case 263: {
                if (Trace.traceOn_) {
                    Trace.log(4, "Error retrieving product information, cannot validate NLV.");
                }
                return;
            }
            case 264: {
                if (Trace.traceOn_) {
                    Trace.log(4, "Error adding NLV library to system library list.");
                }
                return;
            }
            case 512: 
            case 513: 
            case 514: 
            case 515: 
            case 517: {
                Trace.log(2, "Datastream not valid.");
                this.disconnectServer();
                throw new InternalErrorException(5);
            }
            case 516: {
                Trace.log(2, "Host Resource error.");
                this.disconnectServer();
                throw new ErrorCompletingRequestException(1);
            }
            case 768: {
                Trace.log(2, "Process exit point error.");
                this.disconnectServer();
                throw new ErrorCompletingRequestException(2);
            }
            case 769: 
            case 770: {
                Trace.log(2, "Request not valid.");
                this.disconnectServer();
                throw new InternalErrorException(5);
            }
            case 771: {
                Trace.log(2, "Maximum exceeded.");
                throw new ErrorCompletingRequestException(9);
            }
            case 772: {
                Trace.log(2, "Error calling exit program.");
                this.disconnectServer();
                throw new ErrorCompletingRequestException(3);
            }
            case 773: {
                Trace.log(2, "Exit program denied request.");
                this.disconnectServer();
                throw new ErrorCompletingRequestException(4);
            }
            case 1024: {
                if (Trace.traceOn_) {
                    Trace.log(3, "Error calling the command.");
                }
                return;
            }
            case 1025: {
                Trace.log(2, "CCSID not valid.");
                throw new InternalErrorException(5);
            }
            case 1280: {
                if (Trace.traceOn_) {
                    Trace.log(2, "Could not resolve program.");
                }
                return;
            }
            case 1281: {
                if (Trace.traceOn_) {
                    Trace.log(1, "Error calling the program.");
                }
                return;
            }
        }
        Trace.log(2, "Return code unknown.");
        this.disconnectServer();
        throw new InternalErrorException(9);
    }

    private void disconnectServer() {
        block2: {
            try {
                this.system_.disconnectServer(this.server_);
            }
            catch (Throwable e) {
                if (!Trace.traceOn_) break block2;
                Trace.log(1, "Exception while attempting to disconnect the server:", e);
            }
        }
    }

    static AS400Message[] parseMessages(byte[] data, ConverterImplRemote converter) throws IOException {
        int messageNumber = BinaryConverter.byteArrayToUnsignedShort(data, 22);
        AS400Message[] messageList = new AS400Message[messageNumber];
        int offset = 24;
        for (int i = 0; i < messageNumber; ++i) {
            if (data[offset + 5] == 6) {
                messageList[i] = AS400ImplRemote.parseMessage(data, offset + 6, converter);
            } else if (data[offset + 5] == 7) {
                int mark = offset;
                AS400Message message = new AS400Message();
                int messageSeverityLength = BinaryConverter.byteArrayToInt(data, offset += 6);
                message.setSeverity(BinaryConverter.byteArrayToInt(data, offset += 4));
                int messageIdLength = BinaryConverter.byteArrayToInt(data, offset += messageSeverityLength);
                message.setID(converter.byteArrayToString(data, offset += 4, messageIdLength));
                int messageTypeLength = BinaryConverter.byteArrayToInt(data, offset += messageIdLength);
                message.setType((data[offset += 4] & 0xF) * 10 + (data[offset + 1] & 0xF));
                int messageKeyLength = BinaryConverter.byteArrayToInt(data, offset += messageTypeLength);
                byte[] messageKey = new byte[messageKeyLength];
                System.arraycopy(data, offset += 4, messageKey, 0, messageKeyLength);
                message.setKey(messageKey);
                int messageFileNameLength = BinaryConverter.byteArrayToInt(data, offset += messageKeyLength);
                message.setFileName(converter.byteArrayToString(data, offset += 4, messageFileNameLength).trim());
                int messageFileLibraryNameLength = BinaryConverter.byteArrayToInt(data, offset += messageFileNameLength);
                message.setMessageFileLibrarySpecified(converter.byteArrayToString(data, offset += 4, messageFileLibraryNameLength).trim());
                int messageFileLibraryUsedLength = BinaryConverter.byteArrayToInt(data, offset += messageFileLibraryNameLength);
                message.setLibraryName(converter.byteArrayToString(data, offset += 4, messageFileLibraryUsedLength).trim());
                int messageSendingJobLength = BinaryConverter.byteArrayToInt(data, offset += messageFileLibraryUsedLength);
                offset += 4;
                int messageSendingJobUsrProfileLength = BinaryConverter.byteArrayToInt(data, offset += messageSendingJobLength);
                offset += 4;
                int messageSendingJobNumberLength = BinaryConverter.byteArrayToInt(data, offset += messageSendingJobUsrProfileLength);
                offset += 4;
                int messageSendingProgramLength = BinaryConverter.byteArrayToInt(data, offset += messageSendingJobNumberLength);
                message.setSendingProgramName(converter.byteArrayToString(data, offset += 4, messageSendingProgramLength).trim());
                int messageSendingProgramInstructionNumberLength = BinaryConverter.byteArrayToInt(data, offset += messageSendingProgramLength);
                message.setSendingProgramInstructionNumber(converter.byteArrayToString(data, offset += 4, messageSendingProgramInstructionNumberLength).trim());
                int messageDataSentLenght = BinaryConverter.byteArrayToInt(data, offset += messageSendingProgramInstructionNumberLength);
                String dateSent = converter.byteArrayToString(data, offset += 4, messageDataSentLenght).trim();
                int messageTimeSentLength = BinaryConverter.byteArrayToInt(data, offset += messageDataSentLenght);
                String timeSent = converter.byteArrayToString(data, offset += 4, messageTimeSentLength).trim();
                message.setDate(dateSent, timeSent);
                int messageReceivingProgramLength = BinaryConverter.byteArrayToInt(data, offset += messageTimeSentLength);
                message.setReceivingProgramName(converter.byteArrayToString(data, offset += 4, messageReceivingProgramLength).trim());
                int messageReceivingProgramInstructionNumberLength = BinaryConverter.byteArrayToInt(data, offset += messageReceivingProgramLength);
                message.setReceivingProgramInstructionNumber(converter.byteArrayToString(data, offset += 4, messageReceivingProgramInstructionNumberLength).trim());
                int messageSendingTypeLength = BinaryConverter.byteArrayToInt(data, offset += messageReceivingProgramInstructionNumberLength);
                message.setSendingType(converter.byteArrayToString(data, offset += 4, messageSendingTypeLength).trim());
                int messageReceivingTypeLength = BinaryConverter.byteArrayToInt(data, offset += messageSendingTypeLength);
                message.setReceivingType(converter.byteArrayToString(data, offset += 4, messageReceivingTypeLength).trim());
                int textCCSIDLength = BinaryConverter.byteArrayToInt(data, offset += messageReceivingTypeLength);
                message.setTextCcsidConversionStatusIndicator(BinaryConverter.byteArrayToInt(data, offset += 4));
                int dataCCSIDLength = BinaryConverter.byteArrayToInt(data, offset += 4);
                message.setDataCcsidConversionStatusIndicator(BinaryConverter.byteArrayToInt(data, offset += 4));
                int messageAlertOptionLength = BinaryConverter.byteArrayToInt(data, offset += 4);
                message.setAlertOption(converter.byteArrayToString(data, offset += 4, messageAlertOptionLength).trim());
                int messageAndMessageHelpCCSIDLength = BinaryConverter.byteArrayToInt(data, offset += messageAlertOptionLength);
                message.setTextCcsid(BinaryConverter.byteArrayToInt(data, offset += 4));
                int messageReplacementDataOrImpromptuTextCCSIDLength = BinaryConverter.byteArrayToInt(data, offset += 4);
                int messageReplacementDataOrImpromptuTextCCSID = BinaryConverter.byteArrayToInt(data, offset += 4);
                message.setSubstitutionDataCcsid(messageReplacementDataOrImpromptuTextCCSID);
                int messageReplacementDataOrImpromptuTextLength = BinaryConverter.byteArrayToInt(data, offset += 4);
                byte[] substitutionData = new byte[messageReplacementDataOrImpromptuTextLength];
                System.arraycopy(data, offset += 4, substitutionData, 0, messageReplacementDataOrImpromptuTextLength);
                message.setSubstitutionData(substitutionData);
                int messageLength = BinaryConverter.byteArrayToInt(data, offset += messageReplacementDataOrImpromptuTextLength);
                message.setText(converter.byteArrayToString(data, offset += 4, messageLength));
                int messageHelpLength = BinaryConverter.byteArrayToInt(data, offset += messageLength);
                message.setHelp(converter.byteArrayToString(data, offset += 4, messageHelpLength).trim());
                offset += messageHelpLength;
                messageList[i] = message;
                offset = mark;
            } else {
                messageList[i] = new AS400Message();
                messageList[i].setID(converter.byteArrayToString(data, offset + 6, 7));
                messageList[i].setType((data[offset + 13] & 0xF) * 10 + (data[offset + 14] & 0xF));
                messageList[i].setSeverity(BinaryConverter.byteArrayToUnsignedShort(data, offset + 15));
                messageList[i].setFileName(converter.byteArrayToString(data, offset + 17, 10).trim());
                messageList[i].setLibraryName(converter.byteArrayToString(data, offset + 27, 10).trim());
                int substitutionDataLength = BinaryConverter.byteArrayToUnsignedShort(data, offset + 37);
                int textLength = BinaryConverter.byteArrayToUnsignedShort(data, offset + 39);
                byte[] substitutionData = new byte[substitutionDataLength];
                System.arraycopy(data, offset + 41, substitutionData, 0, substitutionDataLength);
                messageList[i].setSubstitutionData(substitutionData);
                messageList[i].setSubstitutionDataCcsid(converter.getCcsid());
                messageList[i].setText(converter.byteArrayToString(data, offset + 41 + substitutionDataLength, textLength));
                messageList[i].setTextCcsid(converter.getCcsid());
            }
            offset += BinaryConverter.byteArrayToInt(data, offset);
        }
        return messageList;
    }

    static {
        if (Trace.traceOn_) {
            Trace.logLoadPath(CLASSNAME);
        }
        AS400Server.addReplyStream((DataStream)new RCExchangeAttributesReplyDataStream(), 2);
        AS400Server.addReplyStream((DataStream)new RCRunCommandReplyDataStream(), 2);
        AS400Server.addReplyStream((DataStream)new RCCallProgramReplyDataStream(), 2);
        AS400Server.addReplyStream((DataStream)new RCCallProgramFailureReplyDataStream(), 2);
    }
}

