/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.proto;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ReservationName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_RESERVATION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/reservations/{reservation}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String reservation;

    @Deprecated
    protected ReservationName() {
        this.project = null;
        this.location = null;
        this.reservation = null;
    }

    private ReservationName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.reservation = (String)Preconditions.checkNotNull((Object)builder.getReservation());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getReservation() {
        return this.reservation;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ReservationName of(String project, String location, String reservation) {
        return ReservationName.newBuilder().setProject(project).setLocation(location).setReservation(reservation).build();
    }

    public static String format(String project, String location, String reservation) {
        return ReservationName.newBuilder().setProject(project).setLocation(location).setReservation(reservation).build().toString();
    }

    public static ReservationName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_RESERVATION.validatedMatch(formattedString, "ReservationName.parse: formattedString not in valid format");
        return ReservationName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("reservation"));
    }

    public static List<ReservationName> parseList(List<String> formattedStrings) {
        ArrayList<ReservationName> list = new ArrayList<ReservationName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ReservationName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ReservationName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ReservationName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_RESERVATION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ReservationName reservationName = this;
            synchronized (reservationName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.reservation != null) {
                        fieldMapBuilder.put((Object)"reservation", (Object)this.reservation);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_RESERVATION.instantiate(new String[]{"project", this.project, "location", this.location, "reservation", this.reservation});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ReservationName that = (ReservationName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.reservation, that.reservation);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.reservation);
    }

    public static class Builder {
        private String project;
        private String location;
        private String reservation;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getReservation() {
            return this.reservation;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setReservation(String reservation) {
            this.reservation = reservation;
            return this;
        }

        private Builder(ReservationName reservationName) {
            this.project = reservationName.project;
            this.location = reservationName.location;
            this.reservation = reservationName.reservation;
        }

        public ReservationName build() {
            return new ReservationName(this);
        }
    }
}

