/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.annotation;

import org.springframework.context.annotation.AdviceMode;
import org.springframework.context.annotation.AdviceModeImportSelector;
import org.springframework.context.annotation.AutoProxyRegistrar;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.transaction.annotation.ProxyTransactionManagementConfiguration;
import org.springframework.util.ClassUtils;

public class TransactionManagementConfigurationSelector
extends AdviceModeImportSelector<EnableTransactionManagement> {
    @Override
    protected String[] selectImports(AdviceMode adviceMode) {
        String[] stringArray;
        switch (adviceMode) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case PROXY: {
                String[] stringArray2 = new String[2];
                stringArray2[0] = AutoProxyRegistrar.class.getName();
                stringArray = stringArray2;
                stringArray2[1] = ProxyTransactionManagementConfiguration.class.getName();
                break;
            }
            case ASPECTJ: {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = this.determineTransactionAspectClass();
            }
        }
        return stringArray;
    }

    private String determineTransactionAspectClass() {
        return ClassUtils.isPresent("jakarta.transaction.Transactional", this.getClass().getClassLoader()) ? "org.springframework.transaction.aspectj.AspectJJtaTransactionManagementConfiguration" : "org.springframework.transaction.aspectj.AspectJTransactionManagementConfiguration";
    }
}

