/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.timestamp;

import java.util.Date;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.grails.datastore.gorm.timestamp.TimestampProvider;
import org.springframework.util.ClassUtils;

public class DefaultTimestampProvider
implements TimestampProvider {
    protected long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    @Override
    public boolean supportsCreating(Class<?> dateTimeClass) {
        return true;
    }

    @Override
    public <T> T createTimestamp(Class<T> dateTimeClass) {
        long timestampMillis = this.currentTimeMillis();
        if (dateTimeClass == String.class) {
            return (T)String.valueOf(timestampMillis);
        }
        Class actualDateTimeClass = dateTimeClass == Object.class ? Date.class : ClassUtils.resolvePrimitiveIfNecessary(dateTimeClass);
        try {
            return (T)DefaultGroovyMethods.newInstance(actualDateTimeClass, new Object[]{timestampMillis});
        }
        catch (Exception e) {
            return (T)DefaultGroovyMethods.invokeMethod(actualDateTimeClass, "now", null);
        }
    }
}

