/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.core.dsom;

import com.ibm.icu.impl.UnicodeRegex;
import java.io.Serializable;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.daffodil.core.dsom.AnnotatedSchemaComponent;
import org.apache.daffodil.core.dsom.DFDLStatement;
import org.apache.daffodil.core.dsom.Term;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.iapi.WarnID;
import org.apache.daffodil.lib.iapi.WarnID$PatternEncodingSlashW$;
import org.apache.daffodil.lib.schema.annotation.props.gen.FailureType;
import org.apache.daffodil.lib.schema.annotation.props.gen.FailureType$;
import org.apache.daffodil.lib.schema.annotation.props.gen.FailureType$ProcessingError$;
import org.apache.daffodil.lib.schema.annotation.props.gen.TestKind;
import org.apache.daffodil.lib.schema.annotation.props.gen.TestKind$;
import org.apache.daffodil.lib.schema.annotation.props.gen.TestKind$Expression$;
import org.apache.daffodil.lib.schema.annotation.props.gen.TestKind$Pattern$;
import org.apache.daffodil.runtime1.processors.EncodingRuntimeData;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.Tuple4;
import scala.Tuple4$;
import scala.collection.Seq;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.xml.Node;
import scala.xml.NodeSeq$;

public abstract class DFDLAssertionBase
extends DFDLStatement {
    public static final long OFFSET$6 = LazyVals$.MODULE$.getOffsetStatic(DFDLAssertionBase.class.getDeclaredField("testTxt$lzy1"));
    public static final long OFFSET$5 = LazyVals$.MODULE$.getOffsetStatic(DFDLAssertionBase.class.getDeclaredField("messageAttrib$lzy1"));
    public static final long OFFSET$4 = LazyVals$.MODULE$.getOffsetStatic(DFDLAssertionBase.class.getDeclaredField("failureType$lzy1"));
    public static final long OFFSET$3 = LazyVals$.MODULE$.getOffsetStatic(DFDLAssertionBase.class.getDeclaredField("testKind$lzy1"));
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(DFDLAssertionBase.class.getDeclaredField("testPattern$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(DFDLAssertionBase.class.getDeclaredField("testBody$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(DFDLAssertionBase.class.getDeclaredField("testAttrib$lzy1"));
    private final Node node;
    private final AnnotatedSchemaComponent decl;
    private volatile Object testAttrib$lzy1;
    private volatile Object testBody$lzy1;
    private volatile Object testPattern$lzy1;
    private volatile Object testKind$lzy1;
    private volatile Object failureType$lzy1;
    private volatile Object messageAttrib$lzy1;
    private volatile Object testTxt$lzy1;

    public DFDLAssertionBase(Node node, AnnotatedSchemaComponent decl) {
        this.node = node;
        this.decl = decl;
        super(node, decl);
    }

    @Override
    public void check(Term term) {
        this.checkPattern(term);
    }

    private Option<String> testAttrib() {
        Object object = this.testAttrib$lzy1;
        if (object instanceof Option) {
            return (Option)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Option)this.testAttrib$lzyINIT1();
    }

    private Object testAttrib$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.testAttrib$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Option option = null;
                    try {
                        option = this.getAttributeOption("test");
                        object2 = option == null ? LazyVals.NullValue$.MODULE$ : option;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.testAttrib$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return option;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Option<String> testBody() {
        Object object = this.testBody$lzy1;
        if (object instanceof Option) {
            return (Option)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Option)this.testBody$lzyINIT1();
    }

    private Object testBody$lzyINIT1() {
        Object object;
        block9: {
            while (true) {
                if ((object = this.testBody$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    None$ none$ = null;
                    try {
                        String string;
                        String s = string = NodeSeq$.MODULE$.seqToNodeSeq((Seq)this.node.child()).text();
                        if (s.trim().length() == 0) {
                            v0 = None$.MODULE$;
                        } else {
                            String txt = string;
                            v0 = none$ = Some$.MODULE$.apply((Object)txt.trim());
                        }
                        object2 = none$ == null ? LazyVals.NullValue$.MODULE$ : none$;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.testBody$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.testBody$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return none$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block9;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Option<String> testPattern() {
        Object object = this.testPattern$lzy1;
        if (object instanceof Option) {
            return (Option)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Option)this.testPattern$lzyINIT1();
    }

    private Object testPattern$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.testPattern$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Option option = null;
                    try {
                        Option optPattern = this.getAttributeOption("testPattern");
                        optPattern.foreach((Function1 & Serializable)thePattern -> {
                            Pattern pattern;
                            try {
                                UnicodeRegex.compile((String)thePattern);
                                pattern = Pattern.compile(thePattern);
                            }
                            catch (PatternSyntaxException e) {
                                throw this.SDE("The pattern contained invalid syntax: %s", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{e.getMessage()}));
                            }
                            return pattern;
                        });
                        option = optPattern;
                        object2 = option == null ? LazyVals.NullValue$.MODULE$ : option;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.testPattern$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return option;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private void checkPattern(Term term) {
        if (this.testPattern().isDefined()) {
            String thePattern = (String)this.testPattern().get();
            boolean hasWord = thePattern.contains("\\w");
            EncodingRuntimeData encInfo = term.termRuntimeData().encodingInfo();
            if (encInfo.knownEncodingIsUnicode() && hasWord) {
                this.SDW((WarnID)WarnID$PatternEncodingSlashW$.MODULE$, "The encoding is '%s' and \\w was detected in the pattern '%s'.  This is not recommended with Unicode encodings.", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{encInfo.knownEncodingName(), thePattern}));
                return;
            }
            return;
        }
    }

    public final TestKind testKind() {
        Object object = this.testKind$lzy1;
        if (object instanceof TestKind) {
            return (TestKind)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (TestKind)this.testKind$lzyINIT1();
    }

    private Object testKind$lzyINIT1() {
        Object object;
        block12: {
            while (true) {
                if ((object = this.testKind$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    TestKind$Expression$ testKind$Expression$ = null;
                    try {
                        TestKind testKind;
                        Option option = this.getAttributeOption("testKind");
                        if (option instanceof Some) {
                            String str = (String)((Some)option).value();
                            testKind = TestKind$.MODULE$.apply(str, this.decl);
                        } else if (None$.MODULE$.equals(option)) {
                            testKind = TestKind$Expression$.MODULE$;
                        } else {
                            throw new MatchError((Object)option);
                        }
                        testKind$Expression$ = testKind;
                        object2 = testKind$Expression$ == null ? LazyVals.NullValue$.MODULE$ : testKind$Expression$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.testKind$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return testKind$Expression$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block12;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public final FailureType failureType() {
        Object object = this.failureType$lzy1;
        if (object instanceof FailureType) {
            return (FailureType)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (FailureType)this.failureType$lzyINIT1();
    }

    private Object failureType$lzyINIT1() {
        Object object;
        block12: {
            while (true) {
                if ((object = this.failureType$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    FailureType$ProcessingError$ failureType$ProcessingError$ = null;
                    try {
                        FailureType failureType;
                        Option option = this.getAttributeOption("failureType");
                        if (option instanceof Some) {
                            String str = (String)((Some)option).value();
                            failureType = FailureType$.MODULE$.apply(str, this.decl);
                        } else if (None$.MODULE$.equals(option)) {
                            failureType = FailureType$ProcessingError$.MODULE$;
                        } else {
                            throw new MatchError((Object)option);
                        }
                        failureType$ProcessingError$ = failureType;
                        object2 = failureType$ProcessingError$ == null ? LazyVals.NullValue$.MODULE$ : failureType$ProcessingError$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.failureType$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return failureType$ProcessingError$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block12;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Option<String> messageAttrib() {
        Object object = this.messageAttrib$lzy1;
        if (object instanceof Option) {
            return (Option)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Option)this.messageAttrib$lzyINIT1();
    }

    private Object messageAttrib$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.messageAttrib$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Option option = null;
                    try {
                        option = this.getAttributeOption("message");
                        object2 = option == null ? LazyVals.NullValue$.MODULE$ : option;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.messageAttrib$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return option;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public final String testTxt() {
        Object object = this.testTxt$lzy1;
        if (object instanceof String) {
            return (String)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (String)this.testTxt$lzyINIT1();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object testTxt$lzyINIT1() {
        while (true) {
            Object object;
            if ((object = this.testTxt$lzy1) == null) {
                void var2_5;
                String string;
                String string2;
                block33: {
                    block32: {
                        Option option;
                        TestKind testKind;
                        block35: {
                            Option option2;
                            Option option3;
                            block37: {
                                block36: {
                                    block34: {
                                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$6, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                                        Object var2_2 = null;
                                        string2 = null;
                                        try {
                                            Tuple4 tuple4 = Tuple4$.MODULE$.apply((Object)this.testKind(), this.testBody(), this.testAttrib(), this.testPattern());
                                            if (tuple4 == null) break block32;
                                            testKind = (TestKind)tuple4._1();
                                            option3 = (Option)tuple4._2();
                                            option2 = (Option)tuple4._3();
                                            option = (Option)tuple4._4();
                                            if (TestKind$Expression$.MODULE$.equals(testKind)) {
                                                if (None$.MODULE$.equals(option3) && option2 instanceof Some) {
                                                    String txt = (String)((Some)option2).value();
                                                    if (None$.MODULE$.equals(option)) {
                                                        string = txt;
                                                        break block33;
                                                    }
                                                }
                                                Option txt = option3;
                                                if (None$.MODULE$.equals(option2) && None$.MODULE$.equals(option)) {
                                                    string = (String)txt.get();
                                                    break block33;
                                                }
                                            }
                                            if (TestKind$Pattern$.MODULE$.equals(testKind)) {
                                                if (option instanceof Some && "".equals(((Some)option).value())) {
                                                    throw this.SDE("The attribute testPattern must not be empty for testKind='pattern'", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
                                                }
                                                if (None$.MODULE$.equals(option3) && None$.MODULE$.equals(option2) && option instanceof Some) {
                                                    String pat;
                                                    string = pat = (String)((Some)option).value();
                                                    break block33;
                                                }
                                            }
                                            if (!TestKind$Expression$.MODULE$.equals(testKind)) break block34;
                                            if (option3 instanceof Some) {
                                                String bdy = (String)((Some)option3).value();
                                                if (option2 instanceof Some) {
                                                    String attrib = (String)((Some)option2).value();
                                                    throw this.SDE("You may not specify both test attribute and a body expression.", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
                                                }
                                            }
                                            if (!None$.MODULE$.equals(option3) || !None$.MODULE$.equals(option2)) break block34;
                                            throw this.SDE("You must specify either a test attribute or a body expression.", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
                                        }
                                        catch (Throwable throwable) {
                                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$6, (Object)LazyVals.Evaluating$.MODULE$, var2_2)) {
                                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.testTxt$lzy1;
                                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$6, (Object)waiting, var2_2);
                                                waiting.countDown();
                                            }
                                            throw throwable;
                                        }
                                    }
                                    if (!TestKind$Pattern$.MODULE$.equals(testKind)) break block35;
                                    if (!(option3 instanceof Some)) break block36;
                                    String bdy = (String)((Some)option3).value();
                                    if (!(option instanceof Some)) break block36;
                                    String txt = (String)((Some)option).value();
                                    throw this.SDE("You may not specify both testPattern attribute and a body expression.", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
                                }
                                if (!None$.MODULE$.equals(option3) || !None$.MODULE$.equals(option)) break block37;
                                throw this.SDE("You must specify either a testPattern attribute or a body expression. for testKind='pattern'", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
                            }
                            if (option3 instanceof Some) {
                                String bdy = (String)((Some)option3).value();
                                if (None$.MODULE$.equals(option2) && None$.MODULE$.equals(option)) {
                                    string = bdy;
                                    break block33;
                                }
                            }
                            if (!(option2 instanceof Some)) break block35;
                            String tst = (String)((Some)option2).value();
                            throw this.SDE("You cannot specify test='%s' for testKind='pattern'", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{tst}));
                        }
                        if (!TestKind$Expression$.MODULE$.equals(testKind) || !(option instanceof Some)) break block32;
                        String pat = (String)((Some)option).value();
                        throw this.SDE("You cannot specify testPattern='%s' for testKind='expression' (which is the default test kind.)", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{pat}));
                    }
                    throw Assert$.MODULE$.invariantFailed("unexpected case.");
                }
                String rawTxt = string;
                TestKind testKind = this.testKind();
                TestKind$Expression$ testKind$Expression$ = TestKind$Expression$.MODULE$;
                if (!(testKind != null ? !testKind.equals(testKind$Expression$) : testKind$Expression$ != null)) {
                    boolean testThatWillThrowIfFalse$proxy1;
                    DFDLAssertionBase SDEUsingMacrosMixin_this = this;
                    boolean bl = testThatWillThrowIfFalse$proxy1 = rawTxt.startsWith("{") && !rawTxt.startsWith("{{") && rawTxt.endsWith("}");
                    if (!testThatWillThrowIfFalse$proxy1) {
                        throw SDEUsingMacrosMixin_this.SDE("Expression must begin with a single '{' and end with a '}'", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
                    }
                }
                if ((string2 = rawTxt) == null) {
                    LazyVals.NullValue$ nullValue$ = LazyVals.NullValue$.MODULE$;
                } else {
                    String string3 = string2;
                }
                if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$6, (Object)LazyVals.Evaluating$.MODULE$, (Object)var2_5)) {
                    LazyVals.Waiting waiting = (LazyVals.Waiting)this.testTxt$lzy1;
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$6, (Object)waiting, (Object)var2_5);
                    waiting.countDown();
                }
                return string2;
            }
            if (!(object instanceof LazyVals.LazyValControlState)) {
                return object;
            }
            if (object == LazyVals.Evaluating$.MODULE$) {
                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$6, object, (Object)new LazyVals.Waiting());
                continue;
            }
            if (!(object instanceof LazyVals.Waiting)) {
                return null;
            }
            ((LazyVals.Waiting)object).await();
        }
    }
}

