/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.support.hierarchical;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.junit.platform.commons.util.CollectionUtils;
import org.junit.platform.engine.support.hierarchical.CompositeLock;
import org.junit.platform.engine.support.hierarchical.ExclusiveResource;
import org.junit.platform.engine.support.hierarchical.NopLock;
import org.junit.platform.engine.support.hierarchical.ResourceLock;
import org.junit.platform.engine.support.hierarchical.SingleLock;

class LockManager {
    private final Map<String, ReadWriteLock> locksByKey = new ConcurrentHashMap<String, ReadWriteLock>();
    private final SingleLock globalReadLock = new SingleLock(ExclusiveResource.GLOBAL_READ, this.toLock(ExclusiveResource.GLOBAL_READ));
    private final SingleLock globalReadWriteLock = new SingleLock(ExclusiveResource.GLOBAL_READ_WRITE, this.toLock(ExclusiveResource.GLOBAL_READ_WRITE));

    ResourceLock getLockForResources(Collection<ExclusiveResource> resources) {
        return this.toResourceLock(this.toDistinctSortedResources(resources));
    }

    ResourceLock getLockForResource(ExclusiveResource resource) {
        return this.toResourceLock(Collections.singletonList(resource));
    }

    private List<ExclusiveResource> toDistinctSortedResources(Collection<ExclusiveResource> resources) {
        if (resources.isEmpty()) {
            return Collections.emptyList();
        }
        if (resources.size() == 1) {
            return Collections.singletonList(CollectionUtils.getOnlyElement(resources));
        }
        Map resourcesByKey = resources.stream().sorted(ExclusiveResource.COMPARATOR).distinct().collect(Collectors.groupingBy(ExclusiveResource::getKey, LinkedHashMap::new, Collectors.toList()));
        return resourcesByKey.values().stream().map(resourcesWithSameKey -> (ExclusiveResource)resourcesWithSameKey.get(0)).collect(CollectionUtils.toUnmodifiableList());
    }

    private ResourceLock toResourceLock(List<ExclusiveResource> resources) {
        switch (resources.size()) {
            case 0: {
                return NopLock.INSTANCE;
            }
            case 1: {
                return this.toSingleLock(CollectionUtils.getOnlyElement(resources));
            }
        }
        return new CompositeLock(resources, this.toLocks(resources));
    }

    private SingleLock toSingleLock(ExclusiveResource resource) {
        if (ExclusiveResource.GLOBAL_READ.equals(resource)) {
            return this.globalReadLock;
        }
        if (ExclusiveResource.GLOBAL_READ_WRITE.equals(resource)) {
            return this.globalReadWriteLock;
        }
        return new SingleLock(resource, this.toLock(resource));
    }

    private List<Lock> toLocks(List<ExclusiveResource> resources) {
        return resources.stream().map(this::toLock).collect(CollectionUtils.toUnmodifiableList());
    }

    private Lock toLock(ExclusiveResource resource) {
        ReadWriteLock lock = this.locksByKey.computeIfAbsent(resource.getKey(), key -> new ReentrantReadWriteLock());
        return resource.getLockMode() == ExclusiveResource.LockMode.READ ? lock.readLock() : lock.writeLock();
    }
}

