/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.function;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.LangAssertions;
import org.apache.commons.lang3.exception.UncheckedException;
import org.apache.commons.lang3.function.AnnotationTestFixture;
import org.apache.commons.lang3.function.MethodFixtures;
import org.apache.commons.lang3.function.MethodInvokers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class MethodInvokersFailableFunctionTest
extends MethodFixtures {
    MethodInvokersFailableFunctionTest() {
    }

    @Test
    void testApply0Arg() throws Throwable {
        Assertions.assertEquals((Object)INSTANCE.getString(), (Object)MethodInvokers.asFailableFunction((Method)MethodInvokersFailableFunctionTest.getMethodForGetString()).apply((Object)INSTANCE));
    }

    @Test
    void testBuildVarArg() throws SecurityException, NoSuchMethodException {
        MethodInvokers.asFailableFunction((Method)MethodInvokersFailableFunctionTest.getMethodForGetStringVarStringArgs());
    }

    @Test
    void testConstructorForNull() throws SecurityException {
        LangAssertions.assertNullPointerException(() -> MethodInvokers.asFailableFunction((Method)null));
    }

    @Test
    void testFindAndInvoke() throws SecurityException {
        List invokers = Stream.of(MethodFixtures.class.getDeclaredMethods()).filter(m -> m.isAnnotationPresent(AnnotationTestFixture.class)).map(MethodInvokers::asFailableFunction).collect(Collectors.toList());
        Assertions.assertEquals((int)2, (int)invokers.size());
        Set set = invokers.stream().map(i -> {
            try {
                return i.apply((Object)MethodFixtures.INSTANCE);
            }
            catch (Throwable e) {
                throw new UncheckedException(e);
            }
        }).collect(Collectors.toSet());
        Assertions.assertEquals(new HashSet<String>(Arrays.asList(INSTANCE.getString(), INSTANCE.getString2())), set);
    }

    @Test
    void testThrowsChecked() throws Exception {
        Assertions.assertThrows(Exception.class, () -> MethodInvokers.asFailableFunction((Method)MethodInvokersFailableFunctionTest.getMethodForGetStringThrowsChecked()).apply((Object)INSTANCE));
    }

    @Test
    void testToString() throws SecurityException, ReflectiveOperationException {
        Assertions.assertFalse((boolean)MethodInvokers.asFailableFunction((Method)MethodInvokersFailableFunctionTest.getMethodForGetString()).toString().isEmpty());
    }
}

