<!--
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
-->

# Contributor Documentation

This directory contains documentation for contributors to the Apache Beam project.

## Table of Contents

- [Code Change Guide](code-change-guide.md): A guide for Beam users and developers on how to change, test, and build Beam code, including setting up Java and Python development environments.
- [Committer Guide](committer-guide.md): Guidelines for Beam committers regarding code review, pull request objectives, merging processes, and post-merge tasks.
- [Committer Onboarding](committer-onboarding.md): A checklist for new Beam committers to set up their accounts and permissions.
- [Java Dependency Upgrades](java-dependency-upgrades.md): Instructions for upgrading Java dependencies in Beam, including running linkage checkers and verification tests.
- [Python Tips](python-tips.md): Tips and instructions for developing the Python SDK, including environment setup, running tests, and handling dependencies.
- [RC Testing Guide](rc-testing-guide.md): A guide for testing Beam Release Candidates (RCs) against downstream projects for Python, Java, and Go SDKs.
- [Release Guide](release-guide.md): A comprehensive guide for the Release Manager on how to perform a Beam release, from preparation to promotion.
- [Updating Supported Python Versions](updating-supported-python-versions.md): Instructions for adding support for new Python versions or removing support for end-of-life versions in Apache Beam.

## Discussion Documents

The [discussion-docs](discussion-docs/) directory contains discussion documents and proposals that have been mailed to the dev@beam.apache.org mailing list, organized by year.

## Confluence Wiki

The [Confluence wiki](https://cwiki.apache.org/confluence/display/BEAM) for Apache Beam contains additional documentation and information for contributors. Some information may be out of date, but is still useful for reference.