/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.kar.shell;

import org.apache.karaf.cellar.core.CellarSupport;
import org.apache.karaf.cellar.core.Group;
import org.apache.karaf.cellar.core.control.SwitchStatus;
import org.apache.karaf.cellar.core.event.Event;
import org.apache.karaf.cellar.core.event.EventProducer;
import org.apache.karaf.cellar.core.event.EventType;
import org.apache.karaf.cellar.core.shell.CellarCommandSupport;
import org.apache.karaf.cellar.kar.ClusterKarEvent;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Command(scope="cluster", name="kar-install", description="Install a KAR in a cluster group")
@Service
public class InstallKarCommand
extends CellarCommandSupport {
    @Argument(index=0, name="group", description="The cluster group name", required=true, multiValued=false)
    String groupName;
    @Argument(index=1, name="url", description="The URL of the KAR file to install on the cluster", required=true, multiValued=false)
    String url;
    @Reference
    private EventProducer eventProducer;

    protected Object doExecute() throws Exception {
        Group group = this.groupManager.findGroupByName(this.groupName);
        if (group == null) {
            System.err.println("Cluster group " + this.groupName + " doesn't exist");
            return null;
        }
        if (this.eventProducer.getSwitch().getStatus().equals((Object)SwitchStatus.OFF)) {
            System.err.println("Cluster event producer is OFF");
            return null;
        }
        CellarSupport support = new CellarSupport();
        support.setConfigurationAdmin(this.configurationAdmin);
        support.setGroupManager(this.groupManager);
        support.setClusterManager(this.clusterManager);
        if (support.isAllowed(group, "kar", this.url, EventType.OUTBOUND).booleanValue()) {
            ClusterKarEvent clusterEvent = new ClusterKarEvent(this.url, true);
            clusterEvent.setSourceGroup(group);
            clusterEvent.setInstall(true);
            this.eventProducer.produce((Event)clusterEvent);
        } else {
            System.err.println("KAR " + this.url + " is blocked outbound for cluster group " + this.groupName);
        }
        return null;
    }

    public EventProducer getEventProducer() {
        return this.eventProducer;
    }

    public void setEventProducer(EventProducer eventProducer) {
        this.eventProducer = eventProducer;
    }
}

