/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.hazelcast;

import com.hazelcast.core.Cluster;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.MapEvent;
import com.hazelcast.core.Member;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.karaf.cellar.core.Group;
import org.apache.karaf.cellar.core.GroupManager;
import org.apache.karaf.cellar.core.Node;
import org.apache.karaf.cellar.core.Synchronizer;
import org.apache.karaf.cellar.core.event.EventConsumer;
import org.apache.karaf.cellar.core.event.EventProducer;
import org.apache.karaf.cellar.core.event.EventTransportFactory;
import org.apache.karaf.cellar.core.utils.CombinedClassLoader;
import org.apache.karaf.cellar.hazelcast.HazelcastNode;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.SynchronousConfigurationListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HazelcastGroupManager
implements GroupManager,
EntryListener<String, Object>,
SynchronousConfigurationListener {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(HazelcastGroupManager.class);
    private static final String HAZELCAST_GROUPS = "org.apache.karaf.cellar.groups";
    private static final String HAZELCAST_GROUPS_CONFIG = "org.apache.karaf.cellar.groups.config";
    private Map<String, ServiceRegistration> producerRegistrations = new HashMap<String, ServiceRegistration>();
    private Map<String, ServiceRegistration> consumerRegistrations = new HashMap<String, ServiceRegistration>();
    private Map<String, Object> localConfig = new HashMap<String, Object>();
    private Map<String, EventProducer> groupProducers = new HashMap<String, EventProducer>();
    private Map<String, EventConsumer> groupConsumer = new HashMap<String, EventConsumer>();
    private BundleContext bundleContext;
    private HazelcastInstance instance;
    private ConfigurationAdmin configurationAdmin;
    private EventTransportFactory eventTransportFactory;
    private CombinedClassLoader combinedClassLoader;

    public void init() {
        try {
            Configuration groupsConfiguration = this.getConfigurationForGroups();
            Hashtable<String, Object> properties = groupsConfiguration.getProperties();
            IMap<String, Object> hazelcastGroupsConfig = this.getClusterGroupsConfig();
            hazelcastGroupsConfig.addEntryListener((EntryListener)this, true);
            if (hazelcastGroupsConfig.isEmpty()) {
                LOGGER.debug("CELLAR HAZELCAST: initialize cluster with local config");
                Map<String, Object> updates = this.getUpdatesForHazelcastMap((Dictionary<String, Object>)properties);
                hazelcastGroupsConfig.putAll(updates);
            } else {
                if (properties != null) {
                    Enumeration en = ((Dictionary)properties).keys();
                    while (en.hasMoreElements()) {
                        String key = (String)en.nextElement();
                        this.localConfig.put(key, ((Dictionary)properties).get(key));
                    }
                } else {
                    properties = new Hashtable();
                }
                boolean updated = false;
                for (String key : hazelcastGroupsConfig.keySet()) {
                    Object value = hazelcastGroupsConfig.get((Object)key);
                    updated |= this.updatePropertiesFromHazelcastMap(properties, key, value);
                }
                if (updated) {
                    this.updateConfiguration(groupsConfiguration, properties);
                }
            }
            Node node = this.getNode();
            properties = this.getConfigurationForNode().getProperties();
            Set<String> groupNames = this.convertStringToSet(properties != null ? (String)((Dictionary)properties).get("groups") : null);
            this.getClusterGroups().put((Object)node, groupNames);
        }
        catch (IOException e) {
            LOGGER.warn("CELLAR HAZELCAST: can't create cluster group from configuration admin", (Throwable)e);
        }
    }

    private synchronized boolean updatePropertiesFromHazelcastMap(Dictionary<String, Object> properties, String key, Object value) {
        if (!(value instanceof Map)) {
            return false;
        }
        boolean changed = false;
        Map map = (Map)value;
        for (Map.Entry entry : map.entrySet()) {
            String entryKey = (String)entry.getKey();
            Object entryValue = entry.getValue();
            if (entryKey.equals(".change")) {
                Set<String> groups = this.convertStringToSet((String)properties.get("groups"));
                if ((!entryValue.equals("added") || groups.contains(key)) && (!entryValue.equals("removed") || !groups.contains(key))) continue;
                LOGGER.debug("CELLAR HAZELCAST: get group " + key + " configuration from cluster : " + key + " has been " + entryValue);
                if (entryValue.equals("added")) {
                    groups.add(key);
                } else {
                    groups.remove(key);
                }
                String newValue = this.convertSetToString(groups);
                properties.put("groups", newValue);
                this.localConfig.put("groups", newValue);
                changed = true;
                continue;
            }
            if (properties.get(entryKey) != null && properties.get(entryKey).equals(entryValue)) continue;
            LOGGER.debug("CELLAR HAZELCAST: get group " + key + " configuration from cluster : " + entryKey + " = " + entryValue);
            properties.put(entryKey, entryValue);
            this.localConfig.put(entryKey, entryValue);
            changed = true;
        }
        return changed;
    }

    private synchronized Map<String, Object> getUpdatesForHazelcastMap(Dictionary<String, Object> properties) {
        HashMap<String, Object> updates = new HashMap<String, Object>();
        if (properties == null) {
            return updates;
        }
        Enumeration<String> en = properties.keys();
        while (en.hasMoreElements()) {
            Object localValue;
            String key = en.nextElement();
            Object value = properties.get(key);
            if (!(key.startsWith("felix.") || key.startsWith("service.") || (localValue = this.localConfig.get(key)) != null && localValue.equals(value))) {
                if (key.equals("groups")) {
                    Set<String> removedGroups = this.convertStringToSet((String)localValue);
                    Set<String> addedGroups = this.convertStringToSet((String)value);
                    addedGroups.removeAll(removedGroups);
                    removedGroups.removeAll(this.convertStringToSet((String)value));
                    for (String addedGroup : addedGroups) {
                        this.getOrCreateMap(updates, addedGroup).put(".change", "added");
                    }
                    for (String removedGroup : removedGroups) {
                        this.getOrCreateMap(updates, removedGroup).put(".change", "removed");
                    }
                } else {
                    int idx = key.indexOf(".");
                    if (idx > 0) {
                        String groupKey = key.substring(0, idx);
                        this.getOrCreateMap(updates, groupKey).put(key, value);
                    } else {
                        LOGGER.warn("CELLAR HAZELCAST: found group property that is not prefixed with a group name: {}. Skipping it", (Object)key);
                    }
                }
            }
            this.localConfig.put(key, value);
        }
        return updates;
    }

    private Map<String, Object> getOrCreateMap(Map<String, Object> updates, String group) {
        HashMap props = (HashMap)updates.get(group);
        if (props == null) {
            props = new HashMap();
            updates.put(group, props);
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)this.combinedClassLoader);
            Node local = this.getNode();
            this.getClusterGroups().remove((Object)local);
            for (Map.Entry<String, EventConsumer> consumerEntry : this.groupConsumer.entrySet()) {
                EventConsumer consumer = consumerEntry.getValue();
                consumer.stop();
            }
            this.groupConsumer.clear();
            this.groupProducers.clear();
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node getNode() {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)this.combinedClassLoader);
            HazelcastNode node = null;
            Cluster cluster = this.instance.getCluster();
            if (cluster != null) {
                Member member = cluster.getLocalMember();
                node = new HazelcastNode(member);
            }
            HazelcastNode hazelcastNode = node;
            return hazelcastNode;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Group createGroup(String groupName) {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)this.combinedClassLoader);
            Map<String, Group> listGroups = this.listGroups();
            Group group = listGroups.get(groupName);
            if (group == null) {
                group = new Group(groupName);
                try {
                    Dictionary<String, Object> properties;
                    Configuration configuration = this.getConfigurationForGroups();
                    if (configuration != null && (properties = configuration.getProperties()) != null && !properties.isEmpty()) {
                        properties = this.copyGroupConfiguration("default.", groupName + '.', properties);
                        Set<String> groups = this.convertStringToSet((String)properties.get("groups"));
                        groups.add(groupName);
                        properties.put("groups", this.convertSetToString(groups));
                        this.updateConfiguration(configuration, properties);
                    }
                }
                catch (IOException e) {
                    LOGGER.error("CELLAR HAZELCAST: failed to update cluster group configuration", (Throwable)e);
                }
            }
            Group group2 = group;
            return group2;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteGroup(String groupName) {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)this.combinedClassLoader);
            if (!groupName.equals("default")) {
                try {
                    Configuration configuration = this.getConfigurationForGroups();
                    Dictionary properties = configuration.getProperties();
                    Set<String> groups = this.convertStringToSet((String)properties.get("groups"));
                    groups.remove(groupName);
                    properties.put("groups", this.convertSetToString(groups));
                    this.updateConfiguration(configuration, properties);
                }
                catch (IOException e) {
                    LOGGER.warn("CELLAR HAZELCAST: can't store cluster group list", (Throwable)e);
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    public Set<Group> listLocalGroups() {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)this.combinedClassLoader);
            Set<Group> set = this.listGroups(this.getNode());
            return set;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLocalGroup(String groupName) {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)this.combinedClassLoader);
            Set<Group> localGroups = this.listLocalGroups();
            for (Group localGroup : localGroups) {
                if (!localGroup.getName().equals(groupName)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    public Set<Group> listAllGroups() {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)this.combinedClassLoader);
            HashSet<Group> hashSet = new HashSet<Group>(this.listGroups().values());
            return hashSet;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Group findGroupByName(String groupName) {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)this.combinedClassLoader);
            Group group = this.listGroups().get(groupName);
            return group;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Group> listGroups() {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            HashMap<String, Group> res = new HashMap<String, Group>();
            Thread.currentThread().setContextClassLoader((ClassLoader)this.combinedClassLoader);
            IMap<Node, Set<String>> nodes = this.getClusterGroups();
            Set<String> groups = this.convertStringToSet((String)this.localConfig.get("groups"));
            groups.add("default");
            for (String groupName : groups) {
                Group group = new Group(groupName);
                res.put(groupName, group);
                for (Map.Entry entry : nodes.entrySet()) {
                    if (!((Set)entry.getValue()).contains(groupName)) continue;
                    group.getNodes().add(entry.getKey());
                }
            }
            HashMap<String, Group> hashMap = res;
            return hashMap;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Group> listGroups(Node node) {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)this.combinedClassLoader);
            HashSet<Group> result = new HashSet<Group>();
            IMap<Node, Set<String>> groupMap = this.getClusterGroups();
            Set groupNames = (Set)groupMap.get(node);
            if (groupNames != null) {
                Map<String, Group> g = this.listGroups();
                g.keySet().retainAll(groupNames);
                result.addAll(g.values());
            }
            HashSet<Group> hashSet = result;
            return hashSet;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    public Set<String> listGroupNames() {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)this.combinedClassLoader);
            Set<String> set = this.listGroupNames(this.getNode());
            return set;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> listGroupNames(Node node) {
        HashSet<String> names = new HashSet<String>();
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)this.combinedClassLoader);
            Map<String, Group> groups = this.listGroups();
            if (groups != null && !groups.isEmpty()) {
                for (Group group : groups.values()) {
                    if (!group.getNodes().contains(node)) continue;
                    names.add(group.getName());
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerGroup(Group group) {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)this.combinedClassLoader);
            String groupName = group.getName();
            LOGGER.debug("CELLAR HAZELCAST: registering cluster group {}.", (Object)groupName);
            Properties serviceProperties = new Properties();
            serviceProperties.put("type", "group");
            serviceProperties.put("name", groupName);
            if (!this.producerRegistrations.containsKey(groupName)) {
                EventProducer producer = this.groupProducers.get(groupName);
                if (producer == null) {
                    producer = this.eventTransportFactory.getEventProducer(groupName, Boolean.TRUE);
                    this.groupProducers.put(groupName, producer);
                }
                ServiceRegistration producerRegistration = this.bundleContext.registerService(EventProducer.class.getCanonicalName(), (Object)producer, (Dictionary)serviceProperties);
                this.producerRegistrations.put(groupName, producerRegistration);
            }
            if (!this.consumerRegistrations.containsKey(groupName)) {
                EventConsumer consumer = this.groupConsumer.get(groupName);
                if (consumer == null) {
                    consumer = this.eventTransportFactory.getEventConsumer(groupName, Boolean.valueOf(true));
                    this.groupConsumer.put(groupName, consumer);
                } else if (!consumer.isConsuming().booleanValue()) {
                    consumer.start();
                }
                ServiceRegistration consumerRegistration = this.bundleContext.registerService(EventConsumer.class.getCanonicalName(), (Object)consumer, (Dictionary)serviceProperties);
                this.consumerRegistrations.put(groupName, consumerRegistration);
            }
            Node node = this.getNode();
            group.getNodes().add(node);
            IMap<Node, Set<String>> map = this.getClusterGroups();
            HashSet<String> groupNames = (HashSet<String>)map.get(node);
            groupNames = new HashSet<String>(groupNames);
            groupNames.add(groupName);
            map.put(node, groupNames);
            try {
                Dictionary properties;
                Configuration configuration = this.getConfigurationForNode();
                if (configuration != null && (properties = configuration.getProperties()) != null) {
                    String groups = (String)properties.get("groups");
                    if (groups == null || groups.isEmpty()) {
                        groups = groupName;
                    } else {
                        Set<String> groupNamesSet = this.convertStringToSet(groups);
                        groupNamesSet.add(groupName);
                        groups = this.convertSetToString(groupNamesSet);
                    }
                    if (groups == null || groups.isEmpty()) {
                        groups = groupName;
                    }
                    properties.put("groups", groups);
                    this.updateConfiguration(configuration, properties);
                }
            }
            catch (IOException e) {
                LOGGER.error("CELLAR HAZELCAST: error reading cluster group configuration {}", (Object)group);
            }
            try {
                ServiceReference[] serviceReferences = this.bundleContext.getAllServiceReferences("org.apache.karaf.cellar.core.Synchronizer", null);
                if (serviceReferences != null && serviceReferences.length > 0) {
                    for (ServiceReference ref : serviceReferences) {
                        Synchronizer synchronizer = (Synchronizer)this.bundleContext.getService(ref);
                        if (synchronizer != null) {
                            synchronizer.sync(group);
                        }
                        this.bundleContext.ungetService(ref);
                    }
                }
            }
            catch (InvalidSyntaxException e) {
                LOGGER.error("CELLAR HAZELCAST: failed to look for synchronizers", (Throwable)e);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    public void registerGroup(String groupName) {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)this.combinedClassLoader);
            this.registerGroup(new Group(groupName));
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    public void unRegisterGroup(String groupName) {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)this.combinedClassLoader);
            this.unRegisterGroup(this.listGroups().get(groupName));
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unRegisterGroup(Group group) {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ServiceRegistration producerRegistration;
            ServiceRegistration consumerRegistration;
            Thread.currentThread().setContextClassLoader((ClassLoader)this.combinedClassLoader);
            String groupName = group.getName();
            group.getNodes().remove(this.getNode());
            this.listGroups().put(groupName, group);
            if (this.consumerRegistrations != null && !this.consumerRegistrations.isEmpty() && (consumerRegistration = this.consumerRegistrations.get(groupName)) != null) {
                consumerRegistration.unregister();
                this.consumerRegistrations.remove(groupName);
            }
            if (this.producerRegistrations != null && !this.producerRegistrations.isEmpty() && (producerRegistration = this.producerRegistrations.get(groupName)) != null) {
                producerRegistration.unregister();
                this.producerRegistrations.remove(groupName);
            }
            this.groupProducers.remove(groupName);
            EventConsumer consumer = this.groupConsumer.remove(groupName);
            if (consumer != null) {
                consumer.stop();
            }
            Node node = this.getNode();
            group.getNodes().add(node);
            IMap<Node, Set<String>> map = this.getClusterGroups();
            HashSet groupNames = (HashSet)map.get(node);
            groupNames = new HashSet(groupNames);
            groupNames.remove(groupName);
            map.put(node, groupNames);
            try {
                Configuration configuration = this.getConfigurationForNode();
                Dictionary properties = configuration.getProperties();
                String groups = (String)properties.get("groups");
                if (groups == null || groups.isEmpty()) {
                    groups = "";
                } else if (groups.contains(groupName)) {
                    Set<String> groupNamesSet = this.convertStringToSet(groups);
                    groupNamesSet.remove(groupName);
                    groups = this.convertSetToString(groupNamesSet);
                }
                properties.put("groups", groups);
                this.updateConfiguration(configuration, properties);
            }
            catch (IOException e) {
                LOGGER.error("CELLAR HAZELCAST: failed to read cluster group configuration", (Throwable)e);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    public Dictionary<String, Object> copyGroupConfiguration(String sourceGroupPrefix, String targetGroupPrefix, Dictionary<String, Object> properties) {
        Hashtable<String, Object> updatedProperties = new Hashtable<String, Object>();
        Enumeration<String> keyEnumeration = properties.keys();
        while (keyEnumeration.hasMoreElements()) {
            String key = keyEnumeration.nextElement();
            Object value = properties.get(key);
            if (key.startsWith(sourceGroupPrefix)) {
                String newKey = targetGroupPrefix + key.substring(sourceGroupPrefix.length());
                ((Dictionary)updatedProperties).put(newKey, value);
            }
            ((Dictionary)updatedProperties).put(key, value);
        }
        return updatedProperties;
    }

    protected String convertSetToString(Set<String> set) {
        StringBuilder result = new StringBuilder();
        Iterator<String> groupIterator = set.iterator();
        while (groupIterator.hasNext()) {
            String name = groupIterator.next();
            result.append(name);
            if (!groupIterator.hasNext()) continue;
            result.append(",");
        }
        return result.toString();
    }

    protected Set<String> convertStringToSet(String string) {
        if (string == null) {
            return new TreeSet<String>();
        }
        TreeSet<String> result = new TreeSet<String>();
        String[] groupNames = string.split(",");
        if (groupNames != null && groupNames.length > 0) {
            for (String name : groupNames) {
                result.add(name.trim());
            }
        } else {
            result.add(string);
        }
        return result;
    }

    public void configurationEvent(ConfigurationEvent configurationEvent) {
        if (!HAZELCAST_GROUPS.equals(configurationEvent.getPid())) {
            return;
        }
        try {
            IMap<String, Object> hazelcastGroupConfig = this.getClusterGroupsConfig();
            Configuration conf = this.getConfigurationForGroups();
            Dictionary properties = conf.getProperties();
            Map<String, Object> updates = this.getUpdatesForHazelcastMap(properties);
            for (Map.Entry<String, Object> entry : updates.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                Object clusterValue = hazelcastGroupConfig.get(key);
                if (clusterValue != null && clusterValue.equals(value)) continue;
                LOGGER.debug("CELLAR HAZELCAST : sending updates to cluster : " + key + " = " + value);
                if (clusterValue != null && value instanceof Map) {
                    HashMap newValue = new HashMap((Map)clusterValue);
                    newValue.putAll((Map)value);
                    hazelcastGroupConfig.put(key, newValue);
                    continue;
                }
                hazelcastGroupConfig.put(key, value);
            }
        }
        catch (Exception e) {
            LOGGER.warn("CELLAR HAZELCAST: failed to update cluster group configuration", (Throwable)e);
        }
    }

    public void entryAdded(EntryEvent<String, Object> entryEvent) {
        this.entryUpdated(entryEvent);
    }

    public void entryRemoved(EntryEvent<String, Object> entryEvent) {
        this.entryUpdated(entryEvent);
    }

    public void entryUpdated(EntryEvent<String, Object> entryEvent) {
        try {
            Configuration conf = this.getConfigurationForGroups();
            Dictionary properties = conf.getProperties();
            String key = (String)entryEvent.getKey();
            Object value = entryEvent.getValue();
            if (this.updatePropertiesFromHazelcastMap(properties, key, value)) {
                LOGGER.debug("CELLAR HAZELCAST: cluster group configuration has been updated, updating local configuration: {} = {}", (Object)key, value);
                this.updateConfiguration(conf, properties);
            }
        }
        catch (Exception ex) {
            LOGGER.warn("CELLAR HAZELCAST: failed to update local configuration", (Throwable)ex);
        }
    }

    public void entryEvicted(EntryEvent<String, Object> entryEvent) {
        this.entryUpdated(entryEvent);
    }

    public void mapCleared(MapEvent mapEvent) {
    }

    public void mapEvicted(MapEvent mapEvent) {
    }

    public HazelcastInstance getInstance() {
        return this.instance;
    }

    public void setInstance(HazelcastInstance instance) {
        this.instance = instance;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public ConfigurationAdmin getConfigurationAdmin() {
        return this.configurationAdmin;
    }

    public void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }

    public EventTransportFactory getEventTransportFactory() {
        return this.eventTransportFactory;
    }

    public void setEventTransportFactory(EventTransportFactory eventTransportFactory) {
        this.eventTransportFactory = eventTransportFactory;
    }

    public CombinedClassLoader getCombinedClassLoader() {
        return this.combinedClassLoader;
    }

    public void setCombinedClassLoader(CombinedClassLoader combinedClassLoader) {
        this.combinedClassLoader = combinedClassLoader;
    }

    private Configuration getConfigurationForGroups() throws IOException {
        try {
            int max;
            for (max = 0; this.configurationAdmin.listConfigurations("(service.pid=org.apache.karaf.cellar.groups)") == null && max < 100; ++max) {
                Thread.sleep(500L);
            }
            if (max == 100) {
                LOGGER.warn("Timeout while loading {} configuration", (Object)HAZELCAST_GROUPS);
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        return this.configurationAdmin.getConfiguration(HAZELCAST_GROUPS, null);
    }

    private Configuration getConfigurationForNode() throws IOException {
        try {
            int max;
            for (max = 0; this.configurationAdmin.listConfigurations("(service.pid=org.apache.karaf.cellar.node)") == null && max < 100; ++max) {
                Thread.sleep(500L);
            }
            if (max == 100) {
                LOGGER.warn("Timeout while loading {} configuration", (Object)"org.apache.karaf.cellar.node");
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        return this.configurationAdmin.getConfiguration("org.apache.karaf.cellar.node", null);
    }

    private IMap<Node, Set<String>> getClusterGroups() {
        return this.instance.getMap(HAZELCAST_GROUPS);
    }

    private IMap<String, Object> getClusterGroupsConfig() {
        return this.instance.getMap(HAZELCAST_GROUPS_CONFIG);
    }

    private void updateConfiguration(Configuration cfg, Dictionary<String, Object> properties) throws IOException {
        cfg.update(properties);
        LOGGER.debug("CELLAR HAZELCAST: updated configuration with pid: {}", (Object)cfg.getPid());
    }
}

