/*
 * Decompiled with CFR 0.152.
 */
package groovyx.net.http;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

public class CharSequenceInputStream
extends InputStream {
    private final Charset charset;
    private final CharsetEncoder encoder;
    private final CharBuffer inputBuffer;
    private final ByteBuffer outputBuffer;
    private CoderResult lastResult = CoderResult.OVERFLOW;
    private int written = 0;

    public CharSequenceInputStream(CharSequence sequence, Charset charset) {
        this.charset = charset;
        this.encoder = charset.newEncoder();
        this.inputBuffer = CharBuffer.wrap(sequence);
        this.outputBuffer = ByteBuffer.wrap(new byte[1024]);
        this.encodeNext();
    }

    @Override
    public int available() throws IOException {
        int estimated = this.inputBuffer.capacity() * (int)this.encoder.averageBytesPerChar();
        return Math.max(estimated - this.written, 0);
    }

    @Override
    public void close() throws IOException {
    }

    private void encodeNext() {
        if (this.lastResult == null) {
            return;
        }
        this.outputBuffer.clear();
        if (CoderResult.OVERFLOW == this.lastResult) {
            this.lastResult = this.encoder.encode(this.inputBuffer, this.outputBuffer, false);
        } else if (CoderResult.UNDERFLOW == this.lastResult) {
            this.encoder.encode(this.inputBuffer, this.outputBuffer, true);
            this.encoder.flush(this.outputBuffer);
            this.lastResult = null;
        }
        this.outputBuffer.flip();
    }

    private void ensure() {
        if (this.outputBuffer.remaining() == 0 && this.lastResult != null) {
            this.encodeNext();
        }
    }

    @Override
    public int read() throws IOException {
        this.ensure();
        if (this.outputBuffer.remaining() == 0) {
            return -1;
        }
        ++this.written;
        return this.outputBuffer.get();
    }

    @Override
    public int read(byte[] ary) {
        return this.read(ary, 0, ary.length);
    }

    @Override
    public int read(byte[] ary, int offset, int length) {
        this.ensure();
        if (this.outputBuffer.remaining() == 0) {
            return -1;
        }
        int total = 0;
        int index = offset;
        int leftAry = length;
        while (this.outputBuffer.remaining() > 0 && leftAry > 0) {
            int toCopy = Math.min(this.outputBuffer.remaining(), leftAry);
            this.outputBuffer.get(ary, index, toCopy);
            index += toCopy;
            total += toCopy;
            if ((leftAry -= toCopy) <= 0) continue;
            this.encodeNext();
        }
        this.written += total;
        return total;
    }
}

