/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.services.sorts;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.unomi.api.PersonalizationResult;
import org.apache.unomi.api.PersonalizationStrategy;
import org.apache.unomi.api.Profile;
import org.apache.unomi.api.Session;
import org.apache.unomi.api.SystemPropertiesItem;
import org.apache.unomi.api.services.PersonalizationService;

public class ControlGroupPersonalizationStrategy
implements PersonalizationStrategy {
    public static final String PERSONALIZATION_STRATEGY_STATUS = "personalizationStrategyStatus";
    public static final String PERSONALIZATION_STRATEGY_STATUS_ID = "personalizationId";
    public static final String PERSONALIZATION_STRATEGY_STATUS_IN_CTRL_GROUP = "inControlGroup";
    public static final String PERSONALIZATION_STRATEGY_STATUS_DATE = "timeStamp";
    public static final String CONTROL_GROUP_CONFIG_STORE_IN_SESSION = "storeInSession";
    public static final String CONTROL_GROUP_CONFIG_PERCENTAGE = "percentage";
    public static final String CONTROL_GROUP_CONFIG = "controlGroup";
    private final Random controlGroupRandom = new Random();

    public PersonalizationResult personalizeList(Profile profile, Session session, PersonalizationService.PersonalizationRequest personalizationRequest) {
        if (personalizationRequest.getStrategyOptions() != null && personalizationRequest.getStrategyOptions().containsKey(CONTROL_GROUP_CONFIG)) {
            Map controlGroupMap = (Map)personalizationRequest.getStrategyOptions().get(CONTROL_GROUP_CONFIG);
            return controlGroupMap.containsKey(CONTROL_GROUP_CONFIG_STORE_IN_SESSION) && controlGroupMap.get(CONTROL_GROUP_CONFIG_STORE_IN_SESSION) instanceof Boolean && (Boolean)controlGroupMap.get(CONTROL_GROUP_CONFIG_STORE_IN_SESSION) != false ? this.getPersonalizationResultForControlGroup(personalizationRequest, (SystemPropertiesItem)session, controlGroupMap, 2) : this.getPersonalizationResultForControlGroup(personalizationRequest, (SystemPropertiesItem)profile, controlGroupMap, 4);
        }
        throw new IllegalArgumentException("Not possible to perform control group strategy without control group config");
    }

    private PersonalizationResult getPersonalizationResultForControlGroup(PersonalizationService.PersonalizationRequest personalizationRequest, SystemPropertiesItem systemPropertiesItem, Map<String, Object> controlGroupConfig, int changeType) {
        List strategyStatuses;
        PersonalizationResult personalizationResult = new PersonalizationResult(personalizationRequest.getContents().stream().map(PersonalizationService.PersonalizedContent::getId).collect(Collectors.toList()));
        if (systemPropertiesItem.getSystemProperties().get(PERSONALIZATION_STRATEGY_STATUS) == null) {
            strategyStatuses = new ArrayList();
            systemPropertiesItem.getSystemProperties().put(PERSONALIZATION_STRATEGY_STATUS, strategyStatuses);
        } else {
            strategyStatuses = (List)systemPropertiesItem.getSystemProperties().get(PERSONALIZATION_STRATEGY_STATUS);
        }
        for (Map map : strategyStatuses) {
            boolean inControlGroup;
            if (!personalizationRequest.getId().equals(map.get(PERSONALIZATION_STRATEGY_STATUS_ID))) continue;
            if (!map.containsKey(PERSONALIZATION_STRATEGY_STATUS_IN_CTRL_GROUP)) {
                inControlGroup = this.calculateControlGroup(controlGroupConfig);
                map.put(PERSONALIZATION_STRATEGY_STATUS_IN_CTRL_GROUP, inControlGroup);
                map.put(PERSONALIZATION_STRATEGY_STATUS_DATE, new Date());
                personalizationResult.addChanges(changeType);
            } else {
                inControlGroup = (Boolean)map.get(PERSONALIZATION_STRATEGY_STATUS_IN_CTRL_GROUP);
            }
            personalizationResult.setInControlGroup(inControlGroup);
            return personalizationResult;
        }
        boolean inControlGroup = this.calculateControlGroup(controlGroupConfig);
        HashMap<String, Object> newStrategyStatus = new HashMap<String, Object>();
        newStrategyStatus.put(PERSONALIZATION_STRATEGY_STATUS_ID, personalizationRequest.getId());
        newStrategyStatus.put(PERSONALIZATION_STRATEGY_STATUS_DATE, new Date());
        newStrategyStatus.put(PERSONALIZATION_STRATEGY_STATUS_IN_CTRL_GROUP, inControlGroup);
        strategyStatuses.add(newStrategyStatus);
        personalizationResult.addChanges(changeType);
        personalizationResult.setInControlGroup(inControlGroup);
        return personalizationResult;
    }

    private boolean calculateControlGroup(Map<String, Object> controlGroupConfig) {
        double percentage = controlGroupConfig.get(CONTROL_GROUP_CONFIG_PERCENTAGE) != null && controlGroupConfig.get(CONTROL_GROUP_CONFIG_PERCENTAGE) instanceof Number ? ((Number)controlGroupConfig.get(CONTROL_GROUP_CONFIG_PERCENTAGE)).doubleValue() : 0.0;
        double random = this.controlGroupRandom.nextDouble() * 100.0;
        return random <= percentage;
    }
}

