/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.node;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.node.Node;

public abstract class DiscoveryNodeRole {
    private final String roleName;
    private final String roleNameAbbreviation;
    private final boolean isKnownRole;
    public static final DiscoveryNodeRole DATA_ROLE = new DiscoveryNodeRole("data", "d"){

        @Override
        protected Setting<Boolean> roleSetting() {
            return Node.NODE_DATA_SETTING;
        }
    };
    public static final DiscoveryNodeRole INGEST_ROLE = new DiscoveryNodeRole("ingest", "i"){

        @Override
        protected Setting<Boolean> roleSetting() {
            return Node.NODE_INGEST_SETTING;
        }
    };
    public static final DiscoveryNodeRole MASTER_ROLE = new DiscoveryNodeRole("master", "m"){

        @Override
        protected Setting<Boolean> roleSetting() {
            return Node.NODE_MASTER_SETTING;
        }
    };
    public static Set<DiscoveryNodeRole> BUILT_IN_ROLES = Collections.unmodifiableSet(new HashSet<DiscoveryNodeRole>(Arrays.asList(DATA_ROLE, INGEST_ROLE, MASTER_ROLE)));

    public final String roleName() {
        return this.roleName;
    }

    public final String roleNameAbbreviation() {
        return this.roleNameAbbreviation;
    }

    public final boolean isKnownRole() {
        return this.isKnownRole;
    }

    protected DiscoveryNodeRole(String roleName, String roleNameAbbreviation) {
        this(true, roleName, roleNameAbbreviation);
    }

    private DiscoveryNodeRole(boolean isKnownRole, String roleName, String roleNameAbbreviation) {
        this.isKnownRole = isKnownRole;
        this.roleName = Objects.requireNonNull(roleName);
        this.roleNameAbbreviation = Objects.requireNonNull(roleNameAbbreviation);
    }

    protected abstract Setting<Boolean> roleSetting();

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiscoveryNodeRole that = (DiscoveryNodeRole)o;
        return this.roleName.equals(that.roleName) && this.roleNameAbbreviation.equals(that.roleNameAbbreviation) && this.isKnownRole == that.isKnownRole;
    }

    public final int hashCode() {
        return Objects.hash(this.isKnownRole, this.roleName(), this.roleNameAbbreviation());
    }

    public final String toString() {
        return "DiscoveryNodeRole{roleName='" + this.roleName + '\'' + ", roleNameAbbreviation='" + this.roleNameAbbreviation + '\'' + (this.isKnownRole ? "" : ", isKnownRole=false") + '}';
    }

    static class UnknownRole
    extends DiscoveryNodeRole {
        UnknownRole(String roleName, String roleNameAbbreviation) {
            super(false, roleName, roleNameAbbreviation);
        }

        @Override
        protected Setting<Boolean> roleSetting() {
            assert (false);
            return Setting.boolSetting("node. " + this.roleName(), false, Setting.Property.NodeScope);
        }
    }
}

