/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.url;

import aQute.bnd.annotation.plugin.BndPlugin;
import aQute.bnd.url.DefaultURLConnectionHandler;
import aQute.lib.converter.Converter;
import aQute.service.reporter.Reporter;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BndPlugin(name="url.bearer.authentication", hide=true, parameters=Config.class)
public class BearerAuthentication
extends DefaultURLConnectionHandler {
    private static final Logger logger = LoggerFactory.getLogger(BearerAuthentication.class);
    private static final String HEADER_AUTHORIZATION = "Authorization";
    private static final String PREFIX_BEARER_AUTH = "Bearer ";
    private String oauth2Token;
    private String authentication;

    public BearerAuthentication() {
    }

    public BearerAuthentication(String oauth2Token, Reporter reporter) {
        this.setReporter(reporter);
        this.oauth2Token = oauth2Token;
        this.authentication = PREFIX_BEARER_AUTH + oauth2Token;
    }

    @Override
    public void setProperties(Map<String, String> map) throws Exception {
        super.setProperties(map);
        Config config = Converter.cnv(Config.class, map);
        this.oauth2Token = config._oauth2Token();
        this.authentication = PREFIX_BEARER_AUTH + this.oauth2Token;
    }

    @Override
    public void handle(URLConnection connection) {
        if (connection instanceof HttpURLConnection && this.matches(connection) && this.oauth2Token != null) {
            if (!(connection instanceof HttpsURLConnection)) {
                logger.debug("using bearer authentication with http instead of https, this is very insecure: {}", (Object)connection.getURL());
            }
            connection.setRequestProperty(HEADER_AUTHORIZATION, this.authentication);
        }
    }

    public String toString() {
        return "BearerAuthentication [oauth2Token=" + this.oauth2Token + "]";
    }

    static interface Config
    extends DefaultURLConnectionHandler.Config {
        public String _oauth2Token();
    }
}

