/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.scripting;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.unomi.scripting.ExpressionFilterFactory;
import org.apache.unomi.scripting.ScriptExecutor;
import org.apache.unomi.scripting.SecureFilteringClassLoader;
import org.mvel2.MVEL;
import org.mvel2.ParserConfiguration;
import org.mvel2.ParserContext;

public class MvelScriptExecutor
implements ScriptExecutor {
    private static final String INVALID_SCRIPT_MARKER = "--- Invalid Script Marker ---";
    private Map<String, Serializable> mvelExpressions = new ConcurrentHashMap<String, Serializable>();
    private SecureFilteringClassLoader secureFilteringClassLoader = new SecureFilteringClassLoader(this.getClass().getClassLoader());
    private ExpressionFilterFactory expressionFilterFactory;

    public void setExpressionFilterFactory(ExpressionFilterFactory expressionFilterFactory) {
        this.expressionFilterFactory = expressionFilterFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(String script, Map<String, Object> context) {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Object object;
            Thread.currentThread().setContextClassLoader(this.secureFilteringClassLoader);
            if (!this.mvelExpressions.containsKey(script)) {
                if (this.expressionFilterFactory.getExpressionFilter("mvel").filter(script) == null) {
                    this.mvelExpressions.put(script, (Serializable)((Object)INVALID_SCRIPT_MARKER));
                } else {
                    ParserConfiguration parserConfiguration = new ParserConfiguration();
                    parserConfiguration.setClassLoader((ClassLoader)this.secureFilteringClassLoader);
                    ParserContext parserContext = new ParserContext(parserConfiguration);
                    parserContext.addImport("Runtime", String.class);
                    parserContext.addImport("System", String.class);
                    parserContext.addImport("ProcessBuilder", String.class);
                    parserContext.addImport("Class", String.class);
                    parserContext.addImport("ClassLoader", String.class);
                    parserContext.addImport("Thread", String.class);
                    parserContext.addImport("Compiler", String.class);
                    parserContext.addImport("ThreadLocal", String.class);
                    parserContext.addImport("SecurityManager", String.class);
                    this.mvelExpressions.put(script, MVEL.compileExpression((String)script, (ParserContext)parserContext));
                }
            }
            if (this.mvelExpressions.containsKey(script) && this.mvelExpressions.get(script) != INVALID_SCRIPT_MARKER) {
                object = MVEL.executeExpression((Object)this.mvelExpressions.get(script), context);
                return object;
            }
            object = null;
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }
}

