/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.blueprint;

import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.core.osgi.OsgiComponentResolver;
import org.apache.camel.spi.ComponentResolver;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ResolverHelper;
import org.osgi.framework.BundleContext;
import org.osgi.service.blueprint.container.NoSuchComponentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlueprintComponentResolver
extends OsgiComponentResolver {
    private static final Logger LOG = LoggerFactory.getLogger(BlueprintComponentResolver.class);

    public BlueprintComponentResolver(BundleContext bundleContext) {
        super(bundleContext);
    }

    @Override
    public Component resolveComponent(String name, CamelContext context) throws Exception {
        Component componentReg = ResolverHelper.lookupComponentInRegistryWithFallback((CamelContext)context, (String)name, (ResolverHelper.LookupExceptionHandler)new ResolverHelper.LookupExceptionHandler(){

            public void handleException(Exception e, Logger log, String name) {
                if (ObjectHelper.getException(NoSuchComponentException.class, (Throwable)e) == null) {
                    LOG.trace("Ignored error looking up bean: " + name + " due: " + e.getMessage(), (Throwable)e);
                }
            }
        });
        if (componentReg != null) {
            return componentReg;
        }
        try {
            Object bean = context.getRegistry().lookupByName(".camelBlueprint.componentResolver." + name);
            if (bean instanceof ComponentResolver) {
                LOG.debug("Found component resolver: {} in registry: {}", (Object)name, bean);
                return ((ComponentResolver)bean).resolveComponent(name, context);
            }
        }
        catch (Exception e) {
            LOG.trace("Ignored error looking up bean: " + name + " due: " + e.getMessage(), (Throwable)e);
        }
        return this.getComponent(name, context);
    }
}

