/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.services.impl.personalization;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.unomi.api.PersonalizationResult;
import org.apache.unomi.api.PersonalizationStrategy;
import org.apache.unomi.api.Profile;
import org.apache.unomi.api.Session;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.api.services.PersonalizationService;
import org.apache.unomi.api.services.ProfileService;
import org.apache.unomi.services.impl.personalization.ControlGroup;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class PersonalizationServiceImpl
implements PersonalizationService {
    public static final String CONTROL_GROUPS_PROPERTY_NAME = "unomiControlGroups";
    private BundleContext bundleContext;
    private ProfileService profileService;
    private Map<String, PersonalizationStrategy> personalizationStrategies = new ConcurrentHashMap<String, PersonalizationStrategy>();
    private Random controlGroupRandom = new Random();

    public void setProfileService(ProfileService profileService) {
        this.profileService = profileService;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void addPersonalizationStrategy(ServiceReference<PersonalizationStrategy> personalizationStrategyRef) {
        PersonalizationStrategy personalizationStrategy = (PersonalizationStrategy)this.bundleContext.getService(personalizationStrategyRef);
        this.personalizationStrategies.put(personalizationStrategyRef.getProperty("personalizationStrategyId").toString(), personalizationStrategy);
    }

    public void removePersonalizationStrategy(ServiceReference<PersonalizationStrategy> personalizationStrategyRef) {
        if (personalizationStrategyRef == null) {
            return;
        }
        this.personalizationStrategies.remove(personalizationStrategyRef.getProperty("personalizationStrategyId").toString());
    }

    public boolean filter(Profile profile, Session session, PersonalizationService.PersonalizedContent personalizedContent) {
        boolean result = true;
        if (personalizedContent.getFilters() != null) {
            for (PersonalizationService.Filter filter : personalizedContent.getFilters()) {
                Condition condition = filter.getCondition();
                if (condition == null || condition.getConditionTypeId() == null) continue;
                result &= this.profileService.matchCondition(condition, profile, session);
            }
        }
        return result;
    }

    public String bestMatch(Profile profile, Session session, PersonalizationService.PersonalizationRequest personalizationRequest) {
        PersonalizationResult result = this.personalizeList(profile, session, personalizationRequest);
        if (result.getContentIds().size() > 0) {
            return (String)result.getContentIds().get(0);
        }
        return null;
    }

    public PersonalizationResult personalizeList(Profile profile, Session session, PersonalizationService.PersonalizationRequest personalizationRequest) {
        PersonalizationStrategy strategy = this.personalizationStrategies.get(personalizationRequest.getStrategy());
        int changeType = 0;
        if (strategy != null) {
            if (personalizationRequest.getStrategyOptions() != null && personalizationRequest.getStrategyOptions().containsKey("controlGroup")) {
                Optional<ControlGroup> currentControlGroup;
                Map controlGroupMap = (Map)personalizationRequest.getStrategyOptions().get("controlGroup");
                boolean storeInSession = false;
                if (controlGroupMap.containsKey("storeInSession")) {
                    storeInSession = (Boolean)controlGroupMap.get("storeInSession");
                }
                boolean profileInControlGroup = false;
                List<Object> controlGroups = null;
                if (storeInSession) {
                    if (session.getProperty(CONTROL_GROUPS_PROPERTY_NAME) != null) {
                        controlGroups = ((List)session.getProperty(CONTROL_GROUPS_PROPERTY_NAME)).stream().map(ControlGroup::fromMap).collect(Collectors.toList());
                    }
                } else if (profile.getProperty(CONTROL_GROUPS_PROPERTY_NAME) != null) {
                    controlGroups = ((List)profile.getProperty(CONTROL_GROUPS_PROPERTY_NAME)).stream().map(ControlGroup::fromMap).collect(Collectors.toList());
                }
                if (controlGroups == null) {
                    controlGroups = new ArrayList();
                }
                if ((currentControlGroup = controlGroups.stream().filter(controlGroup -> controlGroup.id.equals(personalizationRequest.getId())).findFirst()).isPresent()) {
                    profileInControlGroup = true;
                } else {
                    double randomDouble = this.controlGroupRandom.nextDouble() * 100.0;
                    Object percentageObject = controlGroupMap.get("percentage");
                    Double controlGroupPercentage = null;
                    if (percentageObject != null) {
                        if (percentageObject instanceof Double) {
                            controlGroupPercentage = (Double)percentageObject;
                        } else if (percentageObject instanceof Integer) {
                            controlGroupPercentage = ((Integer)percentageObject).doubleValue();
                        }
                    }
                    if (randomDouble <= controlGroupPercentage) {
                        profileInControlGroup = true;
                        ControlGroup controlGroup2 = new ControlGroup(personalizationRequest.getId(), (String)controlGroupMap.get("displayName"), (String)controlGroupMap.get("path"), new Date());
                        controlGroups.add(controlGroup2);
                        List controlGroupsMap = controlGroups.stream().map(ControlGroup::toMap).collect(Collectors.toList());
                        if (storeInSession) {
                            session.setProperty(CONTROL_GROUPS_PROPERTY_NAME, controlGroupsMap);
                            changeType = 2;
                        } else {
                            profile.setProperty(CONTROL_GROUPS_PROPERTY_NAME, controlGroupsMap);
                            changeType = 4;
                        }
                    }
                }
                if (profileInControlGroup) {
                    return new PersonalizationResult(personalizationRequest.getContents().stream().map(PersonalizationService.PersonalizedContent::getId).collect(Collectors.toList()), changeType);
                }
            }
            return new PersonalizationResult(strategy.personalizeList(profile, session, personalizationRequest), changeType);
        }
        throw new IllegalArgumentException("Unknown strategy : " + personalizationRequest.getStrategy());
    }
}

