/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.privacy.rest;

import java.util.List;
import javax.jws.WebMethod;
import javax.jws.WebService;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.cxf.rs.security.cors.CrossOriginResourceSharing;
import org.apache.unomi.api.ServerInfo;
import org.apache.unomi.api.services.PrivacyService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@WebService
@Produces(value={"application/json"})
@CrossOriginResourceSharing(allowAllOrigins=true, allowCredentials=true)
@Path(value="/privacy")
@Component(service={PrivacyServiceEndPoint.class}, property={"osgi.jaxrs.resource=true"})
public class PrivacyServiceEndPoint {
    @Reference
    private PrivacyService privacyService;

    @WebMethod(exclude=true)
    public void setPrivacyService(PrivacyService privacyService) {
        this.privacyService = privacyService;
    }

    @GET
    @Path(value="/info")
    public ServerInfo getServerInfo() {
        return this.privacyService.getServerInfo();
    }

    @DELETE
    @Path(value="/profiles/{profileId}")
    public Response deleteProfileData(@PathParam(value="profileId") String profileId, @QueryParam(value="withData") @DefaultValue(value="false") boolean withData, @QueryParam(value="purgeAll") @DefaultValue(value="false") boolean purgeAll) {
        if (purgeAll) {
            this.privacyService.deleteProfileData(profileId, true);
        } else if (withData) {
            this.privacyService.deleteProfileData(profileId, false);
        } else {
            this.privacyService.deleteProfile(profileId);
        }
        return Response.ok().build();
    }

    @POST
    @Path(value="/profiles/{profileId}/anonymize")
    public void anonymizeProfile(@PathParam(value="profileId") String profileId, @QueryParam(value="scope") String scope) {
        this.privacyService.anonymizeProfile(profileId, scope);
    }

    @GET
    @Path(value="/profiles/{profileId}/anonymousBrowsing")
    public Boolean isAnonymousBrowsing(@PathParam(value="profileId") String profileId) {
        return this.privacyService.isRequireAnonymousBrowsing(profileId);
    }

    @POST
    @Path(value="/profiles/{profileId}/anonymousBrowsing")
    public Response activateAnonymousBrowsing(@PathParam(value="profileId") String profileId, @QueryParam(value="anonymizePastBrowsing") @DefaultValue(value="false") boolean past, @QueryParam(value="scope") String scope) {
        Boolean r;
        if (past) {
            this.privacyService.anonymizeBrowsingData(profileId);
        }
        return (r = this.privacyService.setRequireAnonymousBrowsing(profileId, true, scope)) != false ? Response.ok().build() : Response.serverError().build();
    }

    @DELETE
    @Path(value="/profiles/{profileId}/anonymousBrowsing")
    public Response deactivateAnonymousBrowsing(@PathParam(value="profileId") String profileId, @QueryParam(value="scope") String scope) {
        Boolean r = this.privacyService.setRequireAnonymousBrowsing(profileId, false, scope);
        return r != false ? Response.ok().build() : Response.serverError().build();
    }

    @GET
    @Path(value="/profiles/{profileId}/eventFilters")
    public List<String> getEventFilters(@PathParam(value="profileId") String profileId) {
        return this.privacyService.getFilteredEventTypes(profileId);
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="/profiles/{profileId}/eventFilters")
    public Response setEventFilters(@PathParam(value="profileId") String profileId, List<String> eventFilters) {
        this.privacyService.setFilteredEventTypes(profileId, eventFilters);
        return Response.ok().build();
    }

    @DELETE
    @Path(value="/profiles/{profileId}/properties/{propertyName}")
    public Response removeProperty(@PathParam(value="profileId") String profileId, @PathParam(value="propertyName") String propertyName) {
        this.privacyService.removeProperty(profileId, propertyName);
        return Response.ok().build();
    }
}

