/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.router.services;

import java.util.List;
import java.util.UUID;
import org.apache.unomi.api.Item;
import org.apache.unomi.router.api.IRouterCamelContext;
import org.apache.unomi.router.api.ImportConfiguration;
import org.apache.unomi.router.api.services.ImportExportConfigurationService;
import org.apache.unomi.router.services.AbstractConfigurationServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportConfigurationServiceImpl
extends AbstractConfigurationServiceImpl
implements ImportExportConfigurationService<ImportConfiguration> {
    private static final Logger logger = LoggerFactory.getLogger((String)ImportConfigurationServiceImpl.class.getName());

    public ImportConfigurationServiceImpl() {
        logger.info("Initializing import configuration service...");
    }

    public List<ImportConfiguration> getAll() {
        return this.persistenceService.getAllItems(ImportConfiguration.class);
    }

    public ImportConfiguration load(String configId) {
        return (ImportConfiguration)this.persistenceService.load(configId, ImportConfiguration.class);
    }

    public ImportConfiguration save(ImportConfiguration importConfiguration, boolean updateRunningRoute) {
        if (importConfiguration.getItemId() == null) {
            importConfiguration.setItemId(UUID.randomUUID().toString());
        }
        if (updateRunningRoute) {
            try {
                this.routerCamelContext.updateProfileReaderRoute((Object)importConfiguration, true);
            }
            catch (Exception e) {
                logger.error("Error when trying to save/update running Apache Camel Route: {}", (Object)importConfiguration.getItemId());
            }
        }
        this.persistenceService.save((Item)importConfiguration);
        return (ImportConfiguration)this.persistenceService.load(importConfiguration.getItemId(), ImportConfiguration.class);
    }

    public void delete(String configId) {
        try {
            this.routerCamelContext.killExistingRoute(configId, true);
        }
        catch (Exception e) {
            logger.error("Error when trying to delete running Apache Camel Route: {}", (Object)configId);
        }
        this.persistenceService.remove(configId, ImportConfiguration.class);
    }

    @Override
    public void setRouterCamelContext(IRouterCamelContext routerCamelContext) {
        super.setRouterCamelContext(routerCamelContext);
    }
}

