/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.Arrays;
import org.apache.uima.cas.impl.CommonAuxHeap;
import org.apache.uima.internal.util.IntArrayUtils;
import org.apache.uima.internal.util.Misc;

public final class Heap {
    private static final boolean debugLogShrink = false;
    public static final int MIN_SIZE = 1024;
    public static final int DEFAULT_SIZE = 524288;
    private static final int MULTIPLICATION_LIMIT = 0x1000000;
    private int initialSize;
    int[] heap;
    private int pos;
    private int max;
    private final int[] shrinkableCount = new int[1];
    private static final int SIZE_POS = 0;
    private static final int TMPP_POS = 1;
    private static final int TMPM_POS = 2;
    private static final int PGSZ_POS = 5;
    private static final int AVSZ_POS = 6;
    private static final int AVST_POS = 7;

    public Heap() {
        this(524288);
    }

    public Heap(int initialSize) {
        if (initialSize < 1024) {
            initialSize = 1024;
        }
        this.initialSize = initialSize;
        this.initHeap();
    }

    private void initHeap() {
        this.heap = new int[this.initialSize];
        this.pos = 1;
        this.max = this.heap.length;
    }

    private void initHeap(int size) {
        this.heap = new int[size];
        this.pos = 1;
        this.max = this.heap.length;
    }

    void reinit(int[] md, int[] shortHeap) {
        if (md == null) {
            this.reinitNoMetaData(shortHeap);
            return;
        }
        int heapSize = md[0];
        this.pos = md[1];
        this.max = md[2];
        this.initialSize = md[5];
        this.heap = new int[heapSize];
        System.arraycopy(shortHeap, 0, this.heap, 0, shortHeap.length);
    }

    private void reinitNoMetaData(int[] shortHeap) {
        int n = this.initialSize = shortHeap.length < 1024 ? 1024 : shortHeap.length;
        if (shortHeap.length >= this.initialSize) {
            this.heap = shortHeap;
        } else {
            System.arraycopy(shortHeap, 0, this.heap, 0, shortHeap.length);
        }
        this.pos = shortHeap.length;
        this.max = this.heap.length;
    }

    void reinitSizeOnly(int newSize) {
        this.initialSize = newSize < 1024 ? 1024 : newSize;
        this.heap = new int[this.initialSize];
        this.pos = newSize;
        this.max = this.initialSize;
    }

    int getCellsUsed() {
        return this.pos;
    }

    int getHeapSize() {
        return this.heap.length;
    }

    int[] getMetaData() {
        int arSize = 7;
        int[] ar = new int[7];
        ar[0] = this.heap.length;
        ar[1] = this.pos;
        ar[2] = this.max;
        ar[5] = this.initialSize;
        boolean availablePagesSize = false;
        ar[6] = 0;
        return ar;
    }

    private void grow() {
        int start = this.heap.length;
        this.heap = IntArrayUtils.ensure_size(this.heap, start + this.initialSize, 2, 0x1000000);
        this.max = this.heap.length;
    }

    static int getRoundedSize(int size) {
        if (size < 0x1000000) {
            return Misc.nextHigherPowerOf2(size);
        }
        return size + 0x2000000;
    }

    public void reset() {
        this.reset(false);
    }

    void reset(boolean doFullReset) {
        if (doFullReset) {
            this.initHeap();
        } else {
            int curSize;
            int curCapacity = this.getHeapSize();
            int newCapacity = CommonAuxHeap.computeShrunkArraySize(curCapacity, curSize = this.getCellsUsed(), 2, 0x1000000, this.initialSize, this.shrinkableCount);
            if (newCapacity == curCapacity) {
                Arrays.fill(this.heap, 0, this.pos, 0);
            } else {
                this.initHeap(newCapacity);
            }
            this.pos = 1;
        }
    }

    public int add(int[] fs) {
        while (this.pos + fs.length >= this.max) {
            this.grow();
        }
        System.arraycopy(fs, 0, this.heap, this.pos, fs.length);
        int pos1 = this.pos;
        this.pos += fs.length;
        return pos1;
    }

    public int add(int len, int val) {
        while (this.pos + len >= this.max) {
            this.grow();
        }
        int pos1 = this.pos;
        this.pos += len;
        this.heap[pos1] = val;
        return pos1;
    }

    public int getNextId() {
        return this.pos;
    }

    public void grow(int len) {
        while (this.pos + len >= this.max) {
            this.grow();
        }
        this.pos += len;
    }

    public int getInitialSize() {
        return this.initialSize;
    }

    public int[] toArray() {
        int[] r = new int[this.pos];
        System.arraycopy(this.heap, 0, r, 0, this.pos);
        return r;
    }
}

