/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance;

import io.smallrye.faulttolerance.BeforeRetryHandlerProvider;
import io.smallrye.faulttolerance.api.BeforeRetryHandler;
import io.smallrye.faulttolerance.config.FaultToleranceOperation;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.Unmanaged;
import jakarta.inject.Inject;
import org.eclipse.microprofile.faulttolerance.ExecutionContext;

@Dependent
public class DefaultBeforeRetryHandlerProvider
implements BeforeRetryHandlerProvider {
    @Inject
    BeanManager beanManager;

    @Override
    public BeforeRetryHandler get(final FaultToleranceOperation operation) {
        if (operation.hasBeforeRetry()) {
            return new BeforeRetryHandler(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void handle(ExecutionContext context) {
                    Unmanaged unmanaged = new Unmanaged(DefaultBeforeRetryHandlerProvider.this.beanManager, operation.getBeforeRetry().value());
                    Unmanaged.UnmanagedInstance unmanagedInstance = unmanaged.newInstance();
                    BeforeRetryHandler handler = (BeforeRetryHandler)unmanagedInstance.produce().inject().postConstruct().get();
                    try {
                        handler.handle(context);
                    }
                    finally {
                        unmanagedInstance.preDestroy().dispose();
                    }
                }
            };
        }
        return null;
    }
}

