/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry.wrapper;

import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.geometry.wrapper.GeometryWrapper;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public abstract class GeometryWithCRS
extends GeometryWrapper {
    private CoordinateReferenceSystem crs;

    protected GeometryWithCRS() {
    }

    @Override
    public final CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    @Override
    public final void setCoordinateReferenceSystem(CoordinateReferenceSystem crs) {
        ArgumentChecks.ensureDimensionMatches("crs", 2, crs);
        this.crs = crs;
    }

    @Override
    public final boolean isSameCRS(GeometryWrapper other) {
        return this.crs == ((GeometryWithCRS)other).crs;
    }

    protected final GeneralEnvelope createEnvelope() {
        return this.crs != null ? new GeneralEnvelope(this.crs) : new GeneralEnvelope(2);
    }
}

