/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.jackrabbit.oak.api.ContentSession;
import org.apache.jackrabbit.oak.spi.query.SessionQuerySettings;
import org.apache.jackrabbit.oak.spi.query.SessionQuerySettingsProvider;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(configurationPolicy=ConfigurationPolicy.REQUIRE, immediate=true)
@Designate(ocd=Configuration.class)
public class SessionQuerySettingsProviderService
implements SessionQuerySettingsProvider {
    private Set<String> directCountsAllowedPrincipals = Collections.emptySet();

    void configure(Configuration config) {
        this.directCountsAllowedPrincipals = Optional.ofNullable(config).map(cfg -> new HashSet<String>(Arrays.asList(cfg.directCountsPrincipals()))).orElse(Collections.emptySet());
    }

    @Activate
    protected void activate(Configuration config) {
        this.configure(config);
    }

    @Modified
    protected void modified(Configuration config) {
        this.configure(config);
    }

    @Override
    public SessionQuerySettings getQuerySettings(@NotNull ContentSession session) {
        Set<String> principals = this.directCountsAllowedPrincipals;
        final boolean directCountsAllowed = session.getAuthInfo().getPrincipals().stream().anyMatch(principal -> principals.contains(principal.getName()));
        return new SessionQuerySettings(){

            @Override
            public boolean useDirectResultCount() {
                return directCountsAllowed;
            }
        };
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @ObjectClassDefinition(name="Apache Jackrabbit Session Query Settings Provider Service", description="Provides Session-specific query settings exposed by Oak QueryEngine.")
    public static @interface Configuration {
        @AttributeDefinition(name="Direct Counts Principals", description="Principal names for which executed query result counts directly reflect the index estimate.")
        public String[] directCountsPrincipals() default {};
    }
}

