/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.legacy;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Objects;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.metadata.internal.shared.ImplementationHelper;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.internal.shared.NilReferencingObject;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.collection.BackingStoreException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.ImageCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.cs.AffineCS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.datum.ImageDatum;

@XmlType(name="ImageCRSType", propOrder={"cartesianCS", "affineCS", "datum"})
@XmlRootElement(name="ImageCRS")
public final class DefaultImageCRS
extends AbstractCRS
implements ImageCRS {
    private static final long serialVersionUID = 7222610270977351462L;
    private ImageDatum datum;

    public DefaultImageCRS(Map<String, ?> properties, ImageDatum datum, AffineCS cs) {
        super(properties, (CoordinateSystem)cs);
        this.datum = Objects.requireNonNull(datum);
    }

    protected DefaultImageCRS(ImageCRS crs) {
        super((CoordinateReferenceSystem)crs);
    }

    public static DefaultImageCRS castOrCopy(ImageCRS object) {
        return object == null || object instanceof DefaultImageCRS ? (DefaultImageCRS)object : new DefaultImageCRS(object);
    }

    public Class<? extends ImageCRS> getInterface() {
        return ImageCRS.class;
    }

    @XmlElement(name="imageDatum", required=true)
    public ImageDatum getDatum() {
        return this.datum;
    }

    public AffineCS getCoordinateSystem() {
        return (AffineCS)super.getCoordinateSystem();
    }

    @Override
    protected String formatTo(Formatter formatter) {
        super.formatTo(formatter);
        if (formatter.getConvention().majorVersion() == 1) {
            formatter.setInvalidWKT(this, null);
        }
        return "ImageCRS";
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (super.equals(object, mode)) {
            if (mode == ComparisonMode.STRICT) {
                DefaultImageCRS that = (DefaultImageCRS)object;
                return Objects.equals(this.datum, that.datum);
            }
            SingleCRS that = (SingleCRS)object;
            return Utilities.deepEquals((Object)this.getDatum(), (Object)that.getDatum(), (ComparisonMode)mode);
        }
        return false;
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + (long)Objects.hashCode(this.datum);
    }

    private DefaultImageCRS() {
        super(Map.of("name", NilReferencingObject.UNNAMED), CommonCRS.Engineering.DISPLAY.crs().getCoordinateSystem());
    }

    private void setDatum(ImageDatum value) {
        if (this.datum == null) {
            this.datum = value;
        } else {
            ImplementationHelper.propertyAlreadySet(this.getClass(), (String)"setDatum", (String)"imageDatum");
        }
    }

    @XmlElement(name="cartesianCS")
    private CartesianCS getCartesianCS() {
        AffineCS cs = this.getCoordinateSystem();
        return cs instanceof CartesianCS ? (CartesianCS)cs : null;
    }

    @XmlElement(name="affineCS")
    private AffineCS getAffineCS() {
        AffineCS cs = this.getCoordinateSystem();
        return cs instanceof CartesianCS ? null : cs;
    }

    private void setCartesianCS(CartesianCS cs) {
        this.setAffineCS((AffineCS)cs);
    }

    private void setAffineCS(AffineCS cs) {
        try {
            Field coordinateSystem = AbstractCRS.class.getDeclaredField("coordinateSystem");
            coordinateSystem.setAccessible(true);
            coordinateSystem.set(this, cs);
        }
        catch (ReflectiveOperationException e) {
            throw new BackingStoreException((Throwable)e);
        }
    }
}

